/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.PageManager;

final class PageCursor {
    PageManager pageManager;
    long blockId;
    short type;

    PageCursor(PageManager pageManager, long blockId) {
        this.pageManager = pageManager;
        this.blockId = blockId;
    }

    PageCursor(PageManager pageManager, short type) throws IOException {
        this.pageManager = pageManager;
        this.type = type;
    }

    long getBlockId() throws IOException {
        return this.blockId;
    }

    long next() throws IOException {
        this.blockId = this.blockId == 0L ? this.pageManager.getFirst(this.type) : this.pageManager.getNext(this.blockId);
        return this.blockId;
    }

    long prev() throws IOException {
        this.blockId = this.pageManager.getPrev(this.blockId);
        return this.blockId;
    }

    public String toString() {
        return "Location( " + this.blockId + ", " + this.type + ")";
    }
}

