/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.hostmap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.knox.gateway.services.hostmap.HostMapper;

public class FileBasedHostMapper
implements HostMapper {
    private Map<String, String> inbound = new HashMap<String, String>();
    private Map<String, String> outbound = new HashMap<String, String>();

    public FileBasedHostMapper(URL url) throws IOException {
        if (url != null) {
            InputStream stream = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                String[] lineSplit = line.split("=");
                if (lineSplit.length >= 2) {
                    String[] externalSplit = lineSplit[0].split(",");
                    String[] internalSplit = lineSplit[1].split(",");
                    if (externalSplit.length >= 1 && internalSplit.length >= 1) {
                        for (String external : externalSplit) {
                            this.inbound.put(external.trim(), internalSplit[0].trim());
                        }
                        for (String internal : internalSplit) {
                            this.outbound.put(internal.trim(), externalSplit[0].trim());
                        }
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }
    }

    @Override
    public String resolveInboundHostName(String hostName) {
        String resolvedHostName = this.inbound.get(hostName);
        if (resolvedHostName == null) {
            resolvedHostName = hostName;
        }
        return resolvedHostName;
    }

    @Override
    public String resolveOutboundHostName(String hostName) {
        String resolvedHostName = this.outbound.get(hostName);
        if (resolvedHostName == null) {
            resolvedHostName = hostName;
        }
        return resolvedHostName;
    }
}

