/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.io.PrintStream;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.FormattingTriple;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LoggerConsumer;

public class DefaultServiceLog
implements PaxLogger {
    public static final String[] levels = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "AUDIT", "NONE"};
    private static int threshold;
    private Bundle m_bundle;
    private String m_categoryName;
    private PaxContext m_context = new PaxContext();

    DefaultServiceLog(Bundle bundle, String categoryName) {
        this.m_bundle = bundle;
        this.m_categoryName = categoryName;
    }

    public static int getStaticLogLevel() {
        return threshold;
    }

    private static int convertLevel(String levelName) {
        if ("TRACE".equalsIgnoreCase(levelName) || "FINER".equalsIgnoreCase(levelName)) {
            return 0;
        }
        if ("DEBUG".equalsIgnoreCase(levelName) || "FINE".equalsIgnoreCase(levelName)) {
            return 1;
        }
        if ("INFO".equalsIgnoreCase(levelName) || "CONFIG".equalsIgnoreCase(levelName) || "CONF".equalsIgnoreCase(levelName)) {
            return 2;
        }
        if ("WARN".equalsIgnoreCase(levelName) || "WARNING".equalsIgnoreCase(levelName)) {
            return 3;
        }
        if ("ERROR".equalsIgnoreCase(levelName) || "SEVERE".equalsIgnoreCase(levelName)) {
            return 4;
        }
        if ("FATAL".equalsIgnoreCase(levelName)) {
            return 5;
        }
        if ("NONE".equalsIgnoreCase(levelName) || "OFF".equalsIgnoreCase(levelName) || "DISABLED".equalsIgnoreCase(levelName)) {
            return 7;
        }
        return 1;
    }

    @Override
    public boolean isTraceEnabled() {
        return threshold <= 0;
    }

    @Override
    public boolean isDebugEnabled() {
        return threshold <= 1;
    }

    @Override
    public boolean isInfoEnabled() {
        return threshold <= 2;
    }

    @Override
    public boolean isWarnEnabled() {
        return threshold <= 3;
    }

    @Override
    public boolean isErrorEnabled() {
        return threshold <= 4;
    }

    @Override
    public boolean isFatalEnabled() {
        return threshold <= 5;
    }

    @Override
    public boolean isTraceEnabled(PaxMarker marker) {
        return threshold <= 0;
    }

    @Override
    public boolean isDebugEnabled(PaxMarker marker) {
        return threshold <= 1;
    }

    @Override
    public boolean isInfoEnabled(PaxMarker marker) {
        return threshold <= 2;
    }

    @Override
    public boolean isWarnEnabled(PaxMarker marker) {
        return threshold <= 3;
    }

    @Override
    public boolean isErrorEnabled(PaxMarker marker) {
        return threshold <= 4;
    }

    @Override
    public boolean isFatalEnabled(PaxMarker marker) {
        return threshold <= 5;
    }

    @Override
    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.output(levels[0], message, null);
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
            this.output(levels[0], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
            this.output(levels[0], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
            this.output(levels[0], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        if (this.isTraceEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public void trace(PaxMarker marker, String message) {
        this.trace(message);
    }

    @Override
    public void trace(PaxMarker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    @Override
    public void trace(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    @Override
    public void trace(PaxMarker marker, String format, Object ... arguments) {
        this.trace(format, arguments);
    }

    @Override
    public <E extends Exception> void trace(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.trace(consumer);
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.output(levels[1], message, null);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
            this.output(levels[1], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
            this.output(levels[1], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
            this.output(levels[1], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        if (this.isDebugEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public void debug(PaxMarker marker, String message) {
        this.debug(message);
    }

    @Override
    public void debug(PaxMarker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    @Override
    public void debug(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    @Override
    public void debug(PaxMarker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    @Override
    public <E extends Exception> void debug(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.debug(consumer);
    }

    @Override
    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.output(levels[2], message, null);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
            this.output(levels[2], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
            this.output(levels[2], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
            this.output(levels[2], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        if (this.isInfoEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public void info(PaxMarker marker, String message) {
        this.info(message);
    }

    @Override
    public void info(PaxMarker marker, String format, Object arg) {
        this.info(format, arg);
    }

    @Override
    public void info(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    @Override
    public void info(PaxMarker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    @Override
    public <E extends Exception> void info(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.info(consumer);
    }

    @Override
    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.output(levels[3], message, null);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
            this.output(levels[3], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
            this.output(levels[3], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
            this.output(levels[3], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        if (this.isWarnEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public void warn(PaxMarker marker, String message) {
        this.warn(message);
    }

    @Override
    public void warn(PaxMarker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    @Override
    public void warn(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    @Override
    public void warn(PaxMarker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    @Override
    public <E extends Exception> void warn(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.warn(consumer);
    }

    @Override
    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.output(levels[4], message, null);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
            this.output(levels[4], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
            this.output(levels[4], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
            this.output(levels[4], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        if (this.isErrorEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public void error(PaxMarker marker, String message) {
        this.error(message);
    }

    @Override
    public void error(PaxMarker marker, String format, Object arg) {
        this.error(format, arg);
    }

    @Override
    public void error(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    @Override
    public void error(PaxMarker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    @Override
    public <E extends Exception> void error(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.error(consumer);
    }

    @Override
    public void fatal(String message) {
        if (this.isFatalEnabled()) {
            this.output(levels[5], message, null);
        }
    }

    @Override
    public void fatal(String format, Object arg) {
        if (this.isFatalEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
            this.output(levels[5], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void fatal(String format, Object arg1, Object arg2) {
        if (this.isFatalEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
            this.output(levels[5], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void fatal(String format, Object ... arguments) {
        if (this.isFatalEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
            this.output(levels[5], ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public <E extends Exception> void fatal(LoggerConsumer<E> consumer) throws E {
        if (this.isFatalEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public void fatal(PaxMarker marker, String message) {
        this.fatal(message);
    }

    @Override
    public void fatal(PaxMarker marker, String format, Object arg) {
        this.fatal(format, arg);
    }

    @Override
    public void fatal(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.fatal(format, arg1, arg2);
    }

    @Override
    public void fatal(PaxMarker marker, String format, Object ... arguments) {
        this.fatal(format, arguments);
    }

    @Override
    public <E extends Exception> void fatal(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.fatal(consumer);
    }

    @Override
    public void audit(String message) {
        this.output(levels[6], message, null);
    }

    @Override
    public void audit(String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        this.output(levels[6], ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void audit(String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        this.output(levels[6], ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void audit(String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        this.output(levels[6], ft.getMessage(), ft.getThrowable());
    }

    @Override
    public <E extends Exception> void audit(LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void audit(PaxMarker marker, String message) {
        this.audit(message);
    }

    @Override
    public void audit(PaxMarker marker, String format, Object arg) {
        this.audit(format, arg);
    }

    @Override
    public void audit(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.audit(format, arg1, arg2);
    }

    @Override
    public void audit(PaxMarker marker, String format, Object ... arguments) {
        this.audit(format, arguments);
    }

    @Override
    public <E extends Exception> void audit(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.audit(consumer);
    }

    @Override
    public void fqtrace(String fqcn, String message) {
        this.trace(message);
    }

    @Override
    public void fqdebug(String fqcn, String message) {
        this.debug(message);
    }

    @Override
    public void fqinfo(String fqcn, String message) {
        this.info(message);
    }

    @Override
    public void fqwarn(String fqcn, String message) {
        this.warn(message);
    }

    @Override
    public void fqerror(String fqcn, String message) {
        this.error(message);
    }

    @Override
    public void fqfatal(String fqcn, String message) {
        this.fatal(message);
    }

    @Override
    public void fqtrace(String fqcn, PaxMarker marker, String message) {
        this.trace(marker, message);
    }

    @Override
    public void fqdebug(String fqcn, PaxMarker marker, String message) {
        this.debug(marker, message);
    }

    @Override
    public void fqinfo(String fqcn, PaxMarker marker, String message) {
        this.info(marker, message);
    }

    @Override
    public void fqwarn(String fqcn, PaxMarker marker, String message) {
        this.warn(marker, message);
    }

    @Override
    public void fqerror(String fqcn, PaxMarker marker, String message) {
        this.error(marker, message);
    }

    @Override
    public void fqfatal(String fqcn, PaxMarker marker, String message) {
        this.fatal(marker, message);
    }

    @Override
    public void fqtrace(String fqcn, String message, Throwable t) {
        this.trace(message, (Object)t);
    }

    @Override
    public void fqdebug(String fqcn, String message, Throwable t) {
        this.debug(message, (Object)t);
    }

    @Override
    public void fqinfo(String fqcn, String message, Throwable t) {
        this.info(message, (Object)t);
    }

    @Override
    public void fqwarn(String fqcn, String message, Throwable t) {
        this.warn(message, (Object)t);
    }

    @Override
    public void fqerror(String fqcn, String message, Throwable t) {
        this.error(message, (Object)t);
    }

    @Override
    public void fqfatal(String fqcn, String message, Throwable t) {
        this.fatal(message, (Object)t);
    }

    @Override
    public void fqtrace(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.trace(marker, message, (Object)t);
    }

    @Override
    public void fqdebug(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.debug(marker, message, (Object)t);
    }

    @Override
    public void fqinfo(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.info(marker, message, (Object)t);
    }

    @Override
    public void fqwarn(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.warn(marker, message, (Object)t);
    }

    @Override
    public void fqerror(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.error(marker, message, (Object)t);
    }

    @Override
    public void fqfatal(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.fatal(marker, message, (Object)t);
    }

    @Override
    public int getPaxLogLevel() {
        return threshold;
    }

    @Override
    public LogLevel getLogLevel() {
        switch (threshold) {
            case 6: {
                return LogLevel.AUDIT;
            }
            case 0: {
                return LogLevel.TRACE;
            }
            case 1: {
                return LogLevel.DEBUG;
            }
            case 2: {
                return LogLevel.INFO;
            }
            case 3: {
                return LogLevel.WARN;
            }
        }
        return LogLevel.ERROR;
    }

    public static void setLogLevel(String level) {
        threshold = DefaultServiceLog.convertLevel(level);
    }

    @Override
    public String getName() {
        return this.m_categoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void output(String levelName, String message, Throwable t) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            this.output(System.out, levelName, message, t);
        }
    }

    protected final void output(PrintStream out, String levelName, String message, Throwable t) {
        if (this.m_bundle != null) {
            out.print(this.m_bundle.getSymbolicName());
            out.print(" ");
        }
        out.print("[");
        out.print(this.m_categoryName);
        out.print("] ");
        out.print(levelName);
        out.print(" ");
        out.print(": ");
        out.println(message);
        if (t != null) {
            t.printStackTrace(out);
        }
    }

    @Override
    public PaxContext getPaxContext() {
        return this.m_context;
    }

    static {
        DefaultServiceLog.setLogLevel(BackendSupport.defaultLogLevel(null));
    }
}

