/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.security.SecurityUtils;

public class ECDSAPEMResourceKeyPairParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN EC PRIVATE KEY";
    public static final List<String> BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN EC PRIVATE KEY"));
    public static final String END_MARKER = "END EC PRIVATE KEY";
    public static final List<String> ENDERS = Collections.unmodifiableList(Collections.singletonList("END EC PRIVATE KEY"));
    public static final String ECDSA_OID = "1.2.840.10045.2.1";
    public static final ECDSAPEMResourceKeyPairParser INSTANCE = new ECDSAPEMResourceKeyPairParser();

    public ECDSAPEMResourceKeyPairParser() {
        super("EC", ECDSA_OID, BEGINNERS, ENDERS);
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(String resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, InputStream stream) throws IOException, GeneralSecurityException {
        Pair<ECPublicKeySpec, ECPrivateKeySpec> spec = ECDSAPEMResourceKeyPairParser.decodeECPrivateKeySpec(stream, false);
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        KeyFactory kf = SecurityUtils.getKeyFactory("EC");
        ECPublicKey pubKey = (ECPublicKey)kf.generatePublic(spec.getFirst());
        ECPrivateKey prvKey = (ECPrivateKey)kf.generatePrivate(spec.getSecond());
        KeyPair kp = new KeyPair(pubKey, prvKey);
        return Collections.singletonList(kp);
    }

    public static Pair<ECPublicKeySpec, ECPrivateKeySpec> decodeECPrivateKeySpec(InputStream inputStream, boolean okToClose) throws IOException {
        ASN1Object sequence;
        try (DERParser parser = new DERParser(NoCloseInputStream.resolveInputStream(inputStream, okToClose));){
            sequence = parser.readObject();
        }
        if (!ASN1Type.SEQUENCE.equals((Object)sequence.getObjType())) {
            throw new IOException("Invalid DER: not a sequence: " + (Object)((Object)sequence.getObjType()));
        }
        parser = sequence.createParser();
        var4_3 = null;
        try {
            ECPrivateKeySpec prvSpec = ECDSAPEMResourceKeyPairParser.decodeECPrivateKeySpec(parser);
            ECCurves curve = ECCurves.fromCurveParameters(prvSpec.getParams());
            if (curve == null) {
                throw new StreamCorruptedException("Unknown curve");
            }
            ECPoint w = ECDSAPEMResourceKeyPairParser.decodeECPublicKeyValue(curve, parser);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(w, prvSpec.getParams());
            Pair<ECPublicKeySpec, ECPrivateKeySpec> pair = new Pair<ECPublicKeySpec, ECPrivateKeySpec>(pubSpec, prvSpec);
            return pair;
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var4_3 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
    }

    public static final ECPrivateKeySpec decodeECPrivateKeySpec(DERParser parser) throws IOException {
        List<Integer> curveOID;
        ASN1Object versionObject = parser.readObject();
        if (versionObject == null) {
            throw new StreamCorruptedException("No version");
        }
        BigInteger version = versionObject.asInteger();
        if (!BigInteger.ONE.equals(version)) {
            throw new StreamCorruptedException("Bad version value: " + version);
        }
        ASN1Object keyObject = parser.readObject();
        if (keyObject == null) {
            throw new StreamCorruptedException("No private key value");
        }
        ASN1Type objType = keyObject.getObjType();
        if (!ASN1Type.OCTET_STRING.equals((Object)objType)) {
            throw new StreamCorruptedException("Non-matching private key object type: " + (Object)((Object)objType));
        }
        ASN1Object paramsObject = parser.readObject();
        if (paramsObject == null) {
            throw new StreamCorruptedException("No parameters value");
        }
        try (DERParser paramsParser = paramsObject.createParser();){
            ASN1Object namedCurve = paramsParser.readObject();
            if (namedCurve == null) {
                throw new StreamCorruptedException("Missing named curve parameter");
            }
            curveOID = namedCurve.asOID();
        }
        ECCurves curve = ECCurves.fromOIDValue(curveOID);
        if (curve == null) {
            throw new StreamCorruptedException("Unknown curve OID: " + curveOID);
        }
        BigInteger s = ECCurves.octetStringToInteger(keyObject.getPureValueBytes());
        return new ECPrivateKeySpec(s, curve.getParameters());
    }

    public static final ECPoint decodeECPublicKeyValue(ECCurves curve, DERParser parser) throws IOException {
        ASN1Object dataObject = parser.readObject();
        if (dataObject == null) {
            throw new StreamCorruptedException("No public key data bytes");
        }
        try (DERParser dataParser = dataObject.createParser();){
            ASN1Object pointData = dataParser.readObject();
            if (pointData == null) {
                throw new StreamCorruptedException("Missing public key data parameter");
            }
            ASN1Type objType = pointData.getObjType();
            if (!ASN1Type.BIT_STRING.equals((Object)objType)) {
                throw new StreamCorruptedException("Non-matching public key object type: " + (Object)((Object)objType));
            }
            byte[] octets = pointData.getValue();
            ECPoint eCPoint = ECCurves.octetStringToEcPoint(octets);
            return eCPoint;
        }
    }
}

