/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.util.InternalIdFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class WhiteboardServiceInfo<T>
extends AbstractInfo<T> {
    private final String contextSelection;
    private final Filter filter;

    public WhiteboardServiceInfo(ServiceReference<T> ref) {
        super(ref);
        String sel = this.getStringProperty(ref, "osgi.http.whiteboard.context.select");
        this.contextSelection = this.isEmpty(sel) ? "(osgi.http.whiteboard.context.name=default)" : sel;
        Filter f = null;
        try {
            BundleContext ctx;
            Bundle bundle = ref.getBundle();
            if (bundle != null && (ctx = bundle.getBundleContext()) != null) {
                f = ctx.createFilter(this.contextSelection);
            }
        }
        catch (InvalidSyntaxException ise) {
            f = null;
        }
        this.filter = f;
    }

    public WhiteboardServiceInfo(int ranking) {
        this(ranking, InternalIdFactory.INSTANCE.next());
    }

    public WhiteboardServiceInfo(int ranking, long serviceId) {
        super(ranking, serviceId);
        this.contextSelection = null;
        this.filter = null;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (this.filter != null || this.getServiceReference() == null);
    }

    public String getContextSelection() {
        return this.contextSelection;
    }

    public Filter getContextSelectionFilter() {
        return this.filter;
    }
}

