/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.nativefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.file.nativefs.NameEqualsFileFilter;
import org.apache.sshd.common.file.nativefs.NativeFileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeSshFile
implements SshFile {
    protected static final Logger LOG = LoggerFactory.getLogger(NativeSshFile.class);
    protected String fileName;
    protected File file;
    protected String userName;
    protected final NativeFileSystemView nativeFileSystemView;
    private static final Method CAN_EXECUTE_METHOD;

    protected NativeSshFile(NativeFileSystemView nativeFileSystemView, String fileName, File file, String userName) {
        this.nativeFileSystemView = nativeFileSystemView;
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file can not be null");
        }
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("fileName can not be empty");
        }
        this.fileName = fileName;
        this.file = file;
        this.userName = userName;
    }

    public File getNativeFile() {
        return this.file;
    }

    @Override
    public String getAbsolutePath() {
        char separator = this.nativeFileSystemView.getSeparator();
        String fullName = this.fileName;
        int filelen = fullName.length();
        if (this.fileName.indexOf(separator) != filelen - 1 && fullName.charAt(filelen - 1) == separator) {
            fullName = fullName.substring(0, filelen - 1);
        }
        return fullName;
    }

    @Override
    public String getName() {
        int slashIndex;
        char separator = this.nativeFileSystemView.getSeparator();
        if (this.fileName.indexOf(separator) == this.fileName.length() - 1) {
            return this.fileName;
        }
        String shortName = this.fileName;
        int filelen = this.fileName.length();
        if (shortName.charAt(filelen - 1) == separator) {
            shortName = shortName.substring(0, filelen - 1);
        }
        if ((slashIndex = shortName.lastIndexOf(separator)) != -1) {
            shortName = shortName.substring(slashIndex + 1);
        }
        return shortName;
    }

    @Override
    public String getOwner() {
        return this.userName;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean doesExist() {
        return this.file.exists();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean setLastModified(long time) {
        return this.file.setLastModified(time);
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead();
    }

    @Override
    public boolean isWritable() {
        LOG.debug("Checking if file exists");
        if (this.file.exists()) {
            LOG.debug("Checking can write: " + this.file.canWrite());
            return this.file.canWrite();
        }
        LOG.debug("Authorized");
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (CAN_EXECUTE_METHOD != null) {
            try {
                return (Boolean)CAN_EXECUTE_METHOD.invoke((Object)this.file, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.file.isDirectory();
    }

    @Override
    public boolean isRemovable() {
        char separator = this.nativeFileSystemView.getSeparator();
        if (this.fileName.indexOf(separator) == this.fileName.length() - 1) {
            return false;
        }
        String fullName = this.getAbsolutePath();
        int indexOfSlash = fullName.lastIndexOf(separator);
        String parentFullName = indexOfSlash == 0 ? "/" : (fullName.indexOf(separator) == indexOfSlash ? fullName.substring(0, indexOfSlash + 1) : fullName.substring(0, indexOfSlash));
        NativeSshFile parentObject = this.nativeFileSystemView.createNativeSshFile(parentFullName, this.file.getAbsoluteFile().getParentFile(), this.userName);
        return parentObject.isWritable();
    }

    @Override
    public SshFile getParentFile() {
        char separator = this.nativeFileSystemView.getSeparator();
        String path = this.getAbsolutePath();
        int indexOfSlash = path.lastIndexOf(separator);
        String parentFullName = indexOfSlash == 0 ? "/" : (path.indexOf(separator) == indexOfSlash ? path.substring(0, indexOfSlash + 1) : path.substring(0, indexOfSlash));
        return this.nativeFileSystemView.createNativeSshFile(parentFullName, this.file.getAbsoluteFile().getParentFile(), this.userName);
    }

    @Override
    public boolean delete() {
        boolean retVal = false;
        if (this.isRemovable()) {
            retVal = this.file.delete();
        }
        return retVal;
    }

    @Override
    public boolean create() throws IOException {
        return this.file.createNewFile();
    }

    @Override
    public void truncate() throws IOException {
        new FileWriter(this.file).close();
    }

    @Override
    public boolean move(SshFile dest) {
        boolean retVal = false;
        if (dest.isWritable() && this.isReadable()) {
            File destFile = ((NativeSshFile)dest).file;
            retVal = destFile.exists() ? false : this.file.renameTo(destFile);
        }
        return retVal;
    }

    @Override
    public boolean mkdir() {
        boolean retVal = false;
        if (this.isWritable()) {
            retVal = this.file.mkdir();
        }
        return retVal;
    }

    @Override
    public List<SshFile> listSshFiles() {
        if (!this.file.isDirectory()) {
            return null;
        }
        File[] files = this.file.listFiles();
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        char separator = this.nativeFileSystemView.getSeparator();
        String virtualFileStr = this.getAbsolutePath();
        if (virtualFileStr.charAt(virtualFileStr.length() - 1) != separator) {
            virtualFileStr = virtualFileStr + separator;
        }
        SshFile[] virtualFiles = new SshFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            File fileObj = files[i];
            String fileName = virtualFileStr + fileObj.getName();
            virtualFiles[i] = this.nativeFileSystemView.createNativeSshFile(fileName, fileObj, this.userName);
        }
        return Collections.unmodifiableList(Arrays.asList(virtualFiles));
    }

    @Override
    public OutputStream createOutputStream(long offset) throws IOException {
        if (!this.isWritable()) {
            throw new IOException("No write permission : " + this.file.getName());
        }
        final boolean canRead = this.file.canRead();
        if (!canRead) {
            this.file.setReadable(true, true);
        }
        if (offset == 0L) {
            return new FileOutputStream(this.file);
        }
        final RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        try {
            raf.seek(offset);
            return new FileOutputStream(raf.getFD()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        raf.close();
                    }
                    if (!canRead) {
                        NativeSshFile.this.file.setReadable(false, true);
                    }
                }
            };
        }
        catch (IOException e) {
            raf.close();
            throw e;
        }
    }

    @Override
    public InputStream createInputStream(long offset) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("createInputStream(" + this.file.getAbsolutePath() + ")[" + offset + "]");
        }
        if (!this.isReadable()) {
            throw new IOException("No read permission : " + this.file.getName());
        }
        FileInputStream fis = new FileInputStream(this.file);
        if (offset == 0L) {
            return fis;
        }
        try {
            FileChannel channel = fis.getChannel();
            channel.position(offset);
            return fis;
        }
        catch (IOException e) {
            fis.close();
            throw e;
        }
    }

    @Override
    public void handleClose() {
    }

    public static final String normalizeSeparateChar(String pathName) {
        String normalizedPathName = pathName.replace('\\', '/');
        return normalizedPathName;
    }

    public static final String getPhysicalName(String rootDir, String currDir, String fileName, boolean caseInsensitive) {
        String resArg;
        String normalizedRootDir = NativeSshFile.normalizeSeparateChar(rootDir);
        if (normalizedRootDir.charAt(normalizedRootDir.length() - 1) != '/') {
            normalizedRootDir = normalizedRootDir + '/';
        }
        String normalizedFileName = NativeSshFile.normalizeSeparateChar(fileName);
        String normalizedCurrDir = currDir;
        if (normalizedFileName.charAt(0) != '/') {
            if (normalizedCurrDir == null) {
                normalizedCurrDir = "/";
            }
            if (normalizedCurrDir.length() == 0) {
                normalizedCurrDir = "/";
            }
            if ((normalizedCurrDir = NativeSshFile.normalizeSeparateChar(normalizedCurrDir)).charAt(0) != '/') {
                normalizedCurrDir = '/' + normalizedCurrDir;
            }
            if (normalizedCurrDir.charAt(normalizedCurrDir.length() - 1) != '/') {
                normalizedCurrDir = normalizedCurrDir + '/';
            }
            resArg = normalizedRootDir + normalizedCurrDir.substring(1);
        } else {
            resArg = normalizedRootDir;
        }
        if (resArg.charAt(resArg.length() - 1) == '/') {
            resArg = resArg.substring(0, resArg.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(normalizedFileName, "/");
        while (st.hasMoreTokens()) {
            File[] matches;
            String tok = st.nextToken();
            if (tok.equals(".")) continue;
            if (tok.equals("..")) {
                int slashIndex;
                if (!resArg.startsWith(normalizedRootDir) || (slashIndex = resArg.lastIndexOf(47)) == -1) continue;
                resArg = resArg.substring(0, slashIndex);
                continue;
            }
            if (tok.equals("~")) {
                resArg = normalizedRootDir.substring(0, normalizedRootDir.length() - 1);
                continue;
            }
            if (caseInsensitive && (matches = new File(resArg).listFiles(new NameEqualsFileFilter(tok, true))) != null && matches.length > 0) {
                tok = matches[0].getName();
            }
            resArg = resArg + '/' + tok;
        }
        if (resArg.length() + 1 == normalizedRootDir.length()) {
            resArg = resArg + '/';
        }
        if (!resArg.regionMatches(0, normalizedRootDir, 0, normalizedRootDir.length())) {
            resArg = normalizedRootDir;
        }
        return resArg;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof NativeSshFile) {
            File otherCanonicalFile;
            File thisCanonicalFile;
            try {
                thisCanonicalFile = this.file.getCanonicalFile();
                otherCanonicalFile = ((NativeSshFile)obj).file.getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get the canonical path", e);
            }
            return thisCanonicalFile.equals(otherCanonicalFile);
        }
        return false;
    }

    public File getPhysicalFile() {
        return this.file;
    }

    public String toString() {
        return this.fileName;
    }

    @Override
    public Map<SshFile.Attribute, Object> getAttributes(boolean followLinks) throws IOException {
        HashMap<SshFile.Attribute, Object> map = new HashMap<SshFile.Attribute, Object>();
        map.put(SshFile.Attribute.Size, this.getSize());
        map.put(SshFile.Attribute.IsDirectory, this.isDirectory());
        map.put(SshFile.Attribute.IsRegularFile, this.isFile());
        map.put(SshFile.Attribute.IsSymbolicLink, false);
        map.put(SshFile.Attribute.LastModifiedTime, this.getLastModified());
        map.put(SshFile.Attribute.LastAccessTime, this.getLastModified());
        map.put(SshFile.Attribute.Owner, this.userName);
        map.put(SshFile.Attribute.Group, this.userName);
        EnumSet<SshFile.Permission> p = EnumSet.noneOf(SshFile.Permission.class);
        if (this.isReadable()) {
            p.add(SshFile.Permission.UserRead);
            p.add(SshFile.Permission.GroupRead);
            p.add(SshFile.Permission.OthersRead);
        }
        if (this.isWritable()) {
            p.add(SshFile.Permission.UserWrite);
            p.add(SshFile.Permission.GroupWrite);
            p.add(SshFile.Permission.OthersWrite);
        }
        if (this.isExecutable()) {
            p.add(SshFile.Permission.UserExecute);
            p.add(SshFile.Permission.GroupExecute);
            p.add(SshFile.Permission.OthersExecute);
        }
        map.put(SshFile.Attribute.Permissions, p);
        return map;
    }

    @Override
    public void setAttributes(Map<SshFile.Attribute, Object> attributes) throws IOException {
        HashSet<SshFile.Attribute> unsupported = new HashSet<SshFile.Attribute>();
        block4: for (SshFile.Attribute attribute : attributes.keySet()) {
            Object value = attributes.get((Object)attribute);
            switch (attribute) {
                case Size: {
                    long newSize = (Long)value;
                    FileChannel outChan = new FileOutputStream(this.file, true).getChannel();
                    outChan.truncate(newSize);
                    outChan.close();
                    continue block4;
                }
                case LastModifiedTime: {
                    this.setLastModified((Long)value);
                    continue block4;
                }
            }
            unsupported.add(attribute);
        }
        this.handleUnsupportedAttributes(unsupported);
    }

    protected void handleUnsupportedAttributes(Collection<SshFile.Attribute> attributes) {
        if (!attributes.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (SshFile.Attribute attr : attributes) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(attr.name());
            }
            switch (this.nativeFileSystemView.getUnsupportedAttributePolicy()) {
                case Ignore: {
                    break;
                }
                case Warn: {
                    LOG.warn("Unsupported attributes: " + sb.toString());
                    break;
                }
                case ThrowException: {
                    throw new UnsupportedOperationException("Unsupported attributes: " + sb.toString());
                }
            }
        }
    }

    @Override
    public Object getAttribute(SshFile.Attribute attribute, boolean followLinks) throws IOException {
        return this.getAttributes(followLinks).get((Object)attribute);
    }

    @Override
    public void setAttribute(SshFile.Attribute attribute, Object value) throws IOException {
        HashMap<SshFile.Attribute, Object> map = new HashMap<SshFile.Attribute, Object>();
        map.put(attribute, value);
        this.setAttributes(map);
    }

    @Override
    public String readSymbolicLink() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createSymbolicLink(SshFile destination) throws IOException {
        throw new UnsupportedOperationException();
    }

    static {
        Method method = null;
        try {
            method = File.class.getMethod("canExecute", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CAN_EXECUTE_METHOD = method;
    }
}

