/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.StartLevelImpl;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.startlevel.StartLevel;

class FrameworkStartLevelImpl
implements FrameworkStartLevel,
Runnable {
    static final String THREAD_NAME = "FelixStartLevel";
    private static final int BUNDLE_IDX = 0;
    private static final int STARTLEVEL_IDX = 1;
    private final Felix m_felix;
    private final ServiceRegistry m_registry;
    private final List m_requests = new ArrayList();
    private final List<FrameworkListener[]> m_requestListeners = new ArrayList<FrameworkListener[]>();
    private ServiceRegistration<StartLevel> m_slReg;
    private Thread m_thread = null;

    FrameworkStartLevelImpl(Felix felix, ServiceRegistry registry) {
        this.m_felix = felix;
        this.m_registry = registry;
    }

    void start() {
        this.m_slReg = this.m_registry.registerService(this.m_felix._getBundleContext(), new String[]{StartLevel.class.getName()}, new StartLevelImpl(this.m_felix), null);
    }

    private void startThread() {
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, THREAD_NAME);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        List list = this.m_requests;
        synchronized (list) {
            if (this.m_thread != null) {
                this.m_thread = null;
                this.m_requests.notifyAll();
            }
        }
    }

    public Bundle getBundle() {
        return this.m_felix;
    }

    public int getStartLevel() {
        return this.m_felix.getActiveStartLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartLevel(int startlevel, FrameworkListener ... listeners) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this.m_felix, "startlevel"));
        }
        if (startlevel <= 0) {
            throw new IllegalArgumentException("Start level must be greater than zero.");
        }
        List list = this.m_requests;
        synchronized (list) {
            this.startThread();
            this.m_requestListeners.add(listeners);
            this.m_requests.add(new Integer(startlevel));
            this.m_requests.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStartLevelAndWait(int startlevel) {
        Integer request;
        Integer n = request = new Integer(startlevel);
        synchronized (n) {
            List list = this.m_requests;
            synchronized (list) {
                this.startThread();
                this.m_requestListeners.add(null);
                this.m_requests.add(request);
                this.m_requests.notifyAll();
            }
            try {
                request.wait();
            }
            catch (InterruptedException ex) {
                this.m_felix.getLogger().log(2, "Wait for start level change during shutdown interrupted.", ex);
            }
        }
    }

    public int getInitialBundleStartLevel() {
        return this.m_felix.getInitialBundleStartLevel();
    }

    public void setInitialBundleStartLevel(int startlevel) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this.m_felix, "startlevel"));
        }
        this.m_felix.setInitialBundleStartLevel(startlevel);
    }

    BundleStartLevel createBundleStartLevel(BundleImpl bundle) {
        return new BundleStartLevelImpl(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object previousRequest = null;
        while (true) {
            Object request = null;
            FrameworkListener[] listeners = null;
            List list = this.m_requests;
            synchronized (list) {
                while (this.m_requests.isEmpty()) {
                    if (this.m_thread == null) {
                        return;
                    }
                    try {
                        this.m_requests.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                request = this.m_requests.remove(0);
                listeners = this.m_requestListeners.remove(0);
            }
            if (request instanceof Integer) {
                try {
                    this.m_felix.setActiveStartLevel((Integer)request, listeners);
                }
                catch (IllegalStateException ise) {
                    if (previousRequest == request) {
                        this.m_felix.getLogger().log(1, "Unexpected problem setting active start level to " + request, ise);
                    }
                    List ex = this.m_requests;
                    synchronized (ex) {
                        this.m_requests.add(0, request);
                        previousRequest = request;
                    }
                }
                catch (Exception ex) {
                    this.m_felix.getLogger().log(1, "Unexpected problem setting active start level to " + request, ex);
                }
            } else {
                Bundle bundle = (Bundle)((Object[])request)[0];
                int startlevel = (Integer)((Object[])request)[1];
                this.m_felix.setBundleStartLevel(bundle, startlevel);
            }
            list = request;
            synchronized (list) {
                request.notifyAll();
            }
        }
    }

    class BundleStartLevelImpl
    implements BundleStartLevel {
        private BundleImpl m_bundle;

        private BundleStartLevelImpl(BundleImpl bundle) {
            this.m_bundle = bundle;
        }

        public Bundle getBundle() {
            return this.m_bundle;
        }

        public int getStartLevel() {
            return FrameworkStartLevelImpl.this.m_felix.getBundleStartLevel(this.m_bundle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStartLevel(int startlevel) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new AdminPermission(this.m_bundle, "execute"));
            }
            if (this.m_bundle.getBundleId() == 0L) {
                throw new IllegalArgumentException("Cannot change system bundle start level.");
            }
            if (startlevel <= 0) {
                throw new IllegalArgumentException("Start level must be greater than zero.");
            }
            List list = FrameworkStartLevelImpl.this.m_requests;
            synchronized (list) {
                FrameworkStartLevelImpl.this.startThread();
                this.m_bundle.setStartLevel(startlevel);
                FrameworkStartLevelImpl.this.m_requestListeners.add(null);
                FrameworkStartLevelImpl.this.m_requests.add(new Object[]{this.m_bundle, new Integer(startlevel)});
                FrameworkStartLevelImpl.this.m_requests.notifyAll();
            }
        }

        public boolean isPersistentlyStarted() {
            return FrameworkStartLevelImpl.this.m_felix.isBundlePersistentlyStarted(this.m_bundle);
        }

        public boolean isActivationPolicyUsed() {
            return FrameworkStartLevelImpl.this.m_felix.isBundleActivationPolicyUsed(this.m_bundle);
        }
    }
}

