/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.uon.UonReader;

public final class RestUtils {
    private static Map<Integer, String> httpMsgs = CollectionUtils.mapBuilder(Integer.class, String.class, new Type[0]).add(100, "Continue").add(101, "Switching Protocols").add(102, "Processing").add(103, "Early Hints").add(200, "OK").add(201, "Created").add(202, "Accepted").add(203, "Non-Authoritative Information").add(204, "No Content").add(205, "Reset Content").add(206, "Partial Content").add(300, "Multiple Choices").add(301, "Moved Permanently").add(302, "Temporary Redirect").add(303, "See Other").add(304, "Not Modified").add(305, "Use Proxy").add(307, "Temporary Redirect").add(400, "Bad Request").add(401, "Unauthorized").add(402, "Payment Required").add(403, "Forbidden").add(404, "Not Found").add(405, "Method Not Allowed").add(406, "Not Acceptable").add(407, "Proxy Authentication Required").add(408, "Request Time-Out").add(409, "Conflict").add(410, "Gone").add(411, "Length Required").add(412, "Precondition Failed").add(413, "Request Entity Too Large").add(414, "Request-URI Too Large").add(415, "Unsupported Media Type").add(500, "Internal Server Error").add(501, "Not Implemented").add(502, "Bad Gateway").add(503, "Service Unavailable").add(504, "Gateway Timeout").add(505, "HTTP Version Not Supported").build();
    private static final Pattern INDEXED_LINK_PATTERN = Pattern.compile("(?s)(\\S*)\\[(\\d+)\\]\\:(.*)");

    public static String getHttpResponseText(int rc) {
        return httpMsgs.get(rc);
    }

    public static String getPathInfoUndecoded(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        int l = contextPath.length() + servletPath.length();
        if (requestURI.length() == l) {
            return null;
        }
        return requestURI.substring(l);
    }

    public static StringBuffer trimPathInfo(StringBuffer requestURI, String contextPath, String servletPath) {
        if (servletPath.equals("/")) {
            servletPath = "";
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        try {
            int sc = 0;
            for (int i = 0; i < requestURI.length(); ++i) {
                int c = requestURI.charAt(i);
                if (c == 47) {
                    int j;
                    if (++sc != 3) continue;
                    if (servletPath.isEmpty()) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    for (j = 0; j < contextPath.length(); ++j) {
                        if (requestURI.charAt(i) != contextPath.charAt(j)) {
                            throw new Exception("case=1");
                        }
                        ++i;
                    }
                    for (j = 0; j < servletPath.length(); ++j) {
                        if (requestURI.charAt(i) != servletPath.charAt(j)) {
                            throw new Exception("case=2");
                        }
                        ++i;
                    }
                    int n = c = requestURI.length() == i ? 47 : (int)requestURI.charAt(i);
                    if (c == 47 || c == 63) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    throw new Exception("case=3");
                }
                if (c != 63) continue;
                if (sc != 2) {
                    throw new Exception("case=4");
                }
                if (servletPath.isEmpty()) {
                    requestURI.setLength(i);
                    return requestURI;
                }
                throw new Exception("case=5");
            }
            if (servletPath.isEmpty()) {
                return requestURI;
            }
            throw new Exception("case=6");
        }
        catch (Exception e) {
            throw new BasicRuntimeException(e, "Could not find servlet path in request URI.  URI=''{0}'', servletPath=''{1}''", requestURI, servletPath);
        }
    }

    public static String[] parseHeader(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            i = s.indexOf(61);
        }
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim().toLowerCase(Locale.ENGLISH);
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }

    public static String[] parseKeyValuePair(String s) {
        int i = -1;
        for (int j = 0; j < s.length() && i < 0; ++j) {
            char c = s.charAt(j);
            if (c != '=' && c != ':') continue;
            i = j;
        }
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim();
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }

    static String resolveNewlineSeparatedAnnotation(String[] value, String fromParent) {
        if (value.length == 0) {
            return fromParent;
        }
        ArrayList<String> l = CollectionUtils.list(new String[0]);
        for (String v : value) {
            if (!"INHERIT".equals(v)) {
                l.add(v);
                continue;
            }
            if (fromParent == null) continue;
            l.add(fromParent);
        }
        return StringUtils.join(l, '\n');
    }

    static String[] resolveLinks(String[] links, String[] parentLinks) {
        if (links.length == 0) {
            return parentLinks;
        }
        ArrayList<String> list = CollectionUtils.list(new String[0]);
        for (String l : links) {
            if ("INHERIT".equals(l)) {
                CollectionUtils.addAll(list, parentLinks);
                continue;
            }
            if (l.indexOf(91) != -1 && INDEXED_LINK_PATTERN.matcher(l).matches()) {
                Matcher lm = INDEXED_LINK_PATTERN.matcher(l);
                lm.matches();
                String key = lm.group(1);
                int index = Math.min(list.size(), Integer.parseInt(lm.group(2)));
                String remainder = lm.group(3);
                list.add(index, (String)(key.isEmpty() ? remainder : key + ":" + remainder));
                continue;
            }
            list.add(l);
        }
        return CollectionUtils.array(list, String.class);
    }

    static String[] resolveContent(String[] content, String[] parentContent) {
        if (content.length == 0) {
            return parentContent;
        }
        ArrayList<String> list = CollectionUtils.list(new String[0]);
        for (String l : content) {
            if ("INHERIT".equals(l)) {
                CollectionUtils.addAll(list, parentContent);
                continue;
            }
            if ("NONE".equals(l)) {
                return new String[0];
            }
            list.add(l);
        }
        return CollectionUtils.array(list, String.class);
    }

    public static Map<String, String[]> parseQuery(Object qs) {
        return RestUtils.parseQuery(qs, null);
    }

    public static Map<String, String[]> parseQuery(Object qs, Map<String, String[]> map) {
        Map<String, String[]> m = map;
        if (m == null) {
            m = CollectionUtils.map();
        }
        if (qs == null || qs instanceof CharSequence && StringUtils.isEmpty(StringUtils.stringify(qs))) {
            return m;
        }
        ParserPipe p = new ParserPipe(qs);
        try {
            boolean S1 = true;
            int S2 = 2;
            int S3 = 3;
            int S4 = 4;
            try (UonReader r = new UonReader(p, true);){
                int c = r.peekSkipWs();
                if (c == 63) {
                    r.read();
                }
                int state = 1;
                String currAttr = null;
                while (c != -1) {
                    c = r.read();
                    if (state == 1) {
                        if (c == -1) continue;
                        r.unread();
                        r.mark();
                        state = 2;
                        continue;
                    }
                    if (state == 2) {
                        if (c == -1) {
                            RestUtils.add(m, r.getMarked(), null);
                            continue;
                        }
                        if (c == 1) {
                            m.put(r.getMarked(0, -1), null);
                            state = 1;
                            continue;
                        }
                        if (c != 2) continue;
                        currAttr = r.getMarked(0, -1);
                        state = 3;
                        continue;
                    }
                    if (state == 3) {
                        if (c == -1 || c == 1) {
                            RestUtils.add(m, currAttr, "");
                            state = 1;
                            continue;
                        }
                        if (c == 2) {
                            r.replace('=');
                        }
                        r.unread();
                        r.mark();
                        state = 4;
                        continue;
                    }
                    if (state != 4) continue;
                    if (c == -1) {
                        RestUtils.add(m, currAttr, r.getMarked());
                        continue;
                    }
                    if (c == 1) {
                        RestUtils.add(m, currAttr, r.getMarked(0, -1));
                        state = 1;
                        continue;
                    }
                    if (c != 2) continue;
                    r.replace('=');
                }
            }
            Map<String, String[]> map2 = m;
            p.close();
            return map2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    p.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ThrowableUtils.asRuntimeException(e);
            }
        }
    }

    private static void add(Map<String, String[]> m, String key, String val) {
        boolean b = m.containsKey(key);
        if (val == null) {
            if (!b) {
                m.put(key, null);
            }
        } else if (b && m.get(key) != null) {
            m.put(key, ArrayUtils.append(m.get(key), val));
        } else {
            m.put(key, new String[]{val});
        }
    }

    public static Object parseAnything(String s) throws ParseException {
        if (StringUtils.isJson(s)) {
            return JsonParser.DEFAULT.parse(s, Object.class);
        }
        return s;
    }

    public static String trimContextPath(String contextPath, String path) {
        if (path == null) {
            return null;
        }
        if (path.isEmpty() || path.equals("/") || contextPath.isEmpty() || contextPath.equals("/")) {
            return path;
        }
        String op = path;
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (contextPath.charAt(0) == '/') {
            contextPath = contextPath.substring(1);
        }
        if (path.startsWith(contextPath)) {
            if (path.length() == contextPath.length()) {
                return "/";
            }
            if ((path = path.substring(contextPath.length())).isEmpty() || path.charAt(0) == '/') {
                return path;
            }
        }
        return op;
    }

    public static String fixMethodPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals("/")) {
            return path;
        }
        return StringUtils.trimTrailingSlashes(path);
    }

    public static boolean isValidContextPath(String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        return value.charAt(value.length() - 1) != '/' && value.charAt(0) == '/';
    }

    public static String toValidContextPath(String s) {
        if (s == null || ((String)s).isEmpty()) {
            return "";
        }
        if (((String)(s = StringUtils.trimTrailingSlashes((String)s))).isEmpty()) {
            return s;
        }
        if (((String)s).charAt(0) != '/') {
            s = "/" + (String)s;
        }
        return s;
    }

    public static void validateContextPath(String value) {
        if (!RestUtils.isValidContextPath(value)) {
            throw new BasicRuntimeException("Value is not a valid context path: [{0}]", value);
        }
    }

    public static boolean isValidServletPath(String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        return !value.equals("/") && value.charAt(value.length() - 1) != '/' && value.charAt(0) == '/';
    }

    public static void validateServletPath(String value) {
        if (!RestUtils.isValidServletPath(value)) {
            throw new BasicRuntimeException("Value is not a valid servlet path: [{0}]", value);
        }
    }

    public static boolean isValidPathInfo(String value) {
        if (value == null) {
            return true;
        }
        return !value.isEmpty() && value.charAt(0) == '/';
    }

    public static void validatePathInfo(String value) {
        if (!RestUtils.isValidPathInfo(value)) {
            throw new BasicRuntimeException("Value is not a valid path-info path: [{0}]", value);
        }
    }
}

