/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.http.HttpResponse;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.HttpExceptionBuilder;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.stats.MethodExecStats;
import org.apache.juneau.rest.stats.MethodInvoker;

public class RestOpInvoker
extends MethodInvoker {
    private final RestOpArg[] opArgs;

    public RestOpInvoker(Method m, RestOpArg[] opArgs, MethodExecStats stats) {
        super(m, stats);
        this.opArgs = opArgs;
    }

    public void invoke(RestOpSession opSession) throws Throwable {
        Object[] args = new Object[this.opArgs.length];
        for (int i = 0; i < this.opArgs.length; ++i) {
            ParamInfo pi = this.inner().getParam(i);
            try {
                args[i] = this.opArgs[i].resolve(opSession);
                continue;
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, BadRequest.class, "Could not resolve parameter {0} of type ''{1}'' on method ''{2}''.", i, pi.getParameterType(), this.getFullName());
            }
        }
        try {
            RestSession session = opSession.getRestSession();
            RestRequest req = opSession.getRequest();
            RestResponse res = opSession.getResponse();
            Object output = super.invoke(session.getResource(), args);
            Boolean debug = req.getAttribute("Debug").as(Boolean.class).orElse(null);
            if (debug == Boolean.TRUE) {
                session.debug(true);
            } else if (debug == Boolean.FALSE) {
                session.debug(false);
            }
            if (!(this.inner().hasReturnType(Void.TYPE) || output == null && res.getOutputStreamCalled())) {
                res.setContent(output);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw (InternalServerError)((HttpExceptionBuilder)((HttpExceptionBuilder)InternalServerError.create().message("Error occurred invoking method ''{0}''.", new Object[]{this.inner().getFullName()})).causedBy(e)).build();
        }
        catch (InvocationTargetException e) {
            RestResponse res = opSession.getResponse();
            Throwable e2 = e.getTargetException();
            res.setStatus(500);
            Class<?> c = e2.getClass();
            if (e2 instanceof HttpResponse || c.getAnnotation(Response.class) != null || c.getAnnotation(Content.class) != null) {
                res.setContent(e2);
            }
            throw HttpRuntimeException.toHttpException(e2, InternalServerError.class, "Method ''{0}'' threw an unexpected exception.", this.getFullName());
        }
    }
}

