/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.dto.openapi3.Encoding;
import org.apache.juneau.dto.openapi3.Example;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.dto.openapi3.SchemaInfo;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="schema,example,examples,encoding,*")
@FluentSetters
public class MediaType
extends OpenApiElement {
    private SchemaInfo schema;
    private Object example;
    private Map<String, Example> examples;
    private Map<String, Encoding> encoding;

    public MediaType() {
    }

    public MediaType(MediaType copyFrom) {
        super(copyFrom);
        this.schema = copyFrom.schema;
        this.example = copyFrom.example;
        this.examples = copyFrom.examples == null ? null : new LinkedHashMap<String, Example>();
        for (Map.Entry<String, Example> entry : copyFrom.examples.entrySet()) {
            this.examples.put(entry.getKey(), entry.getValue().copy());
        }
        this.encoding = copyFrom.encoding == null ? null : new LinkedHashMap<String, Encoding>();
        for (Map.Entry<String, OpenApiElement> entry : copyFrom.encoding.entrySet()) {
            this.encoding.put(entry.getKey(), ((Encoding)entry.getValue()).copy());
        }
    }

    public MediaType copy() {
        return new MediaType(this);
    }

    @Override
    protected MediaType strict() {
        super.strict();
        return this;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public MediaType setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    @Beanp(value="x-example")
    public Object getExample() {
        return this.example;
    }

    @Beanp(value="x-example")
    public MediaType setExample(Object value) {
        this.example = value;
        return this;
    }

    public Map<String, Encoding> getEncoding() {
        return this.encoding;
    }

    public MediaType setEncoding(Map<String, Encoding> value) {
        this.encoding = CollectionUtils.copyOf(value);
        return this;
    }

    public MediaType addEncoding(String key, Encoding value) {
        this.encoding = CollectionUtils.mapBuilder(this.encoding).sparse().add((Object)key, (Object)value).build();
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public MediaType setExamples(Map<String, Example> value) {
        this.examples = CollectionUtils.copyOf(value);
        return this;
    }

    public MediaType addExample(String name, Example example) {
        this.examples = CollectionUtils.mapBuilder(this.examples).add((Object)name, (Object)example).build();
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "schema": {
                return (T)ConverterUtils.toType((Object)this.getSchema(), type);
            }
            case "example": {
                return (T)ConverterUtils.toType((Object)this.getExample(), type);
            }
            case "examples": {
                return (T)ConverterUtils.toType(this.getExamples(), type);
            }
            case "encoding": {
                return (T)ConverterUtils.toType(this.getEncoding(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public MediaType set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "schema": {
                return this.setSchema((SchemaInfo)ConverterUtils.toType((Object)value, SchemaInfo.class));
            }
            case "example": {
                return this.setExample(value);
            }
            case "examples": {
                return this.setExamples(CollectionUtils.mapBuilder(String.class, Example.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "encoding": {
                return this.setEncoding(CollectionUtils.mapBuilder(String.class, Encoding.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).addIf(this.schema != null, (Object)"schema").addIf(this.example != null, (Object)"example").addIf(this.encoding != null, (Object)"encoding").addIf(this.examples != null, (Object)"examples").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }
}

