/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

@FluentSetters
public class ExceptionBuilder<T extends Throwable> {
    private final Class<T> type;
    private String message;
    private Throwable causedBy;

    public ExceptionBuilder(Class<T> type) {
        this.type = type;
    }

    @FluentSetter
    public ExceptionBuilder<T> message(String msg, Object ... args) {
        this.message = StringUtils.format(msg, args);
        return this;
    }

    @FluentSetter
    public ExceptionBuilder<T> causedBy(Throwable value) {
        this.causedBy = value;
        return this;
    }

    public T build() {
        try {
            return (T)((Throwable)this.type.getConstructor(String.class, Throwable.class).newInstance(this.message, this.causedBy));
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }
}

