/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena.annotation;

import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfParser;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.annotation.RdfConfig;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.xml.Namespace;

public class RdfConfigAnnotation {

    public static class ParserApply
    extends AnnotationApplier<RdfConfig, RdfParser.Builder> {
        public ParserApply(VarResolverSession vr) {
            super(RdfConfig.class, RdfParser.Builder.class, vr);
        }

        public void apply(AnnotationInfo<RdfConfig> ai, RdfParser.Builder b) {
            RdfConfig a = (RdfConfig)ai.inner();
            this.string(a.language()).ifPresent(x -> b.language((String)x));
            this.string(a.juneauNs()).map(Namespace::of).ifPresent(x -> b.juneauNs((Namespace)x));
            this.string(a.juneauBpNs()).map(Namespace::of).ifPresent(x -> b.juneauBpNs((Namespace)x));
            this.string(a.collectionFormat()).map(RdfCollectionFormat::valueOf).ifPresent(x -> b.collectionFormat((RdfCollectionFormat)((Object)x)));
            this.bool(a.looseCollections()).ifPresent(x -> b.looseCollections((boolean)x));
            this.bool(a.trimWhitespace()).ifPresent(x -> b.trimWhitespace((boolean)x));
            this.string(a.rdfxml_iriRules()).ifPresent(x -> b.rdfxml_iriRules((String)x));
            this.string(a.rdfxml_errorMode()).ifPresent(x -> b.rdfxml_errorMode((String)x));
            this.bool(a.rdfxml_embedding()).ifPresent(x -> b.rdfxml_embedding((boolean)x));
            this.string(a.rdfxml_xmlBase()).ifPresent(x -> b.rdfxml_xmlbase((String)x));
            this.bool(a.rdfxml_longId()).ifPresent(x -> b.rdfxml_longId((boolean)x));
            this.bool(a.rdfxml_allowBadUris()).ifPresent(x -> b.rdfxml_allowBadUris((boolean)x));
            this.string(a.rdfxml_relativeUris()).ifPresent(x -> b.rdfxml_relativeUris((String)x));
            this.string(a.rdfxml_showXmlDeclaration()).ifPresent(x -> b.rdfxml_showXmlDeclaration((String)x));
            this.bool(a.rdfxml_disableShowDoctypeDeclaration()).ifPresent(x -> b.rdfxml_disableShowDoctypeDeclaration((boolean)x));
            this.integer(a.rdfxml_tab(), "rdfxml_tab").ifPresent(x -> b.rdfxml_tab((int)x));
            this.string(a.rdfxml_attributeQuoteChar()).map(x -> Character.valueOf(x.charAt(0))).ifPresent(x -> b.rdfxml_attributeQuoteChar(x.charValue()));
            this.string(a.rdfxml_blockRules()).ifPresent(x -> b.rdfxml_blockRules((String)x));
            this.integer(a.n3_minGap(), "n3_minGap").ifPresent(x -> b.n3_minGap((int)x));
            this.bool(a.n3_disableObjectLists()).ifPresent(x -> b.n3_disableObjectLists((boolean)x));
            this.integer(a.n3_subjectColumn(), "n3_subjectColumn").ifPresent(x -> b.n3_subjectColumn((int)x));
            this.integer(a.n3_propertyColumn(), "n3_propertyColumn").ifPresent(x -> b.n3_propertyColumn((int)x));
            this.integer(a.n3_indentProperty(), "n3_indentProperty").ifPresent(x -> b.n3_indentProperty((int)x));
            this.integer(a.n3_widePropertyLen(), "n3_widePropertyLen").ifPresent(x -> b.n3_widePropertyLen((int)x));
            this.bool(a.n3_disableAbbrevBaseUri()).ifPresent(x -> b.n3_disableAbbrevBaseUri((boolean)x));
            this.bool(a.n3_disableUsePropertySymbols()).ifPresent(x -> b.n3_disableUsePropertySymbols((boolean)x));
            this.bool(a.n3_disableUseTripleQuotedStrings()).ifPresent(x -> b.n3_disableUseTripleQuotedStrings((boolean)x));
            this.bool(a.n3_disableUseDoubles()).ifPresent(x -> b.n3_disableUseDoubles((boolean)x));
        }
    }

    public static class SerializerApply
    extends AnnotationApplier<RdfConfig, RdfSerializer.Builder> {
        public SerializerApply(VarResolverSession vr) {
            super(RdfConfig.class, RdfSerializer.Builder.class, vr);
        }

        public void apply(AnnotationInfo<RdfConfig> ai, RdfSerializer.Builder b) {
            RdfConfig a = (RdfConfig)ai.inner();
            this.string(a.language()).ifPresent(x -> b.language((String)x));
            this.string(a.juneauNs()).map(Namespace::of).ifPresent(x -> b.juneauNs((Namespace)x));
            this.string(a.juneauBpNs()).map(Namespace::of).ifPresent(x -> b.juneauBpNs((Namespace)x));
            this.bool(a.disableUseXmlNamespaces()).ifPresent(x -> b.disableUseXmlNamespaces((boolean)x));
            this.string(a.collectionFormat()).map(RdfCollectionFormat::valueOf).ifPresent(x -> b.collectionFormat((RdfCollectionFormat)((Object)x)));
            this.bool(a.looseCollections()).ifPresent(x -> b.looseCollections((boolean)x));
            this.bool(a.addBeanTypes()).ifPresent(x -> b.addBeanTypesRdf((boolean)x));
            this.bool(a.addLiteralTypes()).ifPresent(x -> b.addLiteralTypes((boolean)x));
            this.bool(a.addRootProperty()).ifPresent(x -> b.addRootProperty((boolean)x));
            this.bool(a.disableAutoDetectNamespaces()).ifPresent(x -> b.disableAutoDetectNamespaces((boolean)x));
            this.strings(a.namespaces()).map(Namespace::createArray).ifPresent(x -> b.namespaces((Namespace)x));
            this.string(a.rdfxml_iriRules()).ifPresent(x -> b.rdfxml_iriRules((String)x));
            this.string(a.rdfxml_errorMode()).ifPresent(x -> b.rdfxml_errorMode((String)x));
            this.bool(a.rdfxml_embedding()).ifPresent(x -> b.rdfxml_embedding((boolean)x));
            this.string(a.rdfxml_xmlBase()).ifPresent(x -> b.rdfxml_xmlbase((String)x));
            this.bool(a.rdfxml_longId()).ifPresent(x -> b.rdfxml_longId((boolean)x));
            this.bool(a.rdfxml_allowBadUris()).ifPresent(x -> b.rdfxml_allowBadUris((boolean)x));
            this.string(a.rdfxml_relativeUris()).ifPresent(x -> b.rdfxml_relativeUris((String)x));
            this.string(a.rdfxml_showXmlDeclaration()).ifPresent(x -> b.rdfxml_showXmlDeclaration((String)x));
            this.bool(a.rdfxml_disableShowDoctypeDeclaration()).ifPresent(x -> b.rdfxml_disableShowDoctypeDeclaration((boolean)x));
            this.integer(a.rdfxml_tab(), "rdfxml_tab").ifPresent(x -> b.rdfxml_tab((int)x));
            this.string(a.rdfxml_attributeQuoteChar()).map(x -> Character.valueOf(x.charAt(0))).ifPresent(x -> b.rdfxml_attributeQuoteChar(x.charValue()));
            this.string(a.rdfxml_blockRules()).ifPresent(x -> b.rdfxml_blockRules((String)x));
            this.integer(a.n3_minGap(), "n3_minGap").ifPresent(x -> b.n3_minGap((int)x));
            this.bool(a.n3_disableObjectLists()).ifPresent(x -> b.n3_disableObjectLists((boolean)x));
            this.integer(a.n3_subjectColumn(), "n3_subjectColumn").ifPresent(x -> b.n3_subjectColumn((int)x));
            this.integer(a.n3_propertyColumn(), "n3_propertyColumn").ifPresent(x -> b.n3_propertyColumn((int)x));
            this.integer(a.n3_indentProperty(), "n3_indentProperty").ifPresent(x -> b.n3_indentProperty((int)x));
            this.integer(a.n3_widePropertyLen(), "n3_widePropertyLen").ifPresent(x -> b.n3_widePropertyLen((int)x));
            this.bool(a.n3_disableAbbrevBaseUri()).ifPresent(x -> b.n3_disableAbbrevBaseUri((boolean)x));
            this.bool(a.n3_disableUsePropertySymbols()).ifPresent(x -> b.n3_disableUsePropertySymbols((boolean)x));
            this.bool(a.n3_disableUseTripleQuotedStrings()).ifPresent(x -> b.n3_disableUseTripleQuotedStrings((boolean)x));
            this.bool(a.n3_disableUseDoubles()).ifPresent(x -> b.n3_disableUseDoubles((boolean)x));
        }
    }
}

