/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.ASortedMap;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfClassMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommon;
import org.apache.juneau.jena.RdfMetaProvider;
import org.apache.juneau.jena.RdfParserBuilder;
import org.apache.juneau.jena.RdfParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlMetaProvider;

@ConfigurableContext(prefixes={"RdfCommon", "RdfParser"})
public class RdfParser
extends ReaderParser
implements RdfCommon,
RdfMetaProvider {
    private static final Namespace DEFAULT_JUNEAU_NS = Namespace.create((String)"j", (String)"http://www.apache.org/juneau/");
    private static final Namespace DEFAULT_JUNEAUBP_NS = Namespace.create((String)"jp", (String)"http://www.apache.org/juneaubp/");
    static final String PREFIX = "RdfParser";
    public static final String RDF_trimWhitespace = "RdfParser.trimWhitespace.b";
    private final boolean trimWhitespace;
    private final boolean looseCollections;
    private final String rdfLanguage;
    private final Namespace juneauNs;
    private final Namespace juneauBpNs;
    private final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaProperties;
    private final Map<ClassMeta<?>, RdfClassMeta> rdfClassMetas = new ConcurrentHashMap();
    private final Map<BeanMeta<?>, RdfBeanMeta> rdfBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, RdfBeanPropertyMeta> rdfBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, RdfBeanPropertyMeta>();
    private final Map<ClassMeta<?>, XmlClassMeta> xmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanMeta<?>, XmlBeanMeta> xmlBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, XmlBeanPropertyMeta> xmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, XmlBeanPropertyMeta>();

    public RdfParser(PropertyStore ps, String ... consumes) {
        super(ps, consumes);
        this.trimWhitespace = this.getBooleanProperty(RDF_trimWhitespace, false);
        this.looseCollections = this.getBooleanProperty("RdfCommon.looseCollections.b", false);
        this.rdfLanguage = this.getStringProperty("RdfCommon.language.s", "RDF/XML-ABBREV");
        this.juneauNs = (Namespace)this.getInstanceProperty("RdfCommon.juneauNs.s", Namespace.class, DEFAULT_JUNEAU_NS);
        this.juneauBpNs = (Namespace)this.getInstanceProperty("RdfCommon.juneauBpNs.s", Namespace.class, DEFAULT_JUNEAUBP_NS);
        this.collectionFormat = (RdfCollectionFormat)((Object)this.getProperty("RdfCommon.collectionFormat.s", RdfCollectionFormat.class, (Object)RdfCollectionFormat.DEFAULT));
        ASortedMap m = ASortedMap.of();
        for (String k : this.getPropertyKeys("RdfCommon")) {
            if (!k.startsWith("jena.")) continue;
            m.put((Object)k.substring(5), this.getProperty("RdfCommon." + k));
        }
        this.jenaProperties = m.unmodifiable();
    }

    public RdfParser(PropertyStore ps) {
        this(ps, RdfParser.getConsumes(ps));
    }

    private static String getConsumes(PropertyStore ps) {
        String rdfLanguage;
        switch (rdfLanguage = (String)ps.getProperty("RdfCommon.language.s", String.class, (Object)"RDF/XML-ABBREV")) {
            case "RDF/XML": 
            case "RDF/XML-ABBREV": {
                return "text/xml+rdf";
            }
            case "N-TRIPLE": {
                return "text/n-triple";
            }
            case "N3": {
                return "text/n3";
            }
            case "N3-PP": {
                return "text/n3-pp";
            }
            case "N3-PLAIN": {
                return "text/n3-plain";
            }
            case "N3-TRIPLES": {
                return "text/n3-triples";
            }
            case "TURTLE": {
                return "text/turtle";
            }
        }
        return "text/xml+rdf";
    }

    public RdfParserBuilder builder() {
        return new RdfParserBuilder(this.getPropertyStore());
    }

    public static RdfParserBuilder create() {
        return new RdfParserBuilder();
    }

    public RdfParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    public RdfParserSession createSession(ParserSessionArgs args) {
        return new RdfParserSession(this, args);
    }

    @Override
    public RdfClassMeta getRdfClassMeta(ClassMeta<?> cm) {
        RdfClassMeta m = this.rdfClassMetas.get(cm);
        if (m == null) {
            m = new RdfClassMeta(cm, this);
            this.rdfClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public RdfBeanMeta getRdfBeanMeta(BeanMeta<?> bm) {
        RdfBeanMeta m = this.rdfBeanMetas.get(bm);
        if (m == null) {
            m = new RdfBeanMeta(bm, this);
            this.rdfBeanMetas.put(bm, m);
        }
        return m;
    }

    @Override
    public RdfBeanPropertyMeta getRdfBeanPropertyMeta(BeanPropertyMeta bpm) {
        RdfBeanPropertyMeta m = this.rdfBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new RdfBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.rdfBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    public XmlClassMeta getXmlClassMeta(ClassMeta<?> cm) {
        XmlClassMeta m = this.xmlClassMetas.get(cm);
        if (m == null) {
            m = new XmlClassMeta(cm, (XmlMetaProvider)this);
            this.xmlClassMetas.put(cm, m);
        }
        return m;
    }

    public XmlBeanMeta getXmlBeanMeta(BeanMeta<?> bm) {
        XmlBeanMeta m = this.xmlBeanMetas.get(bm);
        if (m == null) {
            m = new XmlBeanMeta(bm, (XmlMetaProvider)this);
            this.xmlBeanMetas.put(bm, m);
        }
        return m;
    }

    public XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        XmlBeanPropertyMeta m = this.xmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new XmlBeanPropertyMeta(bpm.getDelegateFor(), (XmlMetaProvider)this);
            this.xmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    protected final Namespace getJuneauBpNs() {
        return this.juneauBpNs;
    }

    protected final Namespace getJuneauNs() {
        return this.juneauNs;
    }

    protected final String getLanguage() {
        return this.rdfLanguage;
    }

    protected final boolean isLooseCollections() {
        return this.looseCollections;
    }

    protected final Map<String, Object> getJenaProperties() {
        return this.jenaProperties;
    }

    protected final boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public OMap toMap() {
        return super.toMap().a(PREFIX, (Object)new DefaultFilteringOMap().a("trimWhitespace", (Object)this.trimWhitespace).a("looseCollections", (Object)this.looseCollections).a("rdfLanguage", (Object)this.rdfLanguage).a("juneauNs", (Object)this.juneauNs).a("juneauBpNs", (Object)this.juneauBpNs).a("collectionFormat", (Object)this.collectionFormat));
    }
}

