/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.transform.BeanFilterBuilder;
import org.apache.juneau.transform.BeanInterceptor;

public final class BeanFilter {
    private final Class<?> beanClass;
    private final Set<String> bpi;
    private final Set<String> bpx;
    private final Set<String> bpro;
    private final Set<String> bpwo;
    private final PropertyNamer propertyNamer;
    private final Class<?> interfaceClass;
    private final Class<?> stopClass;
    private final boolean sortProperties;
    private final boolean fluentSetters;
    private final String typeName;
    private final Class<?>[] beanDictionary;
    private final BeanInterceptor interceptor;

    BeanFilter(BeanFilterBuilder<?> builder) {
        this.beanClass = builder.beanClass;
        this.typeName = builder.typeName;
        this.bpi = new LinkedHashSet<String>(builder.bpi);
        this.bpx = new LinkedHashSet<String>(builder.bpx);
        this.bpro = new LinkedHashSet<String>(builder.bpro);
        this.bpwo = new LinkedHashSet<String>(builder.bpwo);
        this.interfaceClass = builder.interfaceClass;
        this.stopClass = builder.stopClass;
        this.sortProperties = builder.sortProperties;
        this.fluentSetters = builder.fluentSetters;
        this.propertyNamer = ClassUtils.castOrCreate(PropertyNamer.class, builder.propertyNamer);
        this.beanDictionary = builder.dictionary == null ? null : builder.dictionary.toArray(new Class[builder.dictionary.size()]);
        this.interceptor = builder.interceptor == null ? BeanInterceptor.DEFAULT : ClassUtils.castOrCreate(BeanInterceptor.class, builder.interceptor);
    }

    public static <T> BeanFilterBuilder<T> create(Class<T> c) {
        return new BeanFilterBuilder(c);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Class<?>[] getBeanDictionary() {
        return this.beanDictionary;
    }

    public Set<String> getBpi() {
        return this.bpi;
    }

    public Set<String> getBpx() {
        return this.bpx;
    }

    public Set<String> getBpro() {
        return this.bpro;
    }

    public Set<String> getBpwo() {
        return this.bpwo;
    }

    public boolean isSortProperties() {
        return this.sortProperties;
    }

    public boolean isFluentSetters() {
        return this.fluentSetters;
    }

    public PropertyNamer getPropertyNamer() {
        return this.propertyNamer;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public Class<?> getStopClass() {
        return this.stopClass;
    }

    public Object readProperty(Object bean, String name, Object value) {
        return this.interceptor.readProperty(bean, name, value);
    }

    public Object writeProperty(Object bean, String name, Object value) {
        return this.interceptor.writeProperty(bean, name, value);
    }
}

