/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer.annotation;

import java.nio.charset.Charset;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.ConfigException;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.annotation.SerializerConfig;
import org.apache.juneau.svl.VarResolverSession;

public class SerializerConfigApply
extends ConfigApply<SerializerConfig> {
    public SerializerConfigApply(Class<SerializerConfig> c, VarResolverSession r) {
        super(c, r);
    }

    @Override
    public void apply(AnnotationInfo<SerializerConfig> ai, PropertyStoreBuilder psb) {
        SerializerConfig a = ai.getAnnotation();
        if (!a.addBeanTypes().isEmpty()) {
            psb.set("Serializer.addBeanTypes.b", this.bool(a.addBeanTypes()));
        }
        if (!a.addRootType().isEmpty()) {
            psb.set("Serializer.addRootType.b", this.bool(a.addRootType()));
        }
        if (!a.keepNullProperties().isEmpty()) {
            psb.set("Serializer.keepNullProperties.b", this.bool(a.keepNullProperties()));
        }
        if (a.listener() != SerializerListener.Null.class) {
            psb.set("Serializer.listener.c", a.listener());
        }
        if (!a.sortCollections().isEmpty()) {
            psb.set("Serializer.sortCollections.b", this.bool(a.sortCollections()));
        }
        if (!a.sortMaps().isEmpty()) {
            psb.set("Serializer.sortMaps.b", this.bool(a.sortMaps()));
        }
        if (!a.trimEmptyCollections().isEmpty()) {
            psb.set("Serializer.trimEmptyCollections.b", this.bool(a.trimEmptyCollections()));
        }
        if (!a.trimEmptyMaps().isEmpty()) {
            psb.set("Serializer.trimEmptyMaps.b", this.bool(a.trimEmptyMaps()));
        }
        if (!a.trimNullProperties().isEmpty()) {
            psb.set("Serializer.trimNullProperties.b", this.bool(a.trimNullProperties()));
        }
        if (!a.trimStrings().isEmpty()) {
            psb.set("Serializer.trimStrings.b", this.bool(a.trimStrings()));
        }
        if (!a.uriContext().isEmpty()) {
            psb.set("Serializer.uriContext.s", this.string(a.uriContext()));
        }
        if (!a.uriRelativity().isEmpty()) {
            psb.set("Serializer.uriRelativity.s", this.string(a.uriRelativity()));
        }
        if (!a.uriResolution().isEmpty()) {
            psb.set("Serializer.uriResolution.s", this.string(a.uriResolution()));
        }
        if (!a.binaryFormat().isEmpty()) {
            psb.set("OutputStreamSerializer.binaryFormat.s", this.string(a.binaryFormat()));
        }
        if (!a.fileCharset().isEmpty()) {
            psb.set("WriterSerializer.fileCharset.s", this.charset(a.fileCharset()));
        }
        if (!a.maxIndent().isEmpty()) {
            psb.set("WriterSerializer.maxIndent.i", this.integer(a.maxIndent(), "maxIndent"));
        }
        if (!a.quoteChar().isEmpty()) {
            psb.set("WriterSerializer.quoteChar.s", Character.valueOf(this.character(a.quoteChar(), "quoteChar")));
        }
        if (!a.streamCharset().isEmpty()) {
            psb.set("WriterSerializer.streamCharset.s", this.charset(a.streamCharset()));
        }
        if (!a.useWhitespace().isEmpty()) {
            psb.set("WriterSerializer.useWhitespace.b", this.bool(a.useWhitespace()));
        }
    }

    private Object charset(String in) {
        String s = this.string(in);
        if ("default".equalsIgnoreCase(s)) {
            return Charset.defaultCharset();
        }
        return s;
    }

    private char character(String in, String loc) {
        String s = this.string(in);
        if (s.length() != 1) {
            throw new ConfigException("Invalid syntax for character on annotation @{0}({1}): {2}", "SerializerConfig", loc, in);
        }
        return s.charAt(0);
    }
}

