/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import java.net.URI;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.response.HttpResponse;

@Response(code={308}, description={"Permanent Redirect"})
@BeanIgnore
public class PermanentRedirect
extends HttpResponse {
    public static final int CODE = 308;
    public static final String MESSAGE = "Permanent Redirect";
    public static final PermanentRedirect INSTANCE = new PermanentRedirect();
    private final URI location;

    public PermanentRedirect() {
        this(MESSAGE, null);
    }

    public PermanentRedirect(String message) {
        super(message);
        this.location = null;
    }

    public PermanentRedirect(String message, URI location) {
        super(message);
        this.location = location;
    }

    public PermanentRedirect(URI location) {
        this(MESSAGE, location);
    }

    @ResponseHeader(name="Location", description={"New location of resource."})
    public URI getLocation() {
        return this.location;
    }

    @Override
    public PermanentRedirect header(String name, Object val) {
        super.header(name, val);
        return this;
    }
}

