/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.ConfigException;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.annotation.BeanAnnotation;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.CS;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class BeanConfigApply
extends ConfigApply<BeanConfig> {
    public BeanConfigApply(Class<BeanConfig> c, VarResolverSession r) {
        super(c, r);
    }

    @Override
    public void apply(AnnotationInfo<BeanConfig> ai, PropertyStoreBuilder psb) {
        BeanConfig a = ai.getAnnotation();
        for (CS cS : a.excludeProperties()) {
            psb.putTo("BeanContext.bpx.sms", cS.k().getName(), this.string(cS.v()));
        }
        for (CS cS : a.includeProperties()) {
            psb.putTo("BeanContext.bpi.sms", cS.k().getName(), this.string(cS.v()));
        }
        if (a.beanDictionary().length != 0) {
            psb.prependTo("BeanContext.beanDictionary.lc", a.beanDictionary());
        }
        if (a.beanDictionary_replace().length != 0) {
            psb.set("BeanContext.beanDictionary.lc", a.beanDictionary_replace());
        }
        if (a.beanDictionary_remove().length != 0) {
            psb.removeFrom("BeanContext.beanDictionary.lc", a.beanDictionary_remove());
        }
        if (!a.beanClassVisibility().isEmpty()) {
            psb.set("BeanContext.beanClassVisibility.s", (Object)this.visibility(a.beanClassVisibility(), "beanClassVisibility"));
        }
        if (!a.beanConstructorVisibility().isEmpty()) {
            psb.set("BeanContext.beanConstructorVisibility.s", (Object)this.visibility(a.beanConstructorVisibility(), "beanConstructorVisibility"));
        }
        if (a.dictionary().length != 0) {
            psb.prependTo("BeanContext.beanDictionary.lc", a.dictionary());
        }
        if (a.dictionary_replace().length != 0) {
            psb.set("BeanContext.beanDictionary.lc", a.dictionary_replace());
        }
        if (a.dictionary_remove().length != 0) {
            psb.removeFrom("BeanContext.beanDictionary.lc", a.dictionary_remove());
        }
        if (!a.beanFieldVisibility().isEmpty()) {
            psb.set("BeanContext.beanFieldVisibility.s", (Object)this.visibility(a.beanFieldVisibility(), "beanFieldVisibility"));
        }
        if (a.beanFilters().length != 0) {
            psb.prependTo("BeanContext.beanFilters.lo", a.beanFilters());
        }
        if (a.beanFilters_replace().length != 0) {
            psb.prependTo("BeanContext.beanFilters.lo", a.beanFilters_replace());
        }
        if (a.beanFilters_remove().length != 0) {
            psb.removeFrom("BeanContext.beanFilters.lo", a.beanFilters_remove());
        }
        if (!a.beanMapPutReturnsOldValue().isEmpty()) {
            psb.set("BeanContext.beanMapPutReturnsOldValue.b", this.bool(a.beanMapPutReturnsOldValue()));
        }
        if (!a.beanMethodVisibility().isEmpty()) {
            psb.set("BeanContext.beanMethodVisibility.s", (Object)this.visibility(a.beanMethodVisibility(), "beanMethodVisibility"));
        }
        if (!a.beansRequireDefaultConstructor().isEmpty()) {
            psb.set("BeanContext.beansRequireDefaultConstructor.b", this.bool(a.beansRequireDefaultConstructor()));
        }
        if (!a.beansRequireSerializable().isEmpty()) {
            psb.set("BeanContext.beansRequireSerializable.b", this.bool(a.beansRequireSerializable()));
        }
        if (!a.beansRequireSettersForGetters().isEmpty()) {
            psb.set("BeanContext.beansRequireSettersForGetters.b", this.bool(a.beansRequireSettersForGetters()));
        }
        if (!a.beansRequireSomeProperties().isEmpty()) {
            psb.set("BeanContext.beansRequireSomeProperties.b", this.bool(a.beansRequireSomeProperties()));
        }
        if (!a.typePropertyName().isEmpty()) {
            psb.set("BeanContext.typePropertyName.s", this.string(a.typePropertyName()));
        }
        if (!a.debug().isEmpty()) {
            psb.set("Context.debug.b", this.bool(a.debug()));
        }
        for (CS cS : a.example()) {
            psb.putTo("BeanContext.examples.smo", cS.k().getName(), this.parse(cS.k(), cS.v(), "example"));
        }
        if (a.examples().length > 0) {
            psb.putAllTo("BeanContext.examples.smo", this.omap(a.examples(), "examples"));
        }
        if (!a.fluentSetters().isEmpty()) {
            psb.set("BeanContext.fluentSetters.b", this.bool(a.fluentSetters()));
        }
        if (!a.ignoreInvocationExceptionsOnGetters().isEmpty()) {
            psb.set("BeanContext.ignoreInvocationExceptionsOnGetters.b", this.bool(a.ignoreInvocationExceptionsOnGetters()));
        }
        if (!a.ignoreInvocationExceptionsOnSetters().isEmpty()) {
            psb.set("BeanContext.ignoreInvocationExceptionsOnSetters.b", this.bool(a.ignoreInvocationExceptionsOnSetters()));
        }
        if (!a.ignorePropertiesWithoutSetters().isEmpty()) {
            psb.set("BeanContext.ignorePropertiesWithoutSetters.b", this.bool(a.ignorePropertiesWithoutSetters()));
        }
        if (!a.ignoreTransientFields().isEmpty()) {
            psb.set("BeanContext.ignoreTransientFields.b", this.bool(a.ignoreTransientFields()));
        }
        if (!a.ignoreUnknownBeanProperties().isEmpty()) {
            psb.set("BeanContext.ignoreUnknownBeanProperties.b", this.bool(a.ignoreUnknownBeanProperties()));
        }
        if (!a.ignoreUnknownNullBeanProperties().isEmpty()) {
            psb.set("BeanContext.ignoreUnknownNullBeanProperties.b", this.bool(a.ignoreUnknownNullBeanProperties()));
        }
        for (Annotation annotation : a.implClasses()) {
            psb.putTo("BeanContext.implClasses.smc", annotation.k().getName(), annotation.v());
        }
        for (Class<?> clazz : a.interfaces()) {
            psb.prependTo("BeanContext.annotations.lo", new BeanAnnotation(clazz).interfaceClass(clazz));
        }
        if (!a.locale().isEmpty()) {
            psb.set("Context.locale.s", this.locale(a.locale()));
        }
        if (!a.mediaType().isEmpty()) {
            psb.set("Context.mediaType.s", this.mediaType(a.mediaType()));
        }
        if (a.notBeanClasses().length != 0) {
            psb.addTo("BeanContext.notBeanClasses.sc", a.notBeanClasses());
        }
        if (a.notBeanClasses_replace().length != 0) {
            psb.set("BeanContext.notBeanClasses.sc", a.notBeanClasses_replace());
        }
        if (a.notBeanClasses_remove().length != 0) {
            psb.removeFrom("BeanContext.notBeanClasses.sc", a.notBeanClasses_remove());
        }
        if (a.notBeanPackages().length != 0) {
            psb.addTo("BeanContext.notBeanPackages.ss", this.strings(a.notBeanPackages()));
        }
        if (a.notBeanPackages_replace().length != 0) {
            psb.set("BeanContext.notBeanPackages.ss", this.strings(a.notBeanPackages_replace()));
        }
        if (a.notBeanPackages_remove().length != 0) {
            psb.removeFrom("BeanContext.notBeanPackages.ss", this.strings(a.notBeanPackages_remove()));
        }
        if (a.pojoSwaps().length != 0) {
            psb.prependTo("BeanContext.pojoSwaps.lo", a.pojoSwaps());
        }
        if (a.pojoSwaps_replace().length != 0) {
            psb.set("BeanContext.pojoSwaps.lo", a.pojoSwaps_replace());
        }
        if (a.pojoSwaps_remove().length != 0) {
            psb.removeFrom("BeanContext.pojoSwaps.lo", a.pojoSwaps_remove());
        }
        if (a.propertyNamer() != PropertyNamer.Null.class) {
            psb.set("BeanContext.propertyNamer.c", a.propertyNamer());
        }
        if (!a.sortProperties().isEmpty()) {
            psb.set("BeanContext.sortProperties.b", this.bool(a.sortProperties()));
        }
        if (a.swaps().length != 0) {
            psb.prependTo("BeanContext.swaps.lo", a.swaps());
        }
        if (a.swaps_replace().length != 0) {
            psb.set("BeanContext.swaps.lo", a.swaps_replace());
        }
        if (a.swaps_remove().length != 0) {
            psb.removeFrom("BeanContext.swaps.lo", a.swaps_remove());
        }
        if (!a.timeZone().isEmpty()) {
            psb.set("Context.timeZone.s", this.timeZone(a.timeZone()));
        }
        if (!a.useEnumNames().isEmpty()) {
            psb.set("BeanContext.useEnumNames.b", this.bool(a.useEnumNames()));
        }
        if (!a.useInterfaceProxies().isEmpty()) {
            psb.set("BeanContext.useInterfaceProxies.b", this.bool(a.useInterfaceProxies()));
        }
        if (!a.useJavaBeanIntrospector().isEmpty()) {
            psb.set("BeanContext.useJavaBeanIntrospector.b", this.bool(a.useJavaBeanIntrospector()));
        }
        if (!a.detectRecursions().isEmpty()) {
            psb.set("BeanTraverseContext.detectRecursions.b", this.bool(a.detectRecursions()));
        }
        if (!a.ignoreRecursions().isEmpty()) {
            psb.set("BeanTraverseContext.ignoreRecursions.b", this.bool(a.ignoreRecursions()));
        }
        if (!a.initialDepth().isEmpty()) {
            psb.set("BeanTraverseContext.initialDepth.i", this.integer(a.initialDepth(), "initialDepth"));
        }
        if (!a.maxDepth().isEmpty()) {
            psb.set("BeanTraverseContext.maxDepth.i", this.integer(a.maxDepth(), "maxDepth"));
        }
        if (a.applyBean().length > 0) {
            psb.prependTo("BeanContext.annotations.lo", a.applyBean());
        }
        if (a.applyBeanp().length > 0) {
            psb.prependTo("BeanContext.annotations.lo", a.applyBeanp());
        }
        if (a.applyBeanc().length > 0) {
            psb.prependTo("BeanContext.annotations.lo", a.applyBeanc());
        }
        if (a.applyBeanIgnore().length > 0) {
            psb.prependTo("BeanContext.annotations.lo", a.applyBeanIgnore());
        }
        if (a.applyExample().length > 0) {
            psb.prependTo("BeanContext.annotations.lo", a.applyExample());
        }
        if (a.applyNameProperty().length > 0) {
            psb.prependTo("BeanContext.annotations.lo", a.applyNameProperty());
        }
        if (a.applyParentProperty().length > 0) {
            psb.prependTo("BeanContext.annotations.lo", a.applyParentProperty());
        }
        if (a.applyURI().length > 0) {
            psb.prependTo("BeanContext.annotations.lo", a.applyURI());
        }
        if (a.applySwap().length > 0) {
            psb.prependTo("BeanContext.annotations.lo", a.applySwap());
        }
        if (a.bpi().length > 0) {
            for (Map.Entry entry : this.stringsMap(a.bpi(), "bpi").entrySet()) {
                psb.prependTo("BeanContext.annotations.lo", new BeanAnnotation((String)entry.getKey()).bpi((String)entry.getValue()));
            }
        }
        for (CS cS : a.bpiMap()) {
            psb.prependTo("BeanContext.annotations.lo", new BeanAnnotation(cS.k().getName()).bpi(cS.v()));
        }
        if (a.bpx().length > 0) {
            for (Map.Entry entry : this.stringsMap(a.bpx(), "bpx").entrySet()) {
                psb.prependTo("BeanContext.annotations.lo", new BeanAnnotation((String)entry.getKey()).bpx((String)entry.getValue()));
            }
        }
        for (CS cS : a.bpxMap()) {
            psb.prependTo("BeanContext.annotations.lo", new BeanAnnotation(cS.k().getName()).bpx(cS.v()));
        }
        if (a.bpro().length > 0) {
            for (Map.Entry entry : this.stringsMap(a.bpro(), "bpro").entrySet()) {
                psb.prependTo("BeanContext.annotations.lo", new BeanAnnotation((String)entry.getKey()).bpro((String)entry.getValue()));
            }
        }
        for (CS cS : a.bproMap()) {
            psb.prependTo("BeanContext.annotations.lo", new BeanAnnotation(cS.k().getName()).bpro(cS.v()));
        }
        if (a.bpwo().length > 0) {
            for (Map.Entry entry : this.stringsMap(a.bpwo(), "bpwo").entrySet()) {
                psb.prependTo("BeanContext.annotations.lo", new BeanAnnotation((String)entry.getKey()).bpwo((String)entry.getValue()));
            }
        }
        for (CS cS : a.bpwoMap()) {
            psb.prependTo("BeanContext.annotations.lo", new BeanAnnotation(cS.k().getName()).bpwo(cS.v()));
        }
    }

    private Locale locale(String in) {
        return Locale.forLanguageTag(this.string(in));
    }

    private MediaType mediaType(String in) {
        return MediaType.of(this.string(in));
    }

    private TimeZone timeZone(String in) {
        return TimeZone.getTimeZone(this.string(in));
    }

    private <T> T parse(Class<T> c, String in, String loc) {
        try {
            return SimpleJson.DEFAULT.read(this.string(in), c);
        }
        catch (ParseException e) {
            throw new ConfigException("Invalid syntax for visibility on annotation @BeanConfig({0}): {1}", loc, in);
        }
    }
}

