/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.TeeWriter;
import org.apache.juneau.utils.IOPipe;

public class ProcBuilder {
    private ProcessBuilder pb = new ProcessBuilder(new String[0]);
    private TeeWriter outWriters = new TeeWriter(new Writer[0]);
    private TeeWriter logWriters = new TeeWriter(new Writer[0]);
    private IOPipe.LineProcessor lp;
    private Process p;
    private int maxExitStatus = 0;
    private boolean byLines;
    private String divider = "--------------------------------------------------------------------------------";
    static final String OS = System.getProperty("os.name").toLowerCase();
    public static final Matcher ANY = new Matcher(){

        @Override
        boolean matches() {
            return true;
        }
    };
    public static final Matcher WINDOWS = new Matcher(){

        @Override
        boolean matches() {
            return OS.indexOf("win") >= 0;
        }
    };
    public static final Matcher MAC = new Matcher(){

        @Override
        boolean matches() {
            return OS.indexOf("mac") >= 0;
        }
    };
    public static final Matcher UNIX = new Matcher(){

        @Override
        boolean matches() {
            return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
        }
    };

    public static ProcBuilder create(Object ... args) {
        return new ProcBuilder().command(args);
    }

    public static ProcBuilder create() {
        return new ProcBuilder().command(new Object[0]);
    }

    public ProcBuilder command(Object ... args) {
        return this.commandIf(ANY, args);
    }

    public ProcBuilder commandIf(Matcher m, Object ... args) {
        if (m.matches()) {
            this.pb.command(ProcBuilder.toList(args));
        }
        return this;
    }

    public ProcBuilder append(Object ... args) {
        return this.appendIf(ANY, args);
    }

    public ProcBuilder appendIf(Matcher m, Object ... args) {
        if (m.matches()) {
            this.pb.command().addAll(ProcBuilder.toList(args));
        }
        return this;
    }

    public ProcBuilder merge() {
        this.pb.redirectErrorStream(true);
        return this;
    }

    public ProcBuilder byLines() {
        this.byLines = true;
        return this;
    }

    public ProcBuilder pipeTo(Writer w, boolean close) {
        this.outWriters.add(w, close);
        return this;
    }

    public ProcBuilder pipeTo(Writer w) {
        return this.pipeTo(w, false);
    }

    public ProcBuilder logTo(Writer w, boolean close) {
        this.logWriters.add(w, close);
        this.outWriters.add(w, close);
        return this;
    }

    public ProcBuilder logTo(Writer w) {
        return this.logTo(w, false);
    }

    public ProcBuilder logTo(final Level level, final Logger logger) {
        if (logger.isLoggable(level)) {
            this.logTo(new StringWriter(){
                private boolean isClosed;

                @Override
                public void close() {
                    if (!this.isClosed) {
                        logger.log(level, this.toString());
                    }
                    this.isClosed = true;
                }
            }, true);
        }
        return this;
    }

    public ProcBuilder lp(IOPipe.LineProcessor lp) {
        this.lp = lp;
        return this;
    }

    public ProcBuilder env(Map env) {
        if (env != null) {
            for (Map.Entry e : env.entrySet()) {
                this.environment(e.getKey().toString(), e.getValue() == null ? null : e.getValue().toString());
            }
        }
        return this;
    }

    public ProcBuilder environment(String key, String val) {
        this.pb.environment().put(key, val);
        return this;
    }

    public ProcBuilder directory(File directory) {
        this.pb.directory(directory);
        return this;
    }

    public ProcBuilder maxExitStatus(int maxExitStatus) {
        this.maxExitStatus = maxExitStatus;
        return this;
    }

    public int run() throws IOException, InterruptedException {
        if (this.pb.command().size() == 0) {
            throw new IOException("No command specified in ProcBuilder.");
        }
        try {
            this.logWriters.append(this.divider).append('\n').flush();
            this.logWriters.append(StringUtils.join(this.pb.command(), " ")).append('\n').flush();
            this.p = this.pb.start();
            IOPipe.create(this.p.getInputStream(), this.outWriters).lineProcessor(this.lp).byLines(this.byLines).run();
            int rc = this.p.waitFor();
            this.logWriters.append("Exit: ").append(String.valueOf(this.p.exitValue())).append('\n').flush();
            if (rc > this.maxExitStatus) {
                throw new IOException("Return code " + rc + " from command " + StringUtils.join(this.pb.command(), " "));
            }
            int n = rc;
            return n;
        }
        finally {
            this.close();
        }
    }

    public String getOutput() throws IOException, InterruptedException {
        StringWriter sw = new StringWriter();
        this.pipeTo(sw).run();
        return sw.toString();
    }

    public Scanner getScanner() throws IOException, InterruptedException {
        StringWriter sw = new StringWriter();
        this.pipeTo(sw, true);
        this.run();
        return new Scanner(sw.toString());
    }

    private void close() {
        IOUtils.closeQuietly(this.logWriters, this.outWriters);
        if (this.p != null) {
            this.p.destroy();
        }
    }

    private static List<String> toList(Object ... args) {
        LinkedList<String> l = new LinkedList<String>();
        for (Object o : args) {
            if (o.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    l.add(Array.get(o, i).toString());
                }
                continue;
            }
            if (o instanceof Collection) {
                for (Object o2 : (Collection)o) {
                    l.add(o2.toString());
                }
                continue;
            }
            l.add(o.toString());
        }
        return l;
    }

    public static abstract class Matcher {
        abstract boolean matches();
    }
}

