/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.IOUtils;

public class ManifestFile
extends OMap {
    private static final long serialVersionUID = 1L;

    public ManifestFile(File f) throws IOException {
        Manifest mf = new Manifest();
        try (FileInputStream fis = new FileInputStream(f);){
            mf.read(fis);
            this.load(mf);
        }
        catch (IOException e) {
            throw new IOException("Problem detected in MANIFEST.MF.  Contents below:\n" + IOUtils.read(f), e);
        }
    }

    public ManifestFile(Manifest f) {
        this.load(f);
    }

    public ManifestFile(Class<?> c) throws IOException {
        String className = c.getSimpleName() + ".class";
        String classPath = c.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest mf = new Manifest(new URL(manifestPath).openStream());
            this.load(mf);
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ManifestFile(Reader r) throws IOException {
        this.load(new Manifest(IOUtils.toInputStream(r)));
    }

    public ManifestFile(InputStream is) throws IOException {
        this.load(new Manifest(is));
    }

    private void load(Manifest mf) {
        for (Map.Entry<Object, Object> e : mf.getMainAttributes().entrySet()) {
            this.put(e.getKey().toString(), e.getValue().toString());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> e : this.entrySet()) {
            sb.append(e.getKey()).append(": ").append(e.getValue());
        }
        return sb.toString();
    }
}

