/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.internal.StringUtils;

public class BasicStringHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private String parsed;

    public static BasicStringHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicStringHeader(name, value);
    }

    public static BasicStringHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicStringHeader(name, value);
    }

    public BasicStringHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.getParsedValue();
        }
    }

    public FluentStringAssertion<BasicStringHeader> assertString() {
        return new FluentStringAssertion<BasicStringHeader>(this.getValue(), this);
    }

    @Override
    public String getValue() {
        return this.getParsedValue();
    }

    private String getParsedValue() {
        if (this.parsed != null) {
            return this.parsed;
        }
        return StringUtils.stringify(this.getRawValue());
    }
}

