/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicStringRangeArrayHeader;
import org.apache.juneau.internal.Cache;

@Header(value="Accept-Charset")
public class AcceptCharset
extends BasicStringRangeArrayHeader {
    private static final long serialVersionUID = 1L;
    private static final Cache<String, AcceptCharset> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);

    public static AcceptCharset of(String value) {
        if (value == null) {
            return null;
        }
        AcceptCharset x = CACHE.get(value);
        if (x == null) {
            x = CACHE.put(value, new AcceptCharset(value));
        }
        return x;
    }

    public static AcceptCharset of(Object value) {
        if (value == null) {
            return null;
        }
        return new AcceptCharset(value);
    }

    public static AcceptCharset of(Supplier<?> value) {
        if (value == null) {
            return null;
        }
        return new AcceptCharset(value);
    }

    public AcceptCharset(Object value) {
        super("Accept-Charset", value);
    }

    public AcceptCharset(String value) {
        this((Object)value);
    }
}

