/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.BasicNameValuePair;
import org.apache.juneau.http.Constants;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public class MediaType
implements Comparable<MediaType> {
    private static final Cache<String, MediaType> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);
    public static final MediaType CSV = MediaType.of("text/csv");
    public static final MediaType HTML = MediaType.of("text/html");
    public static final MediaType JSON = MediaType.of("application/json");
    public static final MediaType MSGPACK = MediaType.of("octal/msgpack");
    public static final MediaType PLAIN = MediaType.of("text/plain");
    public static final MediaType UON = MediaType.of("text/uon");
    public static final MediaType URLENCODING = MediaType.of("application/x-www-form-urlencoded");
    public static final MediaType XML = MediaType.of("text/xml");
    public static final MediaType XMLSOAP = MediaType.of("text/xml+soap");
    public static final MediaType RDF = MediaType.of("text/xml+rdf");
    public static final MediaType RDFABBREV = MediaType.of("text/xml+rdf+abbrev");
    public static final MediaType NTRIPLE = MediaType.of("text/n-triple");
    public static final MediaType TURTLE = MediaType.of("text/turtle");
    public static final MediaType N3 = MediaType.of("text/n3");
    private final String string;
    private final String mediaType;
    private final String type;
    private final String subType;
    private final String[] subTypes;
    private final String[] subTypesSorted;
    private final boolean hasSubtypeMeta;
    private final NameValuePair[] parameters;

    public static MediaType of(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        MediaType x = CACHE.get(value);
        if (x == null) {
            x = CACHE.put(value, new MediaType(value));
        }
        return x;
    }

    public static MediaType[] ofAll(String ... values) {
        MediaType[] mt = new MediaType[values.length];
        for (int i = 0; i < values.length; ++i) {
            mt[i] = MediaType.of(values[i]);
        }
        return mt;
    }

    public MediaType(String mt) {
        this(MediaType.parse(mt));
    }

    public MediaType(HeaderElement e) {
        this.mediaType = e.getName();
        AList<NameValuePair> parameters = AList.of();
        for (NameValuePair p : e.getParameters()) {
            if (p.getName().equals("q")) break;
            parameters.add(BasicNameValuePair.of(p.getName(), p.getValue()));
        }
        this.parameters = parameters.toArray(new NameValuePair[parameters.size()]);
        String x = this.mediaType.replace(' ', '+');
        int i = x.indexOf(47);
        this.type = i == -1 ? x : x.substring(0, i);
        this.subType = i == -1 ? "*" : x.substring(i + 1);
        this.subTypes = StringUtils.split(this.subType, '+');
        this.subTypesSorted = Arrays.copyOf(this.subTypes, this.subTypes.length);
        Arrays.sort(this.subTypesSorted);
        this.hasSubtypeMeta = ArrayUtils.contains("*", this.subTypes);
        StringBuilder sb = new StringBuilder();
        sb.append(this.mediaType);
        for (NameValuePair p : parameters) {
            sb.append(';').append(p.getName()).append('=').append(p.getValue());
        }
        this.string = sb.toString();
    }

    public final String getType() {
        return this.type;
    }

    public final String getSubType() {
        return this.subType;
    }

    public final boolean hasSubType(String st) {
        if (st != null) {
            for (String s : this.subTypes) {
                if (!st.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public final List<String> getSubTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.subTypes));
    }

    public final boolean isMetaSubtype() {
        return this.hasSubtypeMeta;
    }

    public final int match(MediaType o, boolean allowExtraSubTypes) {
        if (o == null) {
            return -1;
        }
        if (this == o || this.type.equals(o.type) && this.subType.equals(o.subType)) {
            return 100000;
        }
        int c = 0;
        if (this.type.equals(o.type)) {
            c += 10000;
        } else if ("*".equals(this.type) || "*".equals(o.type)) {
            c += 5000;
        }
        if (c == 0) {
            return 0;
        }
        if (ArrayUtils.equals(this.subTypesSorted, o.subTypesSorted)) {
            return c + 7500;
        }
        for (String st1 : this.subTypes) {
            if ("*".equals(st1)) {
                c += 0;
                continue;
            }
            if (ArrayUtils.contains(st1, o.subTypes)) {
                c += 100;
                continue;
            }
            if (o.hasSubtypeMeta) {
                c += 0;
                continue;
            }
            return 0;
        }
        for (String st2 : o.subTypes) {
            if ("*".equals(st2)) {
                c += 0;
                continue;
            }
            if (ArrayUtils.contains(st2, this.subTypes)) {
                c += 100;
                continue;
            }
            if (this.hasSubtypeMeta) {
                c += 0;
                continue;
            }
            if (!allowExtraSubTypes) {
                return 0;
            }
            c += 10;
        }
        return c;
    }

    public List<NameValuePair> getParameters() {
        return Collections.unmodifiableList(Arrays.asList(this.parameters));
    }

    public String getParameter(String name) {
        for (NameValuePair p : this.parameters) {
            if (!ObjectUtils.eq(name, p.getName())) continue;
            return p.getValue();
        }
        return null;
    }

    private static HeaderElement parse(String value) {
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)StringUtils.emptyIfNull(StringUtils.trim(value)), null);
        return elements.length > 0 ? elements[0] : new BasicHeaderElement("", "");
    }

    public String toString() {
        return this.string;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof MediaType && ObjectUtils.eq(this, (MediaType)o, (x, y) -> ObjectUtils.eq(x.string, y.string));
    }

    @Override
    public final int compareTo(MediaType o) {
        return this.toString().compareTo(o.toString());
    }
}

