/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;

public abstract class OutputStreamSerializerSession
extends SerializerSession {
    private final OutputStreamSerializer ctx;

    protected OutputStreamSerializerSession(OutputStreamSerializer ctx, SerializerSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
    }

    protected OutputStreamSerializerSession(SerializerSessionArgs args) {
        this(OutputStreamSerializer.DEFAULT, args);
    }

    @Override
    public final boolean isWriterSerializer() {
        return false;
    }

    @Override
    protected SerializerPipe createPipe(Object output) {
        return new SerializerPipe(output);
    }

    public final byte[] serialize(Object o) throws SerializeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.serialize(o, baos);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return baos.toByteArray();
    }

    @Override
    public final String serializeToString(Object o) throws SerializeException {
        byte[] b = this.serialize(o);
        switch (this.getBinaryFormat()) {
            case SPACED_HEX: {
                return StringUtils.toSpacedHex(b);
            }
            case HEX: {
                return StringUtils.toHex(b);
            }
            case BASE64: {
                return StringUtils.base64Encode(b);
            }
        }
        return null;
    }

    protected final BinaryFormat getBinaryFormat() {
        return this.ctx.getBinaryFormat();
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("OutputStreamSerializerSession", new DefaultFilteringObjectMap());
    }
}

