/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import org.apache.juneau.internal.StringUtils;

public class Version {
    private int[] parts;

    public Version(String versionString) {
        if (StringUtils.isEmpty(versionString)) {
            versionString = "0";
        }
        String[] sParts = StringUtils.split(versionString, '.');
        this.parts = new int[sParts.length];
        for (int i = 0; i < sParts.length; ++i) {
            try {
                this.parts[i] = sParts[i].isEmpty() ? 0 : Integer.parseInt(sParts[i]);
                continue;
            }
            catch (NumberFormatException e) {
                this.parts[i] = Integer.MAX_VALUE;
            }
        }
    }

    public boolean isAtLeast(Version v, boolean exclusive) {
        int i;
        for (i = 0; i < Math.min(this.parts.length, v.parts.length); ++i) {
            int c = v.parts[i] - this.parts[i];
            if (c > 0) {
                return false;
            }
            if (c >= 0) continue;
            return true;
        }
        for (i = this.parts.length; i < v.parts.length; ++i) {
            if (v.parts[i] == 0) continue;
            return false;
        }
        return !exclusive;
    }

    public boolean isAtMost(Version v, boolean exclusive) {
        int i;
        for (i = 0; i < Math.min(this.parts.length, v.parts.length); ++i) {
            int c = this.parts[i] - v.parts[i];
            if (c > 0) {
                return false;
            }
            if (c >= 0) continue;
            return true;
        }
        for (i = this.parts.length; i < v.parts.length; ++i) {
            if (v.parts[i] <= 0) continue;
            return false;
        }
        return !exclusive;
    }

    public boolean isEqualsTo(Version v) {
        for (int i = 0; i < Math.min(this.parts.length, v.parts.length); ++i) {
            if (v.parts[i] - this.parts[i] == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return StringUtils.join(this.parts, '.');
    }
}

