/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.MetaProvider;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyNamerDefault;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Session;
import org.apache.juneau.SessionArgs;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.BeanFilterBuilder;
import org.apache.juneau.transform.InterfaceBeanFilterBuilder;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.transform.Surrogate;
import org.apache.juneau.transform.SurrogateSwap;
import org.apache.juneau.utils.ReflectionMap;
import org.apache.juneau.utils.TwoKeyConcurrentHashMap;

@ConfigurableContext
public class BeanContext
extends Context
implements MetaProvider {
    static final String PREFIX = "BeanContext";
    public static final String BEAN_annotations = "BeanContext.annotations.lo";
    public static final String BEAN_beanClassVisibility = "BeanContext.beanClassVisibility.s";
    public static final String BEAN_beanConstructorVisibility = "BeanContext.beanConstructorVisibility.s";
    public static final String BEAN_beanDictionary = "BeanContext.beanDictionary.lc";
    public static final String BEAN_beanDictionary_add = "BeanContext.beanDictionary.lc/add";
    public static final String BEAN_beanDictionary_remove = "BeanContext.beanDictionary.lc/remove";
    public static final String BEAN_beanFieldVisibility = "BeanContext.beanFieldVisibility.s";
    public static final String BEAN_beanFilters = "BeanContext.beanFilters.lc";
    public static final String BEAN_beanFilters_add = "BeanContext.beanFilters.lc/add";
    public static final String BEAN_beanFilters_remove = "BeanContext.beanFilters.lc/remove";
    public static final String BEAN_beanMapPutReturnsOldValue = "BeanContext.beanMapPutReturnsOldValue.b";
    public static final String BEAN_beanMethodVisibility = "BeanContext.beanMethodVisibility.s";
    public static final String BEAN_beansRequireDefaultConstructor = "BeanContext.beansRequireDefaultConstructor.b";
    public static final String BEAN_beansRequireSerializable = "BeanContext.beansRequireSerializable.b";
    public static final String BEAN_beansRequireSettersForGetters = "BeanContext.beansRequireSettersForGetters.b";
    public static final String BEAN_beansRequireSomeProperties = "BeanContext.beansRequireSomeProperties.b";
    public static final String BEAN_beanTypePropertyName = "BeanContext.beanTypePropertyName.s";
    public static final String BEAN_bpi = "BeanContext.bpi.sms";
    public static final String BEAN_bpx = "BeanContext.bpx.sms";
    public static final String BEAN_bpro = "BeanContext.bpro.sms";
    public static final String BEAN_bpwo = "BeanContext.bpwo.sms";
    public static final String BEAN_debug = "BeanContext.debug.b";
    public static final String BEAN_examples = "BeanContext.examples.smo";
    @Deprecated
    public static final String BEAN_excludeProperties = "BeanContext.bpx.sms";
    public static final String BEAN_fluentSetters = "BeanContext.fluentSetters.b";
    public static final String BEAN_ignoreInvocationExceptionsOnGetters = "BeanContext.ignoreInvocationExceptionsOnGetters.b";
    public static final String BEAN_ignoreInvocationExceptionsOnSetters = "BeanContext.ignoreInvocationExceptionsOnSetters.b";
    public static final String BEAN_ignorePropertiesWithoutSetters = "BeanContext.ignorePropertiesWithoutSetters.b";
    public static final String BEAN_ignoreUnknownBeanProperties = "BeanContext.ignoreUnknownBeanProperties.b";
    public static final String BEAN_ignoreUnknownNullBeanProperties = "BeanContext.ignoreUnknownNullBeanProperties.b";
    public static final String BEAN_implClasses = "BeanContext.implClasses.smc";
    @Deprecated
    public static final String BEAN_includeProperties = "BeanContext.bpi.sms";
    public static final String BEAN_locale = "BeanContext.locale.s";
    public static final String BEAN_mediaType = "BeanContext.mediaType.s";
    public static final String BEAN_notBeanClasses = "BeanContext.notBeanClasses.sc";
    public static final String BEAN_notBeanClasses_add = "BeanContext.notBeanClasses.sc/add";
    public static final String BEAN_notBeanClasses_remove = "BeanContext.notBeanClasses.sc/remove";
    public static final String BEAN_notBeanPackages = "BeanContext.notBeanPackages.ss";
    public static final String BEAN_notBeanPackages_add = "BeanContext.notBeanPackages.ss/add";
    public static final String BEAN_notBeanPackages_remove = "BeanContext.notBeanPackages.ss/remove";
    public static final String BEAN_pojoSwaps = "BeanContext.pojoSwaps.lo";
    public static final String BEAN_pojoSwaps_add = "BeanContext.pojoSwaps.lo/add";
    public static final String BEAN_pojoSwaps_remove = "BeanContext.pojoSwaps.lo/remove";
    public static final String BEAN_propertyNamer = "BeanContext.propertyNamer.c";
    public static final String BEAN_sortProperties = "BeanContext.sortProperties.b";
    public static final String BEAN_timeZone = "BeanContext.timeZone.s";
    public static final String BEAN_useEnumNames = "BeanContext.useEnumNames.b";
    public static final String BEAN_useInterfaceProxies = "BeanContext.useInterfaceProxies.b";
    public static final String BEAN_useJavaBeanIntrospector = "BeanContext.useJavaBeanIntrospector.b";
    private static final String[] DEFAULT_NOTBEAN_PACKAGES = new String[]{"java.lang", "java.lang.annotation", "java.lang.ref", "java.lang.reflect", "java.io", "java.net", "java.nio.*", "java.util.*"};
    private static final Class<?>[] DEFAULT_NOTBEAN_CLASSES = new Class[]{Map.class, Collection.class, Reader.class, Writer.class, InputStream.class, OutputStream.class, Throwable.class};
    private static final ConcurrentHashMap<Integer, Map<Class, ClassMeta>> cmCacheCache = new ConcurrentHashMap();
    public static final BeanContext DEFAULT = BeanContext.create().build();
    public static final BeanContext DEFAULT_SORTED = BeanContext.create().sortProperties().build();
    private final boolean beansRequireDefaultConstructor;
    private final boolean beansRequireSerializable;
    private final boolean beansRequireSettersForGetters;
    private final boolean beansRequireSomeProperties;
    private final boolean beanMapPutReturnsOldValue;
    private final boolean useInterfaceProxies;
    private final boolean ignoreUnknownBeanProperties;
    private final boolean ignoreUnknownNullBeanProperties;
    private final boolean ignorePropertiesWithoutSetters;
    private final boolean ignoreInvocationExceptionsOnGetters;
    private final boolean ignoreInvocationExceptionsOnSetters;
    private final boolean useJavaBeanIntrospector;
    private final boolean useEnumNames;
    private final boolean sortProperties;
    private final boolean fluentSetters;
    private final boolean debug;
    private final Visibility beanConstructorVisibility;
    private final Visibility beanClassVisibility;
    private final Visibility beanMethodVisibility;
    private final Visibility beanFieldVisibility;
    private final Class<?>[] notBeanClasses;
    private final List<Class<?>> beanDictionaryClasses;
    private final String[] notBeanPackageNames;
    private final String[] notBeanPackagePrefixes;
    private final BeanFilter[] beanFilters;
    private final PojoSwap<?, ?>[] pojoSwaps;
    private final Map<String, ?> examples;
    private final BeanRegistry beanRegistry;
    private final Map<String, ClassInfo> implClasses;
    private final Locale locale;
    private final TimeZone timeZone;
    private final MediaType mediaType;
    private final Map<String, Set<String>> bpi;
    private final Map<String, Set<String>> bpx;
    private final Map<String, Set<String>> bpro;
    private final Map<String, Set<String>> bpwo;
    private final PropertyNamer propertyNamer;
    private final String beanTypePropertyName;
    private final int beanHashCode;
    private final ReflectionMap<Annotation> annotations;
    final Map<Class, ClassMeta> cmCache;
    private final ClassMeta<Object> cmObject;
    private final ClassMeta<String> cmString;
    private final ClassMeta<Class> cmClass;
    private volatile WriterSerializer beanToStringSerializer;
    private static final boolean DISABLE_ANNOTATION_CACHING = !Boolean.getBoolean("juneau.disableAnnotationCaching");
    private TwoKeyConcurrentHashMap<Class<?>, Class<? extends Annotation>, Optional<Annotation>> classAnnotationCache = new TwoKeyConcurrentHashMap();
    private TwoKeyConcurrentHashMap<Class<?>, Class<? extends Annotation>, Optional<Annotation>> declaredClassAnnotationCache = new TwoKeyConcurrentHashMap();
    private TwoKeyConcurrentHashMap<Method, Class<? extends Annotation>, Optional<Annotation>> methodAnnotationCache = new TwoKeyConcurrentHashMap();
    private TwoKeyConcurrentHashMap<Field, Class<? extends Annotation>, Optional<Annotation>> fieldAnnotationCache = new TwoKeyConcurrentHashMap();
    private TwoKeyConcurrentHashMap<Constructor<?>, Class<? extends Annotation>, Optional<Annotation>> constructorAnnotationCache = new TwoKeyConcurrentHashMap();

    public BeanContext(PropertyStore ps) {
        super(ps, true);
        if (ps == null) {
            ps = PropertyStore.DEFAULT;
        }
        ReflectionMap.Builder<Annotation> rmb = ReflectionMap.create(Annotation.class);
        for (Annotation a : ps.getListProperty(BEAN_annotations, Annotation.class)) {
            try {
                Method m = a.getClass().getMethod("on", new Class[0]);
                String on = (String)m.invoke((Object)a, new Object[0]);
                rmb.append(on, a);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigException("Invalid annotation @{0} used in BEAN_annotations property.  Annotation must define an on() method.", a.getClass().getSimpleName());
            }
            catch (Exception e) {
                throw new ConfigException(e, "Invalid annotation @{0} used in BEAN_annotations property.", new Object[0]);
            }
        }
        this.annotations = rmb.build();
        this.beanHashCode = ps.hashCode(PREFIX);
        this.beansRequireDefaultConstructor = this.getBooleanProperty(BEAN_beansRequireDefaultConstructor, false);
        this.beansRequireSerializable = this.getBooleanProperty(BEAN_beansRequireSerializable, false);
        this.beansRequireSettersForGetters = this.getBooleanProperty(BEAN_beansRequireSettersForGetters, false);
        this.beansRequireSomeProperties = this.getBooleanProperty(BEAN_beansRequireSomeProperties, true);
        this.beanMapPutReturnsOldValue = this.getBooleanProperty(BEAN_beanMapPutReturnsOldValue, false);
        this.useEnumNames = this.getBooleanProperty(BEAN_useEnumNames, false);
        this.useInterfaceProxies = this.getBooleanProperty(BEAN_useInterfaceProxies, true);
        this.ignoreUnknownBeanProperties = this.getBooleanProperty(BEAN_ignoreUnknownBeanProperties, false);
        this.ignoreUnknownNullBeanProperties = this.getBooleanProperty(BEAN_ignoreUnknownNullBeanProperties, true);
        this.ignorePropertiesWithoutSetters = this.getBooleanProperty(BEAN_ignorePropertiesWithoutSetters, true);
        this.ignoreInvocationExceptionsOnGetters = this.getBooleanProperty(BEAN_ignoreInvocationExceptionsOnGetters, false);
        this.ignoreInvocationExceptionsOnSetters = this.getBooleanProperty(BEAN_ignoreInvocationExceptionsOnSetters, false);
        this.useJavaBeanIntrospector = this.getBooleanProperty(BEAN_useJavaBeanIntrospector, false);
        this.sortProperties = this.getBooleanProperty(BEAN_sortProperties, false);
        this.fluentSetters = this.getBooleanProperty(BEAN_fluentSetters, false);
        this.beanTypePropertyName = this.getStringProperty(BEAN_beanTypePropertyName, "_type");
        this.debug = this.getBooleanProperty(BEAN_debug, false);
        this.beanConstructorVisibility = this.getProperty(BEAN_beanConstructorVisibility, Visibility.class, Visibility.PUBLIC);
        this.beanClassVisibility = this.getProperty(BEAN_beanClassVisibility, Visibility.class, Visibility.PUBLIC);
        this.beanMethodVisibility = this.getProperty(BEAN_beanMethodVisibility, Visibility.class, Visibility.PUBLIC);
        this.beanFieldVisibility = this.getProperty(BEAN_beanFieldVisibility, Visibility.class, Visibility.PUBLIC);
        this.notBeanClasses = this.getClassArrayProperty(BEAN_notBeanClasses, DEFAULT_NOTBEAN_CLASSES);
        this.propertyNamer = this.getInstanceProperty(BEAN_propertyNamer, PropertyNamer.class, PropertyNamerDefault.class);
        LinkedList<String> l1 = new LinkedList<String>();
        LinkedList<String> l2 = new LinkedList<String>();
        for (String string : this.getArrayProperty(BEAN_notBeanPackages, String.class, DEFAULT_NOTBEAN_PACKAGES)) {
            if (string.endsWith(".*")) {
                l2.add(string.substring(0, string.length() - 2));
                continue;
            }
            l1.add(string);
        }
        this.notBeanPackageNames = l1.toArray(new String[l1.size()]);
        this.notBeanPackagePrefixes = l2.toArray(new String[l2.size()]);
        LinkedList<BeanFilter> lbf = new LinkedList<BeanFilter>();
        for (Class<?> c : this.getClassListProperty(BEAN_beanFilters)) {
            ClassInfo classInfo = ClassInfo.of(c);
            if (classInfo.isChildOf(BeanFilter.class)) {
                lbf.add(ClassUtils.castOrCreate(BeanFilter.class, c));
                continue;
            }
            if (classInfo.isChildOf(BeanFilterBuilder.class)) {
                lbf.add(ClassUtils.castOrCreate(BeanFilterBuilder.class, c).build());
                continue;
            }
            lbf.add(new InterfaceBeanFilterBuilder(c, this).build());
        }
        this.beanFilters = lbf.toArray(new BeanFilter[0]);
        LinkedList<PojoSwap> lpf = new LinkedList<PojoSwap>();
        for (Object object : this.getListProperty(BEAN_pojoSwaps, Object.class)) {
            if (object instanceof Class) {
                ClassInfo classInfo = ClassInfo.of((Class)object);
                if (classInfo.isChildOf(PojoSwap.class)) {
                    lpf.add(ClassUtils.castOrCreate(PojoSwap.class, classInfo.inner()));
                    continue;
                }
                if (classInfo.isChildOf(Surrogate.class)) {
                    lpf.addAll(SurrogateSwap.findPojoSwaps(classInfo.inner(), this));
                    continue;
                }
                throw new FormattedRuntimeException("Invalid class {0} specified in BeanContext.pojoSwaps property.  Must be a subclass of PojoSwap or Surrogate.", classInfo.inner());
            }
            if (!(object instanceof PojoSwap)) continue;
            lpf.add((PojoSwap)object);
        }
        this.pojoSwaps = lpf.toArray(new PojoSwap[lpf.size()]);
        this.examples = this.getMapProperty(BEAN_examples, Object.class);
        LinkedHashMap<String, ClassInfo> icm = new LinkedHashMap<String, ClassInfo>();
        for (Map.Entry<String, Class<?>> entry : this.getClassMapProperty(BEAN_implClasses).entrySet()) {
            icm.put(entry.getKey(), ClassInfo.of(entry.getValue()));
        }
        this.implClasses = CollectionUtils.unmodifiableMap(icm);
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> e : this.getMapProperty("BeanContext.bpi.sms", String.class).entrySet()) {
            hashMap.put(e.getKey(), CollectionUtils.newUnmodifiableLinkedHashSet(StringUtils.split(e.getValue())));
        }
        this.bpi = CollectionUtils.unmodifiableMap(hashMap);
        HashMap<String, Set<String>> hashMap2 = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> e : this.getMapProperty("BeanContext.bpx.sms", String.class).entrySet()) {
            hashMap2.put(e.getKey(), CollectionUtils.newUnmodifiableLinkedHashSet(StringUtils.split(e.getValue())));
        }
        this.bpx = CollectionUtils.unmodifiableMap(hashMap2);
        HashMap<String, Set<String>> hashMap3 = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> e : this.getMapProperty(BEAN_bpro, String.class).entrySet()) {
            hashMap3.put(e.getKey(), CollectionUtils.newUnmodifiableLinkedHashSet(StringUtils.split(e.getValue())));
        }
        this.bpro = CollectionUtils.unmodifiableMap(hashMap3);
        HashMap<String, Set<String>> hashMap4 = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> e : this.getMapProperty(BEAN_bpwo, String.class).entrySet()) {
            hashMap4.put(e.getKey(), CollectionUtils.newUnmodifiableLinkedHashSet(StringUtils.split(e.getValue())));
        }
        this.bpwo = CollectionUtils.unmodifiableMap(hashMap4);
        this.locale = this.getInstanceProperty(BEAN_locale, Locale.class, Locale.getDefault());
        this.timeZone = this.getInstanceProperty(BEAN_timeZone, TimeZone.class, null);
        this.mediaType = this.getInstanceProperty(BEAN_mediaType, MediaType.class, null);
        if (!cmCacheCache.containsKey(this.beanHashCode)) {
            ConcurrentHashMap<Class, ClassMeta<Object>> concurrentHashMap = new ConcurrentHashMap<Class, ClassMeta<Object>>();
            concurrentHashMap.putIfAbsent(String.class, new ClassMeta<String>(String.class, this, null, null, this.findPojoSwaps(String.class), this.findChildPojoSwaps(String.class), this.findExample(String.class)));
            concurrentHashMap.putIfAbsent(Object.class, new ClassMeta<Object>(Object.class, this, null, null, this.findPojoSwaps(Object.class), this.findChildPojoSwaps(Object.class), this.findExample(Object.class)));
            cmCacheCache.putIfAbsent(this.beanHashCode, concurrentHashMap);
        }
        this.cmCache = cmCacheCache.get(this.beanHashCode);
        this.cmString = this.cmCache.get(String.class);
        this.cmObject = this.cmCache.get(Object.class);
        this.cmClass = this.cmCache.get(Class.class);
        this.beanDictionaryClasses = CollectionUtils.unmodifiableList(Arrays.asList(this.getClassArrayProperty(BEAN_beanDictionary)));
        this.beanRegistry = new BeanRegistry(this, null, new Class[0]);
    }

    @Override
    public BeanContextBuilder builder() {
        return new BeanContextBuilder(this.getPropertyStore());
    }

    public static BeanContextBuilder create() {
        return new BeanContextBuilder();
    }

    @Override
    public BeanSession createSession() {
        return this.createBeanSession(this.createDefaultSessionArgs());
    }

    public BeanSession createSession(BeanSessionArgs args) {
        return this.createBeanSession(args);
    }

    @Override
    public final Session createSession(SessionArgs args) {
        throw new NoSuchMethodError();
    }

    public final BeanSession createBeanSession(BeanSessionArgs args) {
        return new BeanSession(this, args);
    }

    public final BeanSession createBeanSession() {
        return new BeanSession(this, this.createDefaultBeanSessionArgs());
    }

    @Override
    public BeanSessionArgs createDefaultSessionArgs() {
        return this.createDefaultBeanSessionArgs();
    }

    public final BeanSessionArgs createDefaultBeanSessionArgs() {
        return new BeanSessionArgs();
    }

    public final boolean hasSameCache(BeanContext bc) {
        return bc.cmCache == this.cmCache;
    }

    protected final boolean isNotABean(Class<?> c) {
        if (c.isArray() || c.isPrimitive() || c.isEnum() || c.isAnnotation()) {
            return true;
        }
        Package p = c.getPackage();
        if (p != null) {
            for (String p2 : this.notBeanPackageNames) {
                if (!p.getName().equals(p2)) continue;
                return true;
            }
            for (String p2 : this.notBeanPackagePrefixes) {
                if (!p.getName().startsWith(p2)) continue;
                return true;
            }
        }
        ClassInfo ci = ClassInfo.of(c);
        for (Class<?> exclude : this.notBeanClasses) {
            if (!ci.isChildOf(exclude)) continue;
            return true;
        }
        return false;
    }

    public boolean isBean(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClassMetaForObject(o).isBean();
    }

    protected static void dumpCacheStats() {
        try {
            int ctCount = 0;
            for (Map<Class, ClassMeta> cm : cmCacheCache.values()) {
                ctCount += cm.size();
            }
            System.out.println(StringUtils.format("ClassMeta cache: {0} instances in {1} caches", ctCount, cmCacheCache.size()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final <T> BeanMeta<T> getBeanMeta(Class<T> c) {
        if (c == null) {
            return null;
        }
        return this.getClassMeta(c).getBeanMeta();
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.getClassMeta(type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> ClassMeta<T> getClassMeta(Class<T> type, boolean waitForInit) {
        if (this.cmCache == null) {
            return null;
        }
        ClassMeta<T> cm = this.cmCache.get(type);
        if (cm == null) {
            BeanContext beanContext = this;
            synchronized (beanContext) {
                cm = this.cmCache.get(type);
                if (cm == null) {
                    cm = new ClassMeta<T>(type, this, this.findImplClass(type), this.findBeanFilter(type), this.findPojoSwaps(type), this.findChildPojoSwaps(type), this.findExample(type));
                }
            }
        }
        if (waitForInit) {
            cm.waitForInit();
        }
        return cm;
    }

    public final <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        ClassMeta cm;
        if (type == null) {
            return null;
        }
        ClassMeta classMeta = cm = type instanceof Class ? this.getClassMeta((Class)type) : this.resolveClassMeta(type, null);
        if (args.length == 0) {
            return cm;
        }
        ClassMeta[] cma = new ClassMeta[args.length + 1];
        cma[0] = cm;
        for (int i = 0; i < Array.getLength(args); ++i) {
            Type arg = (Type)Array.get(args, i);
            cma[i + 1] = arg instanceof Class ? this.getClassMeta((Class)arg) : this.resolveClassMeta(arg, null);
        }
        return this.getTypedClassMeta(cma, 0);
    }

    private ClassMeta<?> getTypedClassMeta(ClassMeta<?>[] c, int pos) {
        ClassMeta cm;
        if ((cm = c[pos++]).isCollection() || cm.isOptional()) {
            ClassMeta<Object> ce = c.length == pos ? this.object() : this.getTypedClassMeta(c, pos);
            return ce.isObject() ? cm : new ClassMeta(cm, null, null, ce);
        }
        if (cm.isMap()) {
            ClassMeta<Object> ck = c.length == pos ? this.object() : c[pos++];
            ClassMeta<Object> cv = c.length == pos ? this.object() : this.getTypedClassMeta(c, pos);
            return ck.isObject() && cv.isObject() ? cm : new ClassMeta(cm, ck, cv, null);
        }
        return cm;
    }

    final ClassMeta resolveClassMeta(Type o, Map<Class<?>, Class<?>[]> typeVarImpls) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClassMeta) {
            ClassMeta cm = (ClassMeta)o;
            if (cm.getBeanContext() == this) {
                return cm;
            }
            if (cm.isMap()) {
                return this.getClassMeta(cm.innerClass, cm.getKeyType(), cm.getValueType());
            }
            if (cm.isCollection() || cm.isOptional()) {
                return this.getClassMeta(cm.innerClass, cm.getElementType());
            }
            return this.getClassMeta(cm.innerClass);
        }
        Class c = this.resolve(o, typeVarImpls);
        if (c == null) {
            return this.object();
        }
        ClassMeta rawType = this.getClassMeta(c);
        if (rawType.isMap() || rawType.isCollection() || rawType.isOptional()) {
            ClassMeta[] params = this.findParameters(o, c);
            if (params == null) {
                return rawType;
            }
            if (rawType.isMap()) {
                if (params.length != 2) {
                    return rawType;
                }
                if (params[0].isObject() && params[1].isObject()) {
                    return rawType;
                }
                return new ClassMeta(rawType, params[0], params[1], null);
            }
            if (rawType.isCollection() || rawType.isOptional()) {
                if (params.length != 1) {
                    return rawType;
                }
                if (params[0].isObject()) {
                    return rawType;
                }
                return new ClassMeta(rawType, null, null, params[0]);
            }
        }
        if (rawType.isArray() && o instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)o;
            ClassMeta elementType = this.resolveClassMeta(gat.getGenericComponentType(), typeVarImpls);
            return new ClassMeta(rawType, null, null, elementType);
        }
        return rawType;
    }

    final Class resolve(Type t, Map<Class<?>, Class<?>[]> typeVarImpls) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof GenericArrayType) {
            Type gatct = ((GenericArrayType)t).getGenericComponentType();
            if (gatct instanceof Class) {
                return Array.newInstance((Class)gatct, 0).getClass();
            }
            if (gatct instanceof ParameterizedType) {
                return Array.newInstance((Class)((ParameterizedType)gatct).getRawType(), 0).getClass();
            }
            if (gatct instanceof GenericArrayType) {
                return Array.newInstance(this.resolve(gatct, typeVarImpls), 0).getClass();
            }
            return null;
        }
        if (t instanceof TypeVariable && typeVarImpls != null) {
            TypeVariable tv = (TypeVariable)t;
            String varName = tv.getName();
            int varIndex = -1;
            Class gc = (Class)tv.getGenericDeclaration();
            TypeVariable<Class<T>>[] tvv = gc.getTypeParameters();
            for (int i = 0; i < tvv.length; ++i) {
                if (!tvv[i].getName().equals(varName)) continue;
                varIndex = i;
            }
            if (varIndex != -1) {
                if (!typeVarImpls.containsKey(gc)) {
                    return null;
                }
                return typeVarImpls.get(gc)[varIndex];
            }
        }
        return null;
    }

    final ClassMeta[] findParameters(Type o, Class c) {
        ParameterizedType pt;
        if (o == null) {
            o = c;
        }
        if (!(o instanceof ParameterizedType)) {
            block0: while (!((o = c.getGenericSuperclass()) instanceof ParameterizedType)) {
                for (Type t : c.getGenericInterfaces()) {
                    o = t;
                    if (o instanceof ParameterizedType) break block0;
                }
                if ((c = c.getSuperclass()) != null) continue;
            }
        }
        if (o instanceof ParameterizedType && !(pt = (ParameterizedType)o).getRawType().equals(Enum.class)) {
            LinkedList<ClassMeta> l = new LinkedList<ClassMeta>();
            for (Type pt2 : pt.getActualTypeArguments()) {
                if (pt2 instanceof WildcardType || pt2 instanceof TypeVariable) {
                    return null;
                }
                l.add(this.resolveClassMeta(pt2, null));
            }
            if (l.isEmpty()) {
                return null;
            }
            return l.toArray(new ClassMeta[l.size()]);
        }
        return null;
    }

    public final <T> ClassMeta<T> getClassMetaForObject(T o) {
        if (o == null) {
            return null;
        }
        return this.getClassMeta(o.getClass());
    }

    protected final <T> ClassMeta<T> resolveClassMeta(BeanProperty px, Beanp p, Type t, Map<Class<?>, Class<?>[]> typeVarImpls) {
        ClassMeta cm;
        ClassMeta cm2 = cm = this.resolveClassMeta(t, typeVarImpls);
        if (px != null) {
            if (px.type() != Object.class) {
                cm2 = this.resolveClassMeta(px.type(), typeVarImpls);
            }
            if (cm2.isMap()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (px.params().length == 0) {
                    Class[] classArray2 = new Class[2];
                    classArray2[0] = Object.class;
                    classArray = classArray2;
                    classArray2[1] = Object.class;
                } else {
                    classArray = pParams = px.params();
                }
                if (pParams.length != 2) {
                    throw new FormattedRuntimeException("Invalid number of parameters specified for Map (must be 2): {0}", pParams.length);
                }
                ClassMeta<?> keyType = this.resolveType(pParams[0], cm2.getKeyType(), cm.getKeyType());
                ClassMeta<?> valueType = this.resolveType(pParams[1], cm2.getValueType(), cm.getValueType());
                if (keyType.isObject() && valueType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, keyType, valueType, null);
            }
            if (cm2.isCollection() || cm2.isOptional()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (px.params().length == 0) {
                    Class[] classArray3 = new Class[1];
                    classArray = classArray3;
                    classArray3[0] = Object.class;
                } else {
                    classArray = pParams = px.params();
                }
                if (pParams.length != 1) {
                    throw new FormattedRuntimeException("Invalid number of parameters specified for " + (cm2.isCollection() ? "Collection" : (cm2.isOptional() ? "Optional" : "Array")) + " (must be 1): {0}", pParams.length);
                }
                ClassMeta<?> elementType = this.resolveType(pParams[0], cm2.getElementType(), cm.getElementType());
                if (elementType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, null, null, elementType);
            }
            return cm2;
        }
        if (p != null) {
            if (p.type() != Object.class) {
                cm2 = this.resolveClassMeta(p.type(), typeVarImpls);
            }
            if (cm2.isMap()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (p.params().length == 0) {
                    Class[] classArray4 = new Class[2];
                    classArray4[0] = Object.class;
                    classArray = classArray4;
                    classArray4[1] = Object.class;
                } else {
                    classArray = pParams = p.params();
                }
                if (pParams.length != 2) {
                    throw new FormattedRuntimeException("Invalid number of parameters specified for Map (must be 2): {0}", pParams.length);
                }
                ClassMeta<?> keyType = this.resolveType(pParams[0], cm2.getKeyType(), cm.getKeyType());
                ClassMeta<?> valueType = this.resolveType(pParams[1], cm2.getValueType(), cm.getValueType());
                if (keyType.isObject() && valueType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, keyType, valueType, null);
            }
            if (cm2.isCollection() || cm2.isOptional()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (p.params().length == 0) {
                    Class[] classArray5 = new Class[1];
                    classArray = classArray5;
                    classArray5[0] = Object.class;
                } else {
                    classArray = pParams = p.params();
                }
                if (pParams.length != 1) {
                    throw new FormattedRuntimeException("Invalid number of parameters specified for " + (cm2.isCollection() ? "Collection" : (cm2.isOptional() ? "Optional" : "Array")) + " (must be 1): {0}", pParams.length);
                }
                ClassMeta<?> elementType = this.resolveType(pParams[0], cm2.getElementType(), cm.getElementType());
                if (elementType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, null, null, elementType);
            }
            return cm2;
        }
        return cm;
    }

    private ClassMeta<?> resolveType(Type ... t) {
        for (Type tt : t) {
            if (tt == null) continue;
            ClassMeta cm = this.getClassMeta(tt, new Type[0]);
            if (tt == this.cmObject) continue;
            return cm;
        }
        return this.cmObject;
    }

    private final <T> PojoSwap[] findPojoSwaps(Class<T> c) {
        if (c != null) {
            ArrayList l = new ArrayList();
            for (PojoSwap<?, ?> f : this.pojoSwaps) {
                if (!f.getNormalClass().isParentOf(c)) continue;
                l.add(f);
            }
            return l.size() == 0 ? null : l.toArray(new PojoSwap[l.size()]);
        }
        return null;
    }

    private final Object findExample(Class<?> c) {
        if (c != null) {
            Object o = this.examples.get(c.getName());
            if (o != null) {
                return o;
            }
            o = this.examples.get(c.getSimpleName());
            if (o != null) {
                return o;
            }
            Class<?> c2 = this.findImplClass(c);
            if (c2 == null) {
                return null;
            }
            o = this.examples.get(c2.getName());
            if (o != null) {
                return o;
            }
            o = this.examples.get(c2.getSimpleName());
            return o;
        }
        return null;
    }

    private final PojoSwap[] findChildPojoSwaps(Class<?> c) {
        if (c == null || this.pojoSwaps.length == 0) {
            return null;
        }
        ArrayList l = null;
        for (PojoSwap<?, ?> f : this.pojoSwaps) {
            if (!f.getNormalClass().isChildOf(c)) continue;
            if (l == null) {
                l = new ArrayList();
            }
            l.add(f);
        }
        return l == null ? null : l.toArray(new PojoSwap[l.size()]);
    }

    private final <T> BeanFilter findBeanFilter(Class<T> c) {
        if (c != null) {
            for (BeanFilter f : this.beanFilters) {
                if (!ClassInfo.of(f.getBeanClass()).isParentOf(c)) continue;
                return f;
            }
        }
        return null;
    }

    protected final <T> ConstructorInfo getImplClassConstructor(Class<T> c, Visibility v) {
        if (this.implClasses.isEmpty()) {
            return null;
        }
        for (Class<T> cc = c; cc != null; cc = cc.getSuperclass()) {
            ClassInfo implClass = this.implClasses.get(cc.getName());
            if (implClass != null) {
                return implClass.getNoArgConstructor(v);
            }
            for (Class<?> ic : cc.getInterfaces()) {
                implClass = this.implClasses.get(ic.getName());
                if (implClass == null) continue;
                return implClass.getNoArgConstructor(v);
            }
        }
        return null;
    }

    private final <T> Class<T> findImplClass(Class<T> c) {
        if (this.implClasses.isEmpty()) {
            return null;
        }
        for (Class<T> cc = c; cc != null; cc = cc.getSuperclass()) {
            ClassInfo implClass = this.implClasses.get(cc.getName());
            if (implClass != null) {
                return implClass.inner();
            }
            for (Class<?> ic : cc.getInterfaces()) {
                implClass = this.implClasses.get(ic.getName());
                if (implClass == null) continue;
                return implClass.inner();
            }
        }
        return null;
    }

    protected final ClassMeta<Object> object() {
        return this.cmObject;
    }

    protected final ClassMeta<String> string() {
        return this.cmString;
    }

    protected final ClassMeta<Class> _class() {
        return this.cmClass;
    }

    protected final BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> a, Class<?> c) {
        if (a == null || c == null) {
            return null;
        }
        if (DISABLE_ANNOTATION_CACHING) {
            return (A)this.annotations.find(c, a).orElse((Annotation)c.getAnnotation(a));
        }
        Optional<Annotation> aa = this.classAnnotationCache.get(c, a);
        if (aa == null) {
            aa = Optional.ofNullable(this.annotations.find(c, a).orElse((Annotation)c.getAnnotation(a)));
            this.classAnnotationCache.put(c, a, aa);
        }
        return (A)((Annotation)aa.orElse(null));
    }

    public <A extends Annotation> A getAnnotation(Class<A> a, ClassInfo c) {
        return this.getAnnotation(a, c == null ? null : c.inner());
    }

    @Override
    public <A extends Annotation> A getDeclaredAnnotation(Class<A> a, Class<?> c) {
        if (a == null || c == null) {
            return null;
        }
        if (DISABLE_ANNOTATION_CACHING) {
            return (A)this.annotations.find(c, a).orElse((Annotation)c.getDeclaredAnnotation(a));
        }
        Optional<Annotation> aa = this.declaredClassAnnotationCache.get(c, a);
        if (aa == null) {
            aa = Optional.ofNullable(this.annotations.find(c, a).orElse((Annotation)c.getDeclaredAnnotation(a)));
            this.declaredClassAnnotationCache.put(c, a, aa);
        }
        return (A)((Annotation)aa.orElse(null));
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> a, ClassInfo c) {
        return this.getDeclaredAnnotation(a, c == null ? null : c.inner());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> a, Method m) {
        if (a == null || m == null) {
            return null;
        }
        if (DISABLE_ANNOTATION_CACHING) {
            return (A)this.annotations.find(m, a).orElse((Annotation)m.getAnnotation(a));
        }
        Optional<Annotation> aa = this.methodAnnotationCache.get(m, a);
        if (aa == null) {
            aa = Optional.ofNullable(this.annotations.find(m, a).orElse((Annotation)m.getAnnotation(a)));
            this.methodAnnotationCache.put(m, a, aa);
        }
        return (A)((Annotation)aa.orElse(null));
    }

    public <A extends Annotation> A getAnnotation(Class<A> a, MethodInfo m) {
        return this.getAnnotation(a, m == null ? null : m.inner());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> a, Field f) {
        if (a == null || f == null) {
            return null;
        }
        if (DISABLE_ANNOTATION_CACHING) {
            return (A)this.annotations.find(f, a).orElse((Annotation)f.getAnnotation(a));
        }
        Optional<Annotation> aa = this.fieldAnnotationCache.get(f, a);
        if (aa == null) {
            aa = Optional.ofNullable(this.annotations.find(f, a).orElse((Annotation)f.getAnnotation(a)));
            this.fieldAnnotationCache.put(f, a, aa);
        }
        return (A)((Annotation)aa.orElse(null));
    }

    public <A extends Annotation> A getAnnotation(Class<A> a, FieldInfo f) {
        return this.getAnnotation(a, f == null ? null : f.inner());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> a, Constructor<?> c) {
        if (a == null || c == null) {
            return null;
        }
        if (DISABLE_ANNOTATION_CACHING) {
            return (A)this.annotations.find(c, a).orElse((Annotation)c.getAnnotation(a));
        }
        Optional<Annotation> aa = this.constructorAnnotationCache.get(c, a);
        if (aa == null) {
            aa = Optional.ofNullable(this.annotations.find(c, a).orElse((Annotation)c.getAnnotation(a)));
            this.constructorAnnotationCache.put(c, a, aa);
        }
        return (A)((Annotation)aa.orElse(null));
    }

    public <A extends Annotation> A getAnnotation(Class<A> a, ConstructorInfo c) {
        return this.getAnnotation(a, c == null ? null : c.inner());
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> a, Class<?> c) {
        return this.getAnnotation(a, c) != null;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> a, ClassInfo c) {
        return this.getAnnotation(a, c == null ? null : c.inner()) != null;
    }

    public <A extends Annotation> boolean hasDeclaredAnnotation(Class<A> a, Class<?> c) {
        return this.getDeclaredAnnotation(a, c) != null;
    }

    public <A extends Annotation> boolean hasDeclaredAnnotation(Class<A> a, ClassInfo c) {
        return this.getDeclaredAnnotation(a, c == null ? null : c.inner()) != null;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> a, Method m) {
        return this.getAnnotation(a, m) != null;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> a, MethodInfo m) {
        return this.getAnnotation(a, m == null ? null : m.inner()) != null;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> a, Field f) {
        return this.getAnnotation(a, f) != null;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> a, FieldInfo f) {
        return this.getAnnotation(a, f == null ? null : f.inner()) != null;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> a, Constructor<?> c) {
        return this.getAnnotation(a, c) != null;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> a, ConstructorInfo c) {
        return this.getAnnotation(a, c == null ? null : c.inner()) != null;
    }

    protected final Visibility getBeanClassVisibility() {
        return this.beanClassVisibility;
    }

    protected final Visibility getBeanConstructorVisibility() {
        return this.beanConstructorVisibility;
    }

    protected final List<Class<?>> getBeanDictionaryClasses() {
        return this.beanDictionaryClasses;
    }

    protected final Visibility getBeanFieldVisibility() {
        return this.beanFieldVisibility;
    }

    protected final BeanFilter[] getBeanFilters() {
        return this.beanFilters;
    }

    protected final boolean isBeanMapPutReturnsOldValue() {
        return this.beanMapPutReturnsOldValue;
    }

    protected final Visibility getBeanMethodVisibility() {
        return this.beanMethodVisibility;
    }

    protected final boolean isBeansRequireDefaultConstructor() {
        return this.beansRequireDefaultConstructor;
    }

    protected final boolean isBeansRequireSerializable() {
        return this.beansRequireSerializable;
    }

    protected final boolean isBeansRequireSettersForGetters() {
        return this.beansRequireSettersForGetters;
    }

    protected final boolean isBeansRequireSomeProperties() {
        return this.beansRequireSomeProperties;
    }

    protected final String getBeanTypePropertyName() {
        return this.beanTypePropertyName;
    }

    protected final Map<String, Set<String>> getBpi() {
        return this.bpi;
    }

    protected Set<String> getBpi(Class<?> c) {
        if (this.bpi.isEmpty()) {
            return CollectionUtils.emptySet();
        }
        ClassInfo ci = ClassInfo.of(c);
        for (ClassInfo c2 : ci.getAllParents()) {
            for (String n : c2.getNames()) {
                Set<String> s = this.bpi.get(n);
                if (s == null) continue;
                return s;
            }
        }
        if (this.bpi.containsKey("*")) {
            return this.bpi.get("*");
        }
        return CollectionUtils.emptySet();
    }

    protected final Map<String, Set<String>> getBpx() {
        return this.bpx;
    }

    protected Set<String> getBpx(Class<?> c) {
        if (this.bpx.isEmpty()) {
            return CollectionUtils.emptySet();
        }
        ClassInfo ci = ClassInfo.of(c);
        for (ClassInfo c2 : ci.getAllParents()) {
            for (String n : c2.getNames()) {
                Set<String> s = this.bpx.get(n);
                if (s == null) continue;
                return s;
            }
        }
        if (this.bpx.containsKey("*")) {
            return this.bpx.get("*");
        }
        return CollectionUtils.emptySet();
    }

    protected final Map<String, Set<String>> getBpro() {
        return this.bpro;
    }

    protected Set<String> getBpro(Class<?> c) {
        if (this.bpro.isEmpty()) {
            return CollectionUtils.emptySet();
        }
        ClassInfo ci = ClassInfo.of(c);
        for (ClassInfo c2 : ci.getAllParents()) {
            for (String n : c2.getNames()) {
                Set<String> s = this.bpro.get(n);
                if (s == null) continue;
                return s;
            }
        }
        if (this.bpro.containsKey("*")) {
            return this.bpro.get("*");
        }
        return CollectionUtils.emptySet();
    }

    protected final Map<String, Set<String>> getBpwo() {
        return this.bpwo;
    }

    protected Set<String> getBpwo(Class<?> c) {
        if (this.bpwo.isEmpty()) {
            return CollectionUtils.emptySet();
        }
        ClassInfo ci = ClassInfo.of(c);
        for (ClassInfo c2 : ci.getAllParents()) {
            for (String n : c2.getNames()) {
                Set<String> s = this.bpwo.get(n);
                if (s == null) continue;
                return s;
            }
        }
        if (this.bpwo.containsKey("*")) {
            return this.bpwo.get("*");
        }
        return CollectionUtils.emptySet();
    }

    protected boolean isDebug() {
        return this.debug;
    }

    protected final Map<String, ?> getExamples() {
        return this.examples;
    }

    protected final boolean isFluentSetters() {
        return this.fluentSetters;
    }

    protected final boolean isIgnoreInvocationExceptionsOnGetters() {
        return this.ignoreInvocationExceptionsOnGetters;
    }

    protected final boolean isIgnoreInvocationExceptionsOnSetters() {
        return this.ignoreInvocationExceptionsOnSetters;
    }

    protected final boolean isIgnorePropertiesWithoutSetters() {
        return this.ignorePropertiesWithoutSetters;
    }

    protected final boolean isIgnoreUnknownBeanProperties() {
        return this.ignoreUnknownBeanProperties;
    }

    protected final boolean isIgnoreUnknownNullBeanProperties() {
        return this.ignoreUnknownNullBeanProperties;
    }

    protected final Map<String, ClassInfo> getImplClasses() {
        return this.implClasses;
    }

    protected final Locale getLocale() {
        return this.locale;
    }

    protected final MediaType getMediaType() {
        return this.mediaType;
    }

    protected final Class<?>[] getNotBeanClasses() {
        return this.notBeanClasses;
    }

    protected final String[] getNotBeanPackagesNames() {
        return this.notBeanPackageNames;
    }

    protected final String[] getNotBeanPackagesPrefixes() {
        return this.notBeanPackagePrefixes;
    }

    protected final PojoSwap<?, ?>[] getPojoSwaps() {
        return this.pojoSwaps;
    }

    protected final PropertyNamer getPropertyNamer() {
        return this.propertyNamer;
    }

    protected final boolean isSortProperties() {
        return this.sortProperties;
    }

    protected final TimeZone getTimeZone() {
        return this.timeZone;
    }

    protected final boolean isUseEnumNames() {
        return this.useEnumNames;
    }

    protected final boolean isUseInterfaceProxies() {
        return this.useInterfaceProxies;
    }

    protected final boolean isUseJavaBeanIntrospector() {
        return this.useJavaBeanIntrospector;
    }

    protected WriterSerializer getBeanToStringSerializer() {
        if (this.beanToStringSerializer == null) {
            if (JsonSerializer.DEFAULT == null) {
                return null;
            }
            this.beanToStringSerializer = JsonSerializer.create().apply(this.getPropertyStore()).sq().simple().build();
        }
        return this.beanToStringSerializer;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("id", System.identityHashCode(this)).append("beanClassVisibility", (Object)this.beanClassVisibility).append("beanConstructorVisibility", (Object)this.beanConstructorVisibility).append("beanDictionaryClasses", this.beanDictionaryClasses).append("beanFieldVisibility", (Object)this.beanFieldVisibility).append("beanFilters", this.beanFilters).append("beanMapPutReturnsOldValue", this.beanMapPutReturnsOldValue).append("beanMethodVisibility", (Object)this.beanMethodVisibility).append("beansRequireDefaultConstructor", this.beansRequireDefaultConstructor).append("beansRequireSerializable", this.beansRequireSerializable).append("beansRequireSettersForGetters", this.beansRequireSettersForGetters).append("beansRequireSomeProperties", this.beansRequireSomeProperties).append("bpi", this.bpi).append("bpx", this.bpx).append("ignoreInvocationExceptionsOnGetters", this.ignoreInvocationExceptionsOnGetters).append("ignoreInvocationExceptionsOnSetters", this.ignoreInvocationExceptionsOnSetters).append("ignorePropertiesWithoutSetters", this.ignorePropertiesWithoutSetters).append("ignoreUnknownBeanProperties", this.ignoreUnknownBeanProperties).append("ignoreUnknownNullBeanProperties", this.ignoreUnknownNullBeanProperties).append("implClasses", this.implClasses).append("locale", this.locale).append("mediaType", this.mediaType).append("notBeanClasses", this.notBeanClasses).append("notBeanPackageNames", this.notBeanPackageNames).append("notBeanPackagePrefixes", this.notBeanPackagePrefixes).append("pojoSwaps", this.pojoSwaps).append("sortProperties", this.sortProperties).append("timeZone", this.timeZone).append("useEnumNames", this.useEnumNames).append("useInterfaceProxies", this.useInterfaceProxies).append("useJavaBeanIntrospector", this.useJavaBeanIntrospector));
    }
}

