/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.web;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.HsqlDbUtils;
import org.eclipse.jetty.jndi.InitialContextFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.webapp.WebAppContext;
import org.hsqldb.jdbc.JDBCDataSource;

public class TestContainer {
    private final Server server;
    public static final int HTTP_PORT = 10024;
    public static final String SHUTDOWN_CMD = "/GO_AWAY";
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String INITIAL_CONTEXT_FACTORY_JETTY = "org.eclipse.jetty.jndi.InitialContextFactory";
    public static final String JNDI_ENV_ROOT = "java:comp/env";
    private static final HsqlDbUtils m_hu = new HsqlDbUtils();
    private static final Logger LOG = LogManager.getLogger(TestContainer.class);
    private static Context initCtx;
    private static Resource userDB;
    private static Resource groupDB;
    private static final ContextHandlerCollection handlerCollection;

    public static void main(String[] args) throws Exception {
        Map<String, String> apps = TestContainer.extractApps(args);
        if (apps.size() == 0) {
            throw new IllegalArgumentException("No apps supplied!");
        }
        TestContainer container = new TestContainer();
        for (Map.Entry<String, String> app : apps.entrySet()) {
            String context = app.getKey();
            String path = app.getValue();
            LOG.error("Adding context " + context + " at path " + path);
            container.addWebApp(context, path);
        }
        handlerCollection.addHandler((Handler)new DefaultHandler());
        m_hu.setUp();
        JDBCDataSource cpds = new JDBCDataSource();
        cpds.setDatabase("jdbc:hsqldb:hsql://localhost/jspwiki");
        cpds.setLoginTimeout(10);
        cpds.setUser("SA");
        cpds.setPassword(null);
        userDB = new Resource("jdbc/UserDatabase", (Object)cpds);
        LOG.error("Configured datasource " + userDB);
        userDB.bindToENC("jdbc/UserDatabase");
        groupDB = new Resource("jdbc/GroupDatabase", (Object)cpds);
        LOG.error("Configured datasource " + groupDB);
        userDB.bindToENC("jdbc/GroupDatabase");
        try {
            LOG.error("Starting up test container.");
            container.server.setHandler((Handler)handlerCollection);
            Handler[] currentHandlers = container.server.getHandlers();
            LOG.error("dumping current handlers");
            for (Handler handler : currentHandlers) {
                Handler[] collection;
                if (!(handler instanceof HandlerCollection)) continue;
                for (Handler h : collection = ((HandlerCollection)handler).getHandlers()) {
                    LOG.error("handler: " + h);
                }
            }
            container.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.error(t.getMessage());
            System.exit(1);
        }
    }

    private static Map<String, String> extractApps(String[] args) {
        HashMap<String, String> apps = new HashMap<String, String>();
        for (String arg : args) {
            String path;
            File file;
            String[] pair = arg.split("=");
            if (pair.length != 2) {
                throw new IllegalArgumentException("Malformed argument '" + arg + "'; expected 'context=path' pattern.");
            }
            Object context = pair[0].trim();
            if (!((String)context).startsWith("/")) {
                context = "/" + (String)context;
            }
            if (!(file = new File(path = pair[1].trim())).exists()) {
                throw new IllegalArgumentException("Path " + path + " does not exist.");
            }
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Path " + path + " cannot be a file; it must be a directory.");
            }
            apps.put((String)context, path);
        }
        return apps;
    }

    public TestContainer() throws Exception {
        String contextFactoryClass = System.getProperty(INITIAL_CONTEXT_FACTORY);
        if (contextFactoryClass == null) {
            System.setProperty(INITIAL_CONTEXT_FACTORY, INITIAL_CONTEXT_FACTORY_JETTY);
            LOG.error("No JNDI context factory found; using org.eclipse.jndi.InitialContextFactory.");
            contextFactoryClass = INITIAL_CONTEXT_FACTORY_JETTY;
        }
        LOG.error("Initialized JNDI with context factory class=" + contextFactoryClass + ".");
        initCtx = new InitialContext();
        try {
            initCtx.lookup(JNDI_ENV_ROOT);
        }
        catch (NameNotFoundException e) {
            initCtx.bind(JNDI_ENV_ROOT, (Object)new NamingContext(new Hashtable(), JNDI_ENV_ROOT, null, (NameParser)new InitialContextFactory.DefaultParser()));
            LOG.error("No JNDI java:comp/env namespace found; creating it,");
        }
        LOG.info("Initialized JNDI java:comp/env namespace.=" + contextFactoryClass);
        LOG.info("Creating new test container.");
        System.setProperty("org.eclipse.xml.XmlParser.NotValidating", "true");
        this.server = new Server();
        this.server.setStopAtShutdown(true);
        NetworkTrafficServerConnector connector = new NetworkTrafficServerConnector(this.server);
        connector.setHost("localhost");
        connector.setPort(10024);
        connector.setIdleTimeout(60000L);
        this.server.setConnectors(new Connector[]{connector});
        LOG.info("added HTTP listener for port 10024");
        ContextHandler shutDownContextHandler = new ContextHandler(SHUTDOWN_CMD);
        shutDownContextHandler.setHandler((Handler)new ShutdownHandler());
        handlerCollection.addHandler((Handler)shutDownContextHandler);
    }

    public void addWebApp(String context, String path) {
        UserStore userStore = new UserStore();
        userStore.addUser("admin", (Credential)new Password("myP@5sw0rd"), new String[]{"Authenticated", "Admin"});
        userStore.addUser("janne", (Credential)new Password("myP@5sw0rd"), new String[]{"Authenticated"});
        HashLoginService loginService = new HashLoginService("JSPWikiRealm");
        loginService.setUserStore(userStore);
        WebAppContext webAppContext = new WebAppContext(path, context);
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setLoginService((LoginService)loginService);
        webAppContext.setSecurityHandler((SecurityHandler)csh);
        LOG.error("Adding webapp " + context + " for path " + path);
        handlerCollection.addHandler((Handler)webAppContext);
    }

    public void start() throws Exception {
        System.setProperty("org.eclipse.http.HttpRequest.maxFormContentSize", "0");
        this.server.start();
        LOG.error("jetty server started");
    }

    public void stop() {
        try {
            this.server.stop();
            LOG.error("jetty server stopped");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        handlerCollection = new ContextHandlerCollection();
    }

    public static final class ShutdownHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getRequestURI().contains(TestContainer.SHUTDOWN_CMD)) {
                LOG.error("stop cmd received, shutting down server");
                System.exit(0);
            } else {
                LOG.error("ignoring request " + request.getRequestURI());
            }
        }
    }
}

