/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.ConfluenceSpaceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.transform.ConfluenceSpaceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfluenceSpaceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean crawlPersonalSpaces;
    private Boolean crawlArchivedSpaces;
    private List<String> includeSpaces;
    private List<String> excludeSpaces;
    private List<ConfluenceSpaceToIndexFieldMapping> spaceFieldMappings;

    public void setCrawlPersonalSpaces(Boolean crawlPersonalSpaces) {
        this.crawlPersonalSpaces = crawlPersonalSpaces;
    }

    public Boolean getCrawlPersonalSpaces() {
        return this.crawlPersonalSpaces;
    }

    public ConfluenceSpaceConfiguration withCrawlPersonalSpaces(Boolean crawlPersonalSpaces) {
        this.setCrawlPersonalSpaces(crawlPersonalSpaces);
        return this;
    }

    public Boolean isCrawlPersonalSpaces() {
        return this.crawlPersonalSpaces;
    }

    public void setCrawlArchivedSpaces(Boolean crawlArchivedSpaces) {
        this.crawlArchivedSpaces = crawlArchivedSpaces;
    }

    public Boolean getCrawlArchivedSpaces() {
        return this.crawlArchivedSpaces;
    }

    public ConfluenceSpaceConfiguration withCrawlArchivedSpaces(Boolean crawlArchivedSpaces) {
        this.setCrawlArchivedSpaces(crawlArchivedSpaces);
        return this;
    }

    public Boolean isCrawlArchivedSpaces() {
        return this.crawlArchivedSpaces;
    }

    public List<String> getIncludeSpaces() {
        return this.includeSpaces;
    }

    public void setIncludeSpaces(Collection<String> includeSpaces) {
        if (includeSpaces == null) {
            this.includeSpaces = null;
            return;
        }
        this.includeSpaces = new ArrayList<String>(includeSpaces);
    }

    public ConfluenceSpaceConfiguration withIncludeSpaces(String ... includeSpaces) {
        if (this.includeSpaces == null) {
            this.setIncludeSpaces(new ArrayList<String>(includeSpaces.length));
        }
        for (String ele : includeSpaces) {
            this.includeSpaces.add(ele);
        }
        return this;
    }

    public ConfluenceSpaceConfiguration withIncludeSpaces(Collection<String> includeSpaces) {
        this.setIncludeSpaces(includeSpaces);
        return this;
    }

    public List<String> getExcludeSpaces() {
        return this.excludeSpaces;
    }

    public void setExcludeSpaces(Collection<String> excludeSpaces) {
        if (excludeSpaces == null) {
            this.excludeSpaces = null;
            return;
        }
        this.excludeSpaces = new ArrayList<String>(excludeSpaces);
    }

    public ConfluenceSpaceConfiguration withExcludeSpaces(String ... excludeSpaces) {
        if (this.excludeSpaces == null) {
            this.setExcludeSpaces(new ArrayList<String>(excludeSpaces.length));
        }
        for (String ele : excludeSpaces) {
            this.excludeSpaces.add(ele);
        }
        return this;
    }

    public ConfluenceSpaceConfiguration withExcludeSpaces(Collection<String> excludeSpaces) {
        this.setExcludeSpaces(excludeSpaces);
        return this;
    }

    public List<ConfluenceSpaceToIndexFieldMapping> getSpaceFieldMappings() {
        return this.spaceFieldMappings;
    }

    public void setSpaceFieldMappings(Collection<ConfluenceSpaceToIndexFieldMapping> spaceFieldMappings) {
        if (spaceFieldMappings == null) {
            this.spaceFieldMappings = null;
            return;
        }
        this.spaceFieldMappings = new ArrayList<ConfluenceSpaceToIndexFieldMapping>(spaceFieldMappings);
    }

    public ConfluenceSpaceConfiguration withSpaceFieldMappings(ConfluenceSpaceToIndexFieldMapping ... spaceFieldMappings) {
        if (this.spaceFieldMappings == null) {
            this.setSpaceFieldMappings(new ArrayList<ConfluenceSpaceToIndexFieldMapping>(spaceFieldMappings.length));
        }
        for (ConfluenceSpaceToIndexFieldMapping ele : spaceFieldMappings) {
            this.spaceFieldMappings.add(ele);
        }
        return this;
    }

    public ConfluenceSpaceConfiguration withSpaceFieldMappings(Collection<ConfluenceSpaceToIndexFieldMapping> spaceFieldMappings) {
        this.setSpaceFieldMappings(spaceFieldMappings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCrawlPersonalSpaces() != null) {
            sb.append("CrawlPersonalSpaces: ").append(this.getCrawlPersonalSpaces()).append(",");
        }
        if (this.getCrawlArchivedSpaces() != null) {
            sb.append("CrawlArchivedSpaces: ").append(this.getCrawlArchivedSpaces()).append(",");
        }
        if (this.getIncludeSpaces() != null) {
            sb.append("IncludeSpaces: ").append(this.getIncludeSpaces()).append(",");
        }
        if (this.getExcludeSpaces() != null) {
            sb.append("ExcludeSpaces: ").append(this.getExcludeSpaces()).append(",");
        }
        if (this.getSpaceFieldMappings() != null) {
            sb.append("SpaceFieldMappings: ").append(this.getSpaceFieldMappings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceSpaceConfiguration)) {
            return false;
        }
        ConfluenceSpaceConfiguration other = (ConfluenceSpaceConfiguration)obj;
        if (other.getCrawlPersonalSpaces() == null ^ this.getCrawlPersonalSpaces() == null) {
            return false;
        }
        if (other.getCrawlPersonalSpaces() != null && !other.getCrawlPersonalSpaces().equals(this.getCrawlPersonalSpaces())) {
            return false;
        }
        if (other.getCrawlArchivedSpaces() == null ^ this.getCrawlArchivedSpaces() == null) {
            return false;
        }
        if (other.getCrawlArchivedSpaces() != null && !other.getCrawlArchivedSpaces().equals(this.getCrawlArchivedSpaces())) {
            return false;
        }
        if (other.getIncludeSpaces() == null ^ this.getIncludeSpaces() == null) {
            return false;
        }
        if (other.getIncludeSpaces() != null && !other.getIncludeSpaces().equals(this.getIncludeSpaces())) {
            return false;
        }
        if (other.getExcludeSpaces() == null ^ this.getExcludeSpaces() == null) {
            return false;
        }
        if (other.getExcludeSpaces() != null && !other.getExcludeSpaces().equals(this.getExcludeSpaces())) {
            return false;
        }
        if (other.getSpaceFieldMappings() == null ^ this.getSpaceFieldMappings() == null) {
            return false;
        }
        return other.getSpaceFieldMappings() == null || other.getSpaceFieldMappings().equals(this.getSpaceFieldMappings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCrawlPersonalSpaces() == null ? 0 : this.getCrawlPersonalSpaces().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlArchivedSpaces() == null ? 0 : this.getCrawlArchivedSpaces().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeSpaces() == null ? 0 : this.getIncludeSpaces().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeSpaces() == null ? 0 : this.getExcludeSpaces().hashCode());
        hashCode = 31 * hashCode + (this.getSpaceFieldMappings() == null ? 0 : this.getSpaceFieldMappings().hashCode());
        return hashCode;
    }

    public ConfluenceSpaceConfiguration clone() {
        try {
            return (ConfluenceSpaceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfluenceSpaceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

