/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows.ui;

import com.github.weisj.darklaf.icons.ScaledIcon;
import com.github.weisj.darklaf.icons.ToggleIcon;
import com.github.weisj.darklaf.platform.decorations.CustomTitlePane;
import com.github.weisj.darklaf.platform.windows.JNIDecorationsWindows;
import com.github.weisj.darklaf.platform.windows.PointerUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.Scale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class WindowsTitlePane
extends CustomTitlePane {
    public static final String KEY_RESIZABLE = "resizable";
    public static final String KEY_STATE = "state";
    public static final String KEY_ICON_IMAGE = "iconImage";
    private static final Logger LOGGER = LogUtil.getLogger(WindowsTitlePane.class);
    private static final int PAD = 5;
    private static final int BAR_HEIGHT = 28;
    private static final int BUTTON_WIDTH = 46;
    private static final int ICON_WIDTH = 32;
    private static final int ICON_SIZE = 17;
    private final JRootPane rootPane;
    private boolean unifiedMenuBar;
    private boolean titleBarHidden;
    private ContainerListener rootPaneContainerListener;
    private ContainerListener layeredPaneContainerListener;
    private boolean oldResizable;
    private PropertyChangeListener windowPropertyChangeListener;
    private PropertyChangeListener rootPanePropertyChangeListener;
    private WindowListener windowListener;
    private ToggleIcon closeIcon;
    private ToggleIcon maximizeIcon;
    private ToggleIcon restoreIcon;
    private ToggleIcon minimizeIcon;
    private JButton windowIconButton;
    private JButton closeButton;
    private JButton maximizeToggleButton;
    private JButton minimizeButton;
    private Action closeAction;
    private Action restoreAction;
    private Action maximizeAction;
    private Action minimizeAction;
    private JLabel titleLabel;
    private final Window window;
    private long windowHandle;
    private JMenuBar menuBar;
    private int state;
    private Color inactiveBackground;
    private Color inactiveForeground;
    private Color inactiveHover;
    private Color inactiveClick;
    private Color activeBackground;
    private Color activeForeground;
    private Color border;
    private Border oldBorder;
    private int left;
    private int right;
    private int height;
    private GraphicsConfiguration gc;

    public WindowsTitlePane(JRootPane root, int decorationStyle, Window window) {
        this.rootPane = root;
        this.window = window;
        this.decorationStyle = decorationStyle;
        this.state = -1;
        this.oldResizable = true;
        this.installSubcomponents();
        this.updateMenuBar(true);
        this.updateTitleBarVisibility();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void updateMenuBar(boolean install) {
        this.unifiedMenuBar = PropertyUtil.getBooleanProperty((JComponent)this.rootPane, (String)"JRootPane.unifiedMenuBar");
        if (this.unifiedMenuBar && install) {
            if (this.rootPaneContainerListener == null) {
                this.rootPaneContainerListener = this.createRootPaneContainerListener();
            }
            if (this.layeredPaneContainerListener == null) {
                this.layeredPaneContainerListener = this.createLayeredPaneContainerListener();
            }
            this.rootPane.addContainerListener(this.rootPaneContainerListener);
            this.rootPane.getLayeredPane().addContainerListener(this.layeredPaneContainerListener);
            this.addMenuBar(this.getRootPane().getJMenuBar());
        } else {
            this.rootPane.removeContainerListener(this.rootPaneContainerListener);
            this.rootPane.getLayeredPane().removeContainerListener(this.layeredPaneContainerListener);
            if (this.menuBar != null) {
                this.getRootPane().setJMenuBar(this.menuBar);
                this.menuBar.setPreferredSize(null);
                this.menuBar = null;
            }
        }
        this.rootPane.revalidate();
    }

    private void updateTitleBarVisibility() {
        this.titleBarHidden = PropertyUtil.getBooleanProperty((JComponent)this.rootPane, (String)"JRootPane.hideTitleBar");
        this.rootPane.doLayout();
        this.rootPane.repaint();
    }

    private ContainerListener createRootPaneContainerListener() {
        return new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JLayeredPane) {
                    ((JLayeredPane)e.getChild()).addContainerListener(WindowsTitlePane.this.layeredPaneContainerListener);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() instanceof JLayeredPane) {
                    ((JLayeredPane)e.getChild()).removeContainerListener(WindowsTitlePane.this.layeredPaneContainerListener);
                }
            }
        };
    }

    private ContainerListener createLayeredPaneContainerListener() {
        return new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JMenuBar) {
                    WindowsTitlePane.this.addMenuBar(WindowsTitlePane.this.getRootPane().getJMenuBar());
                }
                if (WindowsTitlePane.this.getRootPane().getJMenuBar() == null && WindowsTitlePane.this.menuBar != null) {
                    WindowsTitlePane.this.removeMenuBar();
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        };
    }

    private static JButton createButton(Icon icon, Action action) {
        return WindowsTitlePane.createButton(icon, action, false);
    }

    private static JButton createButton(Icon icon, Action action, boolean close) {
        JButton button = new JButton(action);
        button.setRolloverEnabled(true);
        if (close) {
            button.putClientProperty("JButton.borderless.hover", UIManager.getColor("Windows.TitlePane.close.rollOverColor"));
            button.putClientProperty("JButton.borderless.click", UIManager.getColor("Windows.TitlePane.close.clickColor"));
        }
        button.putClientProperty("JButton.noBorderlessOverwrite", true);
        button.setFocusable(false);
        button.setOpaque(false);
        button.setRolloverEnabled(true);
        button.putClientProperty("JButton.variant", "borderlessRectangular");
        button.putClientProperty("paintActive", Boolean.TRUE);
        button.putClientProperty("AccessibleName", button.getText());
        button.putClientProperty("JToolTip.style", "plain");
        button.setToolTipText(button.getText());
        button.setIcon(icon);
        button.setText(null);
        return button;
    }

    public void uninstall(boolean removeDecorations) {
        this.uninstallListeners();
        this.uninstallDecorations(removeDecorations);
        this.removeAll();
        this.updateMenuBar(false);
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.windowPropertyChangeListener);
        }
        if (this.rootPane != null) {
            this.rootPane.removePropertyChangeListener(this.rootPanePropertyChangeListener);
        }
    }

    protected void uninstallDecorations(boolean removeDecorations) {
        if (this.windowHandle != 0L) {
            if (removeDecorations) {
                JNIDecorationsWindows.uninstallDecorations(this.windowHandle, this.decorationStyle != 0);
            }
            this.windowHandle = 0L;
        }
        this.rootPane.removeContainerListener(this.rootPaneContainerListener);
        this.rootPane.getLayeredPane().removeContainerListener(this.layeredPaneContainerListener);
        if (this.menuBar != null) {
            this.menuBar.setPreferredSize(null);
            this.rootPane.setJMenuBar(this.menuBar);
        }
    }

    public void install() {
        if (this.window != null) {
            if (!this.installDecorations()) {
                return;
            }
            if (this.window instanceof Frame) {
                this.titleLabel.setText(((Frame)this.window).getTitle());
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            if (this.window instanceof Dialog) {
                this.titleLabel.setText(((Dialog)this.window).getTitle());
            }
            this.determineColors();
            this.setActive(this.window.isActive());
            this.installListeners();
            if (this.getComponentCount() == 0) {
                this.addComponents();
            }
            this.updateSystemIcon(this.getGraphicsConfiguration());
        }
    }

    public void setDecorationsStyle(int style) {
        super.setDecorationsStyle(style);
        if (style == 0 && this.windowHandle != 0L) {
            this.uninstall(true);
        } else if (this.windowHandle == 0L) {
            this.install();
        }
    }

    private boolean installDecorations() {
        if (this.getDecorationStyle() == 0) {
            return false;
        }
        if (!this.window.isDisplayable()) {
            return false;
        }
        if (this.window instanceof Dialog || this.window instanceof Frame) {
            this.windowHandle = PointerUtil.getHWND(this.window);
            if (this.windowHandle > 0L) {
                LOGGER.fine("Installing decorations for window " + this.windowHandle);
                if (!JNIDecorationsWindows.installDecorations(this.windowHandle)) {
                    LOGGER.fine("Already installed.");
                }
                this.updateResizeBehaviour();
                Color color = this.rootPane.getBackground();
                JNIDecorationsWindows.setBackground(this.windowHandle, color.getRed(), color.getGreen(), color.getBlue());
            } else {
                this.uninstall(this.decorationStyle != 0);
                return false;
            }
        }
        return true;
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.windowPropertyChangeListener = this.createWindowPropertyChangeListener();
            this.rootPanePropertyChangeListener = this.createRootPanePropertyChangeListener();
            this.rootPane.addPropertyChangeListener(this.rootPanePropertyChangeListener);
            this.window.addPropertyChangeListener(this.windowPropertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new WindowPropertyChangeListener();
    }

    private PropertyChangeListener createRootPanePropertyChangeListener() {
        return new RootPanePropertyChangeListener();
    }

    private void installSubcomponents() {
        this.titleLabel = new JLabel();
        this.titleLabel.setHorizontalAlignment(2);
        this.createIcons();
        this.createActions();
        this.createButtons();
        this.addComponents();
    }

    private void addComponents() {
        this.add(this.windowIconButton);
        this.add(this.minimizeButton);
        this.add(this.maximizeToggleButton);
        this.add(this.closeButton);
        this.add(this.titleLabel);
        this.setComponentZOrder(this.closeButton, 0);
        this.setComponentZOrder(this.maximizeToggleButton, 1);
        this.setComponentZOrder(this.minimizeButton, 2);
        this.setComponentZOrder(this.windowIconButton, 3);
        this.setComponentZOrder(this.titleLabel, 4);
    }

    protected void addMenuBar(JMenuBar menuBar) {
        if (menuBar != null && this.unifiedMenuBar) {
            this.menuBar = menuBar;
            menuBar.setPreferredSize(new Dimension(0, 0));
            menuBar.setOpaque(false);
            this.add(menuBar);
            this.setComponentZOrder(menuBar, 5);
        }
    }

    protected void removeMenuBar() {
        this.remove(this.menuBar);
        this.menuBar.setOpaque(true);
        this.menuBar = null;
    }

    private void determineColors() {
        switch (this.getDecorationStyle()) {
            case 4: {
                this.activeBackground = UIManager.getColor("Windows.OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("Windows.OptionPane.errorDialog.titlePane.foreground");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("Windows.OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("Windows.OptionPane.questionDialog.titlePane.foreground");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("Windows.OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("Windows.OptionPane.warningDialog.titlePane.foreground");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("Windows.TitlePane.background");
                this.activeForeground = UIManager.getColor("Windows.TitlePane.foreground");
            }
        }
        this.inactiveBackground = UIManager.getColor("Windows.TitlePane.inactiveBackground");
        this.inactiveForeground = UIManager.getColor("Windows.TitlePane.inactiveForeground");
        this.inactiveHover = UIManager.getColor("Windows.TitlePane.inactiveBackgroundHover");
        this.inactiveClick = UIManager.getColor("Windows.TitlePane.inactiveBackgroundClick");
        this.border = UIManager.getColor("Windows.TitlePane.borderColor");
        this.activeForeground = new Color(this.activeForeground.getRGB());
        this.inactiveForeground = new Color(this.inactiveForeground.getRGB());
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected JButton createWindowIcon() {
        JButton button = new JButton();
        button.putClientProperty("JButton.noShadowOverwrite", true);
        button.setComponentPopupMenu(this.createMenu());
        button.addActionListener(e -> button.getComponentPopupMenu().show(button, button.getWidth() / 2, button.getHeight() / 2));
        button.setFocusable(false);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        return button;
    }

    private JPopupMenu createMenu() {
        JPopupMenu menu = new JPopupMenu();
        if (this.getDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private JMenuItem itemWithDisabledIcon(JMenuItem item, Icon disabledIcon) {
        item.setDisabledIcon(disabledIcon);
        return item;
    }

    private void addMenuItems(JPopupMenu menu) {
        menu.add(this.itemWithDisabledIcon(new JMenuItem(this.restoreAction), (Icon)this.restoreIcon));
        menu.add(this.itemWithDisabledIcon(new JMenuItem(this.minimizeAction), (Icon)this.minimizeIcon));
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.itemWithDisabledIcon(new JMenuItem(this.maximizeAction), (Icon)this.maximizeIcon));
        }
        menu.addSeparator();
        menu.add(this.itemWithDisabledIcon(new JMenuItem(this.closeAction), (Icon)this.closeIcon));
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private Window getWindow() {
        return this.window;
    }

    private void minimize() {
        JNIDecorationsWindows.minimize(this.windowHandle);
    }

    private void maximize() {
        JNIDecorationsWindows.maximize(this.windowHandle);
    }

    private void restore() {
        JNIDecorationsWindows.restore(this.windowHandle);
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.minimizeAction = new MinimizeAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    private void createIcons() {
        this.minimizeIcon = new ToggleIcon(UIManager.getIcon("Windows.TitlePane.minimize.icon"), UIManager.getIcon("Windows.TitlePane.minimizeInactive.icon"));
        this.maximizeIcon = new ToggleIcon(UIManager.getIcon("Windows.TitlePane.maximize.icon"), UIManager.getIcon("Windows.TitlePane.maximizeInactive.icon"));
        this.restoreIcon = new ToggleIcon(UIManager.getIcon("Windows.TitlePane.restore.icon"), UIManager.getIcon("Windows.TitlePane.restoreInactive.icon"));
        this.closeIcon = new ToggleIcon(UIManager.getIcon("Windows.TitlePane.close.icon"), UIManager.getIcon("Windows.TitlePane.closeInactive.icon"));
    }

    private void createButtons() {
        this.closeButton = WindowsTitlePane.createButton((Icon)this.closeIcon, this.closeAction, true);
        Icon closePressed = UIManager.getIcon("Windows.TitlePane.closeHover.icon");
        this.closeButton.setRolloverIcon(closePressed);
        this.closeButton.setPressedIcon(closePressed);
        this.minimizeButton = WindowsTitlePane.createButton((Icon)this.minimizeIcon, this.minimizeAction);
        this.maximizeToggleButton = WindowsTitlePane.createButton((Icon)this.maximizeIcon, this.restoreAction);
        this.windowIconButton = this.createWindowIcon();
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean active) {
        this.closeIcon.setActive(active);
        this.titleLabel.setForeground(active ? this.activeForeground : this.inactiveForeground);
        this.minimizeIcon.setActive(active);
        this.maximizeIcon.setActive(this.isResizable() && active);
        this.closeIcon.setActive(active);
        this.restoreIcon.setActive(this.isResizable());
        this.setButtonActive(this.minimizeButton, active);
        this.setButtonActive(this.maximizeToggleButton, this.isResizable());
        this.getRootPane().repaint();
    }

    protected void setButtonActive(JButton button, boolean active) {
        if (active) {
            button.putClientProperty("JButton.borderless.hover", null);
            button.putClientProperty("JButton.borderless.click", null);
        } else {
            button.putClientProperty("JButton.borderless.hover", this.inactiveHover);
            button.putClientProperty("JButton.borderless.click", this.inactiveClick);
        }
    }

    public void paintComponent(Graphics g) {
        GraphicsConfiguration currentGC;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        this.updateResizeBehaviour();
        Window window = this.getWindow();
        boolean active = window == null || window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        Color background = active ? this.activeBackground : this.inactiveBackground;
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        if (this.isDrawBorder()) {
            g.setColor(this.border);
            g.fillRect(0, height - 1, width, 1);
        }
        if ((currentGC = this.getGraphicsConfiguration()) != null && currentGC != this.gc) {
            this.gc = currentGC;
            this.updateDragArea(this.gc);
            this.updateSystemIcon(this.gc);
        }
    }

    protected boolean isDrawBorder() {
        return this.getDecorationStyle() != 0 && this.menuBar != null;
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private Frame getFrame() {
        if (this.window instanceof Frame) {
            return (Frame)this.window;
        }
        return null;
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    protected void updateResizeBehaviour() {
        boolean res = this.isResizable();
        if (this.oldResizable != res) {
            this.oldResizable = res;
            JNIDecorationsWindows.setResizable(this.windowHandle, res);
        }
    }

    private void setState(int state, boolean updateRegardless) {
        Window wnd = this.getWindow();
        if (wnd != null && this.getDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0) {
                    this.oldBorder = rootPane.getBorder();
                    LookAndFeel.uninstallBorder(rootPane);
                } else {
                    Border border = rootPane.getBorder();
                    if (this.oldBorder != null && border == null || border instanceof UIResource) {
                        rootPane.setBorder(this.oldBorder);
                    }
                }
                if (frame.isResizable()) {
                    this.maximizeIcon.setActive(true);
                    this.restoreIcon.setActive(true);
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, (Icon)this.restoreIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, (Icon)this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    this.maximizeToggleButton.setText(null);
                } else {
                    this.maximizeIcon.setActive(false);
                    this.restoreIcon.setActive(false);
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.minimizeAction.setEnabled(false);
            }
            this.closeAction.setEnabled(true);
            this.state = state;
            this.repaint();
        }
    }

    protected boolean isResizable() {
        if (0 == this.getDecorationStyle()) {
            return false;
        }
        if (this.window instanceof Dialog) {
            return ((Dialog)this.window).isResizable();
        }
        if (this.window instanceof Frame) {
            return ((Frame)this.window).isResizable();
        }
        return false;
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.maximizeToggleButton.setAction(action);
        this.maximizeToggleButton.setIcon(icon);
        this.maximizeToggleButton.setToolTipText(this.maximizeToggleButton.getText());
        this.maximizeToggleButton.putClientProperty("AccessibleName", this.maximizeToggleButton.getText());
        this.maximizeToggleButton.setText(null);
    }

    protected boolean isLeftToRight(Window window) {
        return window == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
    }

    private void updateSystemIcon(GraphicsConfiguration gc) {
        boolean frame = this.getDecorationStyle() == 1;
        Window window = this.getWindow();
        if (window == null) {
            this.windowIconButton.setIcon(null);
            return;
        }
        List<Image> icons = window.getIconImages();
        Icon systemIcon = null;
        if (icons == null || icons.size() == 0) {
            if (frame) {
                systemIcon = UIManager.getIcon("Windows.TitlePane.icon");
            }
        } else {
            systemIcon = icons.size() == 1 ? new ScaledIcon(icons.get(0).getScaledInstance((int)Scale.scaleWidth((double)17.0, (GraphicsConfiguration)gc), (int)Scale.scaleHeight((double)17.0, (GraphicsConfiguration)gc), 16), (Component)((Object)this)) : new ScaledIcon(this.getScaledIconImage((Component)((Object)this), icons, (int)Scale.scaleWidth((double)17.0, (GraphicsConfiguration)gc), (int)Scale.scaleHeight((double)17.0, (GraphicsConfiguration)gc)), (Component)((Object)this));
        }
        if (this.windowIconButton != null) {
            this.windowIconButton.setIcon(systemIcon);
            SwingUtilities.invokeLater(() -> this.repaint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getScaledIconImage(Component c, List<Image> images, int width, int height) {
        Image bestImage = null;
        int dw = 0;
        int dh = 0;
        for (Image image : images) {
            this.ensureImageLoaded(c, image);
            int dwi = Math.abs(dw - image.getWidth(c));
            int dhi = Math.abs(dh - image.getHeight(c));
            if (bestImage != null && dwi + dhi >= dw + dh) continue;
            bestImage = image;
            dw = dwi;
            dh = dhi;
        }
        if (bestImage == null) {
            return null;
        }
        int iw = bestImage.getWidth(null);
        int ih = bestImage.getHeight(null);
        double scaleFactor = Math.min((double)width / (double)iw, (double)height / (double)ih);
        int bestWidth = (int)(scaleFactor * (double)iw);
        int bestHeight = (int)(scaleFactor * (double)ih);
        BufferedImage bimage = new BufferedImage(width, height, 2);
        Graphics2D g = bimage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            int x = (width - bestWidth) / 2;
            int y = (height - bestHeight) / 2;
            g.drawImage(bestImage, x, y, bestWidth, bestHeight, c);
        }
        finally {
            g.dispose();
        }
        return bimage;
    }

    private void ensureImageLoaded(Component c, Image img) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean hideTitleBar() {
        if (this.titleBarHidden) {
            return true;
        }
        String title = this.titleLabel.getText();
        if (title == null) {
            title = "";
        }
        boolean emptyMenuBar = !this.unifiedMenuBar || this.menuBar == null || !this.menuBar.isVisible();
        boolean emptyContent = this.getDecorationStyle() == 0 && emptyMenuBar && title.length() == 0;
        return this.windowHandle == 0L || emptyContent || this.menuBar != null && !this.menuBar.isVisible();
    }

    public Dimension getPreferredSize() {
        if (this.hideTitleBar()) {
            return new Dimension(0, 0);
        }
        int height = this.computeHeight();
        int width = this.computeWidth();
        if (this.isDrawBorder()) {
            ++height;
        }
        return new Dimension(width, height);
    }

    private int computeHeight() {
        if (this.hideTitleBar()) {
            return 0;
        }
        FontMetrics fm = this.rootPane.getFontMetrics(this.getFont());
        int height = fm.getHeight() + 7;
        if (this.menuBar != null) {
            height = Math.max(height, this.menuBar.getMinimumSize().height);
        }
        return Math.max(28, height);
    }

    private int computeWidth() {
        boolean undecorated;
        int width = 0;
        Icon windowIcon = this.windowIconButton.getIcon();
        if (windowIcon != null) {
            width += Math.min(32, Math.max(windowIcon.getIconHeight(), windowIcon.getIconWidth()));
            width += 10;
        }
        if (this.menuBar != null) {
            width += this.getPreferredMenuSize().width;
            width += 5;
        }
        boolean frame = this.getDecorationStyle() == 1;
        boolean bl = undecorated = this.getDecorationStyle() == 0;
        if (!undecorated) {
            width += 46;
        }
        if (frame) {
            width += 46;
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                width += 46;
            }
        }
        if (this.titleLabel != null && !this.titleLabel.getText().isEmpty()) {
            width += this.titleLabel.getPreferredSize().width;
            width += 5;
        }
        return width;
    }

    protected void updateDragArea(GraphicsConfiguration gc) {
        JNIDecorationsWindows.updateValues(this.windowHandle, (int)Scale.scaleWidth((double)this.left, (GraphicsConfiguration)gc), (int)Scale.scaleWidth((double)this.right, (GraphicsConfiguration)gc), (int)Scale.scaleHeight((double)this.height, (GraphicsConfiguration)gc));
    }

    private Dimension getPreferredMenuSize() {
        LayoutManager menuBarLayout = this.menuBar.getLayout();
        Dimension size = null;
        if (menuBarLayout != null) {
            size = menuBarLayout.preferredLayoutSize(this.menuBar);
        }
        return size != null ? size : this.menuBar.getPreferredSize();
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            WindowsTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            WindowsTitlePane.this.setActive(false);
        }
    }

    protected class WindowPropertyChangeListener
    implements PropertyChangeListener {
        protected WindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if (WindowsTitlePane.KEY_RESIZABLE.equals(name) || WindowsTitlePane.KEY_STATE.equals(name)) {
                Frame frame = WindowsTitlePane.this.getFrame();
                if (frame != null) {
                    WindowsTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if (WindowsTitlePane.KEY_RESIZABLE.equals(name)) {
                    JNIDecorationsWindows.setResizable(WindowsTitlePane.this.windowHandle, Boolean.TRUE.equals(pce.getNewValue()));
                    WindowsTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                WindowsTitlePane.this.titleLabel.setText(pce.getNewValue() == null ? "" : pce.getNewValue().toString());
                WindowsTitlePane.this.doLayout();
                WindowsTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                WindowsTitlePane.this.revalidate();
                WindowsTitlePane.this.repaint();
            } else if (WindowsTitlePane.KEY_ICON_IMAGE.equals(name)) {
                WindowsTitlePane.this.updateSystemIcon(WindowsTitlePane.this.getGraphicsConfiguration());
                WindowsTitlePane.this.revalidate();
                WindowsTitlePane.this.repaint();
            } else if ("background".equals(name) && pce.getNewValue() instanceof Color) {
                Color color = (Color)pce.getNewValue();
                if (color == null) {
                    return;
                }
                JNIDecorationsWindows.setBackground(WindowsTitlePane.this.windowHandle, color.getRed(), color.getGreen(), color.getBlue());
            }
        }
    }

    protected class RootPanePropertyChangeListener
    implements PropertyChangeListener {
        protected RootPanePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("JRootPane.unifiedMenuBar".equals(evt.getPropertyName())) {
                WindowsTitlePane.this.updateMenuBar(true);
            } else if ("JRootPane.hideTitleBar".equals(evt.getPropertyName())) {
                WindowsTitlePane.this.updateTitleBarVisibility();
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"Actions.close", WindowsTitlePane.this.getLocale()), (Icon)WindowsTitlePane.this.closeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowsTitlePane.this.close();
        }
    }

    private class MinimizeAction
    extends AbstractAction {
        public MinimizeAction() {
            super(UIManager.getString((Object)"Actions.minimize", WindowsTitlePane.this.getLocale()), (Icon)WindowsTitlePane.this.minimizeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowsTitlePane.this.minimize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"Actions.restore", WindowsTitlePane.this.getLocale()), (Icon)WindowsTitlePane.this.restoreIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowsTitlePane.this.restore();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"Actions.maximize", WindowsTitlePane.this.getLocale()), (Icon)WindowsTitlePane.this.maximizeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowsTitlePane.this.maximize();
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return WindowsTitlePane.this.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            if (WindowsTitlePane.this.hideTitleBar()) {
                return;
            }
            boolean leftToRight = WindowsTitlePane.this.isLeftToRight(WindowsTitlePane.this.window);
            boolean frame = WindowsTitlePane.this.getDecorationStyle() == 1;
            boolean undecorated = WindowsTitlePane.this.getDecorationStyle() == 0;
            WindowsTitlePane.this.windowIconButton.setBounds(Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0);
            WindowsTitlePane.this.closeButton.setBounds(Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0);
            WindowsTitlePane.this.minimizeButton.setBounds(Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0);
            WindowsTitlePane.this.maximizeToggleButton.setBounds(Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0);
            int w = WindowsTitlePane.this.getWidth();
            int start = 0;
            int y = 0;
            WindowsTitlePane.this.height = WindowsTitlePane.this.computeHeight();
            WindowsTitlePane.this.left = 0;
            WindowsTitlePane.this.right = 0;
            Icon windowIcon = WindowsTitlePane.this.windowIconButton.getIcon();
            if (windowIcon != null) {
                int windowButtonWidth = Math.max(windowIcon.getIconHeight(), windowIcon.getIconWidth());
                windowButtonWidth = Math.min(32, windowButtonWidth);
                WindowsTitlePane.this.windowIconButton.setBounds(start + 5, y, windowButtonWidth, WindowsTitlePane.this.height);
                WindowsTitlePane.this.left = (start += windowButtonWidth + 10);
            }
            if (WindowsTitlePane.this.menuBar != null) {
                int menuWidth = ((WindowsTitlePane)WindowsTitlePane.this).getPreferredMenuSize().width;
                Insets menuInsets = WindowsTitlePane.this.menuBar.getInsets();
                WindowsTitlePane.this.menuBar.setBounds(start, y, menuWidth, WindowsTitlePane.this.height + menuInsets.bottom);
                start += menuWidth + 5;
                WindowsTitlePane.this.left += menuWidth;
            }
            int x = w;
            if (!undecorated) {
                WindowsTitlePane.this.right += 46;
                WindowsTitlePane.this.closeButton.setBounds(x -= 46, y, 46, WindowsTitlePane.this.height);
            }
            if (frame) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                    WindowsTitlePane.this.right += 46;
                    WindowsTitlePane.this.maximizeToggleButton.setBounds(x -= 46, y, 46, WindowsTitlePane.this.height);
                }
                WindowsTitlePane.this.right += 46;
                WindowsTitlePane.this.minimizeButton.setBounds(x -= 46, y, 46, WindowsTitlePane.this.height);
                x -= 5;
            }
            start = Math.max(start, 5);
            int prefLabelWidth = ((WindowsTitlePane)WindowsTitlePane.this).titleLabel.getPreferredSize().width;
            x = Math.min(WindowsTitlePane.this.getWidth() - 5, x);
            int labelWidth = x - start;
            if (prefLabelWidth > labelWidth) {
                int extra = Math.min(prefLabelWidth - labelWidth, 10);
                start -= extra / 2;
                labelWidth += extra;
            }
            WindowsTitlePane.this.titleLabel.setBounds(start, 0, labelWidth, WindowsTitlePane.this.height);
            if (!leftToRight) {
                this.mirror(WindowsTitlePane.this.windowIconButton, w);
                this.mirror(WindowsTitlePane.this.menuBar, w);
                this.mirror(WindowsTitlePane.this.closeButton, w);
                this.mirror(WindowsTitlePane.this.minimizeButton, w);
                this.mirror(WindowsTitlePane.this.maximizeToggleButton, w);
                this.mirror(WindowsTitlePane.this.titleLabel, w);
                int tmp = WindowsTitlePane.this.left;
                WindowsTitlePane.this.left = WindowsTitlePane.this.right;
                WindowsTitlePane.this.right = tmp;
            }
            WindowsTitlePane.this.updateDragArea(WindowsTitlePane.this.getGraphicsConfiguration());
        }

        private void mirror(JComponent component, int w) {
            if (component != null) {
                component.setLocation(w - component.getX() - component.getWidth(), component.getY());
            }
        }
    }
}

