/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.control.TransactionControllerSchema;
import org.apache.jmeter.control.TransactionSampler;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.SamplePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionController
extends GenericController
implements SampleListener,
Controller,
Serializable {
    static final String NUMBER_OF_SAMPLES_IN_TRANSACTION_PREFIX = "Number of samples in transaction : ";
    private static final long serialVersionUID = 234L;
    private static final String TRUE = Boolean.toString(true);
    private static final Logger log = LoggerFactory.getLogger(TransactionController.class);
    private transient TransactionSampler transactionSampler;
    private transient ListenerNotifier lnf = new ListenerNotifier();
    private transient SampleResult res;
    private transient int calls;
    private transient int noFailingSamples;
    private transient long pauseTime;
    private transient long prevEndTime;

    @Override
    public TransactionControllerSchema getSchema() {
        return TransactionControllerSchema.INSTANCE;
    }

    public PropertiesAccessor<? extends TransactionController, ? extends TransactionControllerSchema> getProps() {
        return new PropertiesAccessor<TransactionController, TransactionControllerSchema>(this, this.getSchema());
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.lnf = new ListenerNotifier();
        return this;
    }

    public void setGenerateParentSample(boolean generateParent) {
        this.set(this.getSchema().getGenearteParentSample(), generateParent);
    }

    public boolean isGenerateParentSample() {
        return this.get(this.getSchema().getGenearteParentSample());
    }

    @Override
    public Sampler next() {
        if (this.isGenerateParentSample()) {
            return this.nextWithTransactionSampler();
        }
        return this.nextWithoutTransactionSampler();
    }

    private Sampler nextWithTransactionSampler() {
        if (this.transactionSampler != null && this.transactionSampler.isTransactionDone()) {
            if (log.isDebugEnabled()) {
                log.debug("End of transaction {}", (Object)this.getName());
            }
            this.transactionSampler = null;
            return null;
        }
        if (this.isFirst()) {
            if (log.isDebugEnabled()) {
                log.debug("Start of transaction {}", (Object)this.getName());
            }
            this.transactionSampler = new TransactionSampler(this, this.getName());
        }
        Sampler subSampler = super.next();
        this.transactionSampler.setSubSampler(subSampler);
        if (subSampler == null) {
            this.transactionSampler.setTransactionDone();
        }
        return this.transactionSampler;
    }

    @Override
    protected Sampler nextIsAController(Controller controller) throws NextIsNullException {
        Sampler returnValue;
        if (!this.isGenerateParentSample()) {
            return super.nextIsAController(controller);
        }
        Sampler sampler = controller.next();
        if (sampler == null) {
            this.currentReturnedNull(controller);
            returnValue = super.next();
        } else {
            returnValue = sampler;
        }
        return returnValue;
    }

    private Sampler nextWithoutTransactionSampler() {
        if (this.isFirst()) {
            this.calls = 0;
            this.noFailingSamples = 0;
            this.res = new SampleResult();
            this.res.setSampleLabel(this.getName());
            this.res.setSuccessful(true);
            this.res.sampleStart();
            this.prevEndTime = this.res.getStartTime();
            this.pauseTime = 0L;
        }
        boolean isLast = this.current == this.subControllersAndSamplers.size();
        Sampler returnValue = super.next();
        if (returnValue == null && isLast) {
            if (this.res != null) {
                if (!this.isIncludeTimers()) {
                    long processingTimeOfLastChild = this.res.currentTimeInMillis() - this.prevEndTime;
                    this.pauseTime += processingTimeOfLastChild;
                }
                this.res.setIdleTime(this.pauseTime + this.res.getIdleTime());
                this.res.sampleEnd();
                this.res.setResponseMessage(NUMBER_OF_SAMPLES_IN_TRANSACTION_PREFIX + this.calls + ", number of failing samples : " + this.noFailingSamples);
                if (this.res.isSuccessful()) {
                    this.res.setResponseCodeOK();
                }
                this.notifyListeners();
            }
        } else {
            ++this.calls;
        }
        return returnValue;
    }

    public static boolean isFromTransactionController(SampleResult res) {
        return res.getResponseMessage() != null && res.getResponseMessage().startsWith(NUMBER_OF_SAMPLES_IN_TRANSACTION_PREFIX);
    }

    @Override
    public void triggerEndOfLoop() {
        if (!this.isGenerateParentSample()) {
            if (this.res != null) {
                this.res.setIdleTime(this.pauseTime + this.res.getIdleTime());
                this.res.sampleEnd();
                this.res.setSuccessful(TRUE.equals(JMeterContextService.getContext().getVariables().get("JMeterThread.last_sample_ok")));
                this.res.setResponseMessage(NUMBER_OF_SAMPLES_IN_TRANSACTION_PREFIX + this.calls + ", number of failing samples : " + this.noFailingSamples);
                this.notifyListeners();
            }
        } else {
            Sampler subSampler = this.transactionSampler.getSubSampler();
            if (subSampler instanceof TransactionSampler) {
                TransactionSampler tc = (TransactionSampler)subSampler;
                this.transactionSampler.addSubSamplerResult(tc.getTransactionResult());
            }
            this.transactionSampler.setTransactionDone();
            this.transactionSampler = null;
        }
        super.triggerEndOfLoop();
    }

    protected void notifyListeners() {
        JMeterContext threadContext = this.getThreadContext();
        JMeterVariables threadVars = threadContext.getVariables();
        SamplePackage pack = (SamplePackage)threadVars.getObject("JMeterThread.pack");
        if (pack == null) {
            log.warn("Could not fetch SamplePackage");
        } else {
            SampleEvent event = new SampleEvent(this.res, threadContext.getThreadGroup().getName(), threadVars, true);
            this.res = null;
            this.lnf.notifyListeners(event, pack.getSampleListeners());
        }
    }

    @Override
    public void sampleOccurred(SampleEvent se) {
        if (!this.isGenerateParentSample() && this.res != null && !se.isTransactionSampleEvent()) {
            SampleResult sampleResult = se.getResult();
            this.res.setThreadName(sampleResult.getThreadName());
            this.res.setBytes(this.res.getBytesAsLong() + sampleResult.getBytesAsLong());
            this.res.setSentBytes(this.res.getSentBytes() + sampleResult.getSentBytes());
            if (!this.isIncludeTimers()) {
                this.pauseTime += sampleResult.getEndTime() - sampleResult.getTime() - this.prevEndTime;
                this.prevEndTime = sampleResult.getEndTime();
            }
            if (!sampleResult.isSuccessful()) {
                this.res.setSuccessful(false);
                ++this.noFailingSamples;
            }
            this.res.setAllThreads(sampleResult.getAllThreads());
            this.res.setGroupThreads(sampleResult.getGroupThreads());
            this.res.setLatency(this.res.getLatency() + sampleResult.getLatency());
            this.res.setConnectTime(this.res.getConnectTime() + sampleResult.getConnectTime());
        }
    }

    @Override
    public void sampleStarted(SampleEvent e) {
    }

    @Override
    public void sampleStopped(SampleEvent e) {
    }

    public void setIncludeTimers(boolean includeTimers) {
        this.set(this.getSchema().getIncludeTimers(), includeTimers);
    }

    public boolean isIncludeTimers() {
        return this.get(this.getSchema().getIncludeTimers());
    }
}

