/*
 * Decompiled with CFR 0.152.
 */
package jodd.bridge;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;

public class ClassPathURLs {
    public static URL[] of(ClassLoader classLoader, Class clazz) {
        if (clazz == null) {
            clazz = ClassPathURLs.class;
        }
        if (classLoader == null) {
            classLoader = clazz.getClassLoader();
        }
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                return urlClassLoader.getURLs();
            }
            URL url = ClassPathURLs.classModuleUrl(classLoader, clazz);
            if (url != null) {
                urls.add(url);
            }
            classLoader = classLoader.getParent();
        }
        return urls.toArray(new URL[0]);
    }

    private static URL classModuleUrl(ClassLoader classLoader, Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName().replace('.', '/') + ".class";
        URL url = classLoader.getResource(name);
        if (url == null) {
            return null;
        }
        String urlString = url.toString();
        int ndx = urlString.indexOf(name);
        urlString = urlString.substring(0, ndx) + urlString.substring(ndx + name.length());
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }
}

