/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.sampler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.tcp.sampler.AbstractTCPClient;
import org.apache.jmeter.protocol.tcp.sampler.ReadException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPClientImpl
extends AbstractTCPClient {
    private static final Logger log = LoggerFactory.getLogger(TCPClientImpl.class);
    private static final int EOL_INT = JMeterUtils.getPropDefault((String)"tcp.eolByte", (int)1000);
    private static final String CHARSET = JMeterUtils.getPropDefault((String)"tcp.charset", (String)Charset.defaultCharset().name());

    public TCPClientImpl() {
        this.setEolByte(EOL_INT);
        if (this.useEolByte) {
            log.info("Using eolByte={}", (Object)this.eolByte);
        }
        this.setCharset(CHARSET);
        String configuredCharset = JMeterUtils.getProperty((String)"tcp.charset");
        if (StringUtils.isEmpty((CharSequence)configuredCharset)) {
            log.info("Using platform default charset:{}", (Object)CHARSET);
        } else {
            log.info("Using charset:{}", (Object)configuredCharset);
        }
    }

    @Override
    public void write(OutputStream os, String s) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("WriteS: {}", (Object)TCPClientImpl.showEOL(s));
        }
        os.write(s.getBytes(CHARSET));
        os.flush();
    }

    @Override
    public void write(OutputStream os, InputStream is) throws IOException {
        byte[] buff = new byte[512];
        while (is.read(buff) > 0) {
            if (log.isDebugEnabled()) {
                log.debug("WriteIS: {}", (Object)TCPClientImpl.showEOL(new String(buff, CHARSET)));
            }
            os.write(buff);
            os.flush();
        }
    }

    @Override
    @Deprecated
    public String read(InputStream is) throws ReadException {
        return this.read(is, new SampleResult());
    }

    @Override
    public String read(InputStream is, SampleResult sampleResult) throws ReadException {
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        try {
            int x;
            byte[] buffer = new byte[4096];
            boolean first = true;
            while ((x = is.read(buffer)) > -1) {
                if (first) {
                    sampleResult.latencyEnd();
                    first = false;
                }
                w.write(buffer, 0, x);
                if (!this.useEolByte || buffer[x - 1] != this.eolByte) continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Read: {}\n{}", (Object)w.size(), (Object)w.toString(CHARSET));
            }
            return w.toString(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new ReadException("Error decoding bytes from server with " + CHARSET + ", bytes read: " + w.size(), e, "<Read bytes with bad encoding>");
        }
        catch (IOException e) {
            String decodedBytes;
            try {
                decodedBytes = w.toString(CHARSET);
            }
            catch (UnsupportedEncodingException uee) {
                decodedBytes = "<Read bytes with bad encoding>";
            }
            throw new ReadException("Error reading from server, bytes read: " + w.size(), e, decodedBytes);
        }
    }

    private static String showEOL(String input) {
        StringBuilder sb = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch < ' ') {
                sb.append('[');
                sb.append((int)ch);
                sb.append(']');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

