/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapWrapper;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb1.store.DatasetPrefixesTDB;
import org.apache.jena.tdb1.store.GraphTxnTDB;
import org.apache.jena.tdb1.sys.TDBInternal;
import org.apache.jena.tdb1.transaction.DatasetGraphTransaction;

public class GraphTxnTDB_Prefixes
extends GraphTxnTDB {
    private final DatasetGraphTransaction dsgx;
    private final Node graphName;

    public GraphTxnTDB_Prefixes(DatasetGraphTransaction dataset) {
        this(dataset, null);
    }

    public GraphTxnTDB_Prefixes(DatasetGraphTransaction dataset, Node graphName) {
        super(dataset, graphName);
        this.dsgx = dataset;
        this.graphName = graphName;
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        PrefixMapSwitchableTDB1 pmap = new PrefixMapSwitchableTDB1(this.dsgx, this.graphName);
        return Prefixes.adapt(pmap);
    }

    public static class PrefixMapSwitchableTDB1
    extends PrefixMapWrapper {
        private final DatasetGraphTransaction dsgx;
        private final Node graphName;
        private final boolean isDefault;

        public PrefixMapSwitchableTDB1(DatasetGraphTransaction dsgx, Node graphName) {
            super(null);
            this.dsgx = dsgx;
            this.graphName = graphName;
            this.isDefault = graphName == null ? true : Quad.isDefaultGraph(graphName);
        }

        private PrefixMap getPrefixMap() {
            DatasetPrefixesTDB pm = TDBInternal.getDatasetGraphTDB(this.dsgx).getStoragePrefixes();
            if (this.isDefault) {
                return pm.getPrefixMap(Quad.defaultGraphNodeGenerated.getURI());
            }
            return pm.getPrefixMap(this.graphName.getURI());
        }

        @Override
        protected PrefixMap getR() {
            return this.getPrefixMap();
        }

        @Override
        protected PrefixMap getW() {
            this.dsgx.requireWrite();
            return this.getPrefixMap();
        }
    }
}

