/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.writers;

import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.SSEWriteLib;
import org.apache.jena.sparql.sse.writers.WriterNode;
import org.apache.jena.util.iterator.ExtendedIterator;

public class WriterGraph {
    public static final int NL = 1;
    public static final int NoNL = -1;
    public static final int NoSP = -2;

    public static void output(IndentedWriter out, Graph graph, SerializationContext naming) {
        WriterGraph.writeGraph(out, graph, null, naming);
    }

    public static void output(IndentedWriter out, DatasetGraph dataset, SerializationContext naming) {
        WriterGraph.writeDataset(out, dataset, naming);
    }

    public static void output(IndentedWriter out, BasicPattern pattern, SerializationContext sCxt) {
        for (Triple triple : pattern) {
            WriterNode.output(out, triple, sCxt);
            out.println();
        }
    }

    private static void writeDataset(IndentedWriter out, DatasetGraph ds, SerializationContext naming) {
        SSEWriteLib.start(out, "dataset", 1);
        WriterGraph.writeGraph(out, ds.getDefaultGraph(), null, naming);
        out.ensureStartOfLine();
        Iterator<Node> iter = ds.listGraphNodes();
        while (iter.hasNext()) {
            Node node = iter.next();
            out.ensureStartOfLine();
            Graph g = ds.getGraph(node);
            WriterGraph.writeGraph(out, g, node, naming);
        }
        SSEWriteLib.finish(out, "dataset");
        out.ensureStartOfLine();
    }

    private static void writeGraph(IndentedWriter out, Graph g, Node node, SerializationContext naming) {
        ExtendedIterator<Triple> iter;
        SSEWriteLib.start(out, "graph", -2);
        if (node != null) {
            out.print(" ");
            WriterNode.output(out, node, naming);
        }
        if (!(iter = g.find(Node.ANY, Node.ANY, Node.ANY)).hasNext()) {
            SSEWriteLib.finish(out, "graph");
            return;
        }
        boolean first = true;
        while (iter.hasNext()) {
            out.println();
            first = false;
            Triple triple = (Triple)iter.next();
            WriterNode.output(out, triple, naming);
        }
        if (!first) {
            out.println();
        }
        SSEWriteLib.finish(out, "graph");
    }
}

