/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.function.BiConsumer;
import org.apache.jena.rfc3986.Chars3986;
import org.apache.jena.rfc3986.IRI;
import org.apache.jena.rfc3986.IRIParseException;
import org.apache.jena.rfc3986.Issue;
import org.apache.jena.rfc3986.LibParseIRI;
import org.apache.jena.rfc3986.ParseURNComponents;
import org.apache.jena.rfc3986.URN;
import org.apache.jena.rfc3986.URNComponents;

public class ParseURN {
    private static BiConsumer<Issue, String> noOpHandler = (x, y) -> {};

    public static URN parseURN(String string) {
        return ParseURN.parseURN(string, noOpHandler);
    }

    public static URN parseURN(String string, BiConsumer<Issue, String> handler) {
        int N = string.length();
        int startNamespace = ParseURN.findValidURNScheme(string, handler);
        if (startNamespace == -1) {
            return null;
        }
        int finishNamespace = ParseURN.findValidNamespace(string, startNamespace, handler);
        if (finishNamespace == -1) {
            return null;
        }
        String scheme = string.substring(0, 3);
        int startNSS = finishNamespace + 1;
        int finishNSS = ParseURN.findValidNamespaceSpecificString(string, startNSS, handler);
        if (finishNSS == -1) {
            return null;
        }
        URNComponents components = null;
        if (finishNSS < N && (components = ParseURNComponents.parseURNComponents(string, finishNSS, handler)) == null) {
            return null;
        }
        String namespace2 = string.substring(startNamespace, finishNamespace);
        String nsSpecific = string.substring(startNSS, finishNSS);
        return new URN(scheme, namespace2, nsSpecific, components);
    }

    public static URNComponents parseURNComponents(IRI iri2) {
        return ParseURNComponents.parseURNComponents(iri2);
    }

    public static void validateURN(String string, BiConsumer<Issue, String> handler) {
        int endNSS = ParseURN.validateAssignedName(string, handler);
        if (endNSS == -1) {
            int idx = string.indexOf(63);
            if (idx == -1) {
                idx = string.indexOf(35);
            }
            if (idx == -1) {
                return;
            }
            endNSS = idx;
        }
        if (endNSS == string.length()) {
            return;
        }
        ParseURNComponents.validateURNComponents(string, endNSS, handler);
    }

    public static int validateAssignedName(String string, BiConsumer<Issue, String> handler) {
        int N = string.length();
        int startNID = ParseURN.findValidURNScheme(string, handler);
        if (startNID == -1) {
            return -1;
        }
        int finishNID = ParseURN.findValidNamespace(string, startNID, handler);
        if (finishNID == -1) {
            return -1;
        }
        int startNSS = finishNID + 1;
        int finishNSS = ParseURN.findValidNamespaceSpecificString(string, startNSS, handler);
        if (finishNSS == -1) {
            return -1;
        }
        return finishNSS;
    }

    private static int findValidURNScheme(String string, BiConsumer<Issue, String> handler) {
        String urnSchemeStr = "urn:";
        boolean urnScheme = LibParseIRI.caseInsensitivePrefix(string, "urn:");
        if (!urnScheme) {
            handler.accept(Issue.urn_bad_pattern, "Failed find the URN scheme name");
            return -1;
        }
        return "urn:".length();
    }

    private static int findValidNamespace(String string, int startNamespace, BiConsumer<Issue, String> handler) {
        int N = string.length();
        int x = startNamespace;
        char ch = Chars3986.charAt(string, x);
        if (ch == '\uffff') {
            handler.accept(Issue.urn_bad_nid, "No namespace id");
            return -1;
        }
        if (ch == ':') {
            handler.accept(Issue.urn_bad_nid, "Missing namespace id");
            return -1;
        }
        if (!Chars3986.isAlphaNum(ch)) {
            handler.accept(Issue.urn_bad_nid, "Namespace id does not start with an alphabetic ASCII character");
            return -1;
        }
        ++x;
        int prevChar = 65535;
        while (x < N) {
            prevChar = ch;
            ch = Chars3986.charAt(string, x);
            if (ch == ':') {
                if (prevChar != 45) break;
                handler.accept(Issue.urn_bad_nid, "Namespace id ends in '-'");
                return -1;
            }
            if (!ParseURN.isLDH(ch)) {
                handler.accept(Issue.urn_bad_nid, "Bad character in Namespace id");
                return -1;
            }
            if (++x - startNamespace <= 32) continue;
            handler.accept(Issue.urn_bad_nid, "Namespace id more than 32 characters");
            return -1;
        }
        int finishNamespace = x++;
        if (ch != ':') {
            handler.accept(Issue.urn_bad_nid, "Namespace not terminated by ':'");
            return -1;
        }
        if (finishNamespace - startNamespace < 2) {
            handler.accept(Issue.urn_bad_nid, "Namespace id must be at least 2 characters");
            return -1;
        }
        if (LibParseIRI.caseInsensitiveRegion(string, startNamespace, "X-")) {
            String start = string.substring(startNamespace, 2 + startNamespace);
            handler.accept(Issue.urn_x_namespace, "Namespace id starts with '" + start + "'");
            return -1;
        }
        if (LibParseIRI.caseInsensitiveRegion(string, startNamespace, "urn-")) {
            boolean seenNonZero = false;
            for (int i = startNamespace + "urn-".length(); i < finishNamespace; ++i) {
                char chx = Chars3986.charAt(string, i);
                if (!seenNonZero) {
                    if (chx == '0') {
                        handler.accept(Issue.urn_bad_nid, "Leading zero in an informal namespace");
                        return -1;
                    }
                    seenNonZero = true;
                }
                if (Chars3986.isDigit(chx)) continue;
                handler.accept(Issue.urn_bad_nid, "Bad informal namepsace");
                return -1;
            }
        }
        return finishNamespace;
    }

    private static int findValidNamespaceSpecificString(String string, int startNSS, BiConsumer<Issue, String> handler) {
        int N;
        int finishNSS = N = string.length();
        for (int idx = startNSS; idx < N; ++idx) {
            char ch = string.charAt(idx);
            if (ch != '?' && ch != '#') continue;
            finishNSS = idx;
            break;
        }
        if (finishNSS - startNSS < 1) {
            handler.accept(Issue.urn_bad_nss, "Namespace specific string must be at least one character");
            return -1;
        }
        return finishNSS;
    }

    private static boolean isLDH(char ch) {
        return Chars3986.isAlphaNum(ch) || ch == '-';
    }

    public static class URNParseException
    extends IRIParseException {
        URNParseException(String entity, String msg) {
            super((CharSequence)entity, msg);
        }
    }
}

