/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.Duration;
import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DurationDV;

class DayTimeDurationDV
extends DurationDV {
    DayTimeDurationDV() {
    }

    @Override
    public Object getActualValue(String content) throws InvalidDatatypeValueException {
        try {
            return this.parse(content, 2);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "dayTimeDuration"});
        }
    }

    @Override
    protected Duration getDuration(AbstractDateTimeDV.DateTimeData date2) {
        int sign = 1;
        if (date2.day < 0 || date2.hour < 0 || date2.minute < 0 || date2.second < 0.0) {
            sign = -1;
        }
        return datatypeFactory.newDuration(sign == 1, null, null, date2.day != Integer.MIN_VALUE ? BigInteger.valueOf(sign * date2.day) : null, date2.hour != Integer.MIN_VALUE ? BigInteger.valueOf(sign * date2.hour) : null, date2.minute != Integer.MIN_VALUE ? BigInteger.valueOf(sign * date2.minute) : null, date2.second != -2.147483648E9 ? new BigDecimal(String.valueOf((double)sign * date2.second)) : null);
    }
}

