/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.recordbuffer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.Alg;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.dboe.base.block.BlockException;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordMapper;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPage;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPageMgr;

public final class RecordRangeIterator<X>
implements Iterator<X>,
Closeable {
    private final RecordMapper<X> mapper;
    private RecordBufferPage currentPage;
    private int currentIdx = 0;
    private final RecordBufferPageMgr pageMgr;
    private final Record maxRec;
    private final Record minRec;
    private X slot = null;
    private final byte[] keySlot;
    private long countRecords = 0L;
    private long countBlocks = 0L;

    public static <X> Iterator<X> iterator(int pageId, Record fromRec, Record toRec, RecordBufferPageMgr pageMgr, RecordMapper<X> mapper) {
        if (!pageMgr.valid(pageId)) {
            String msg = "RecordRangeIterator.iterator -- No such block (pageId=" + pageId + ", fromRec=" + String.valueOf(fromRec) + ", toRec=" + String.valueOf(toRec) + ")";
            throw new BlockException(msg);
        }
        return new RecordRangeIterator<X>(pageId, fromRec, toRec, pageMgr, mapper);
    }

    private RecordRangeIterator(int id, Record fromRec, Record toRec, RecordBufferPageMgr pageMgr, RecordMapper<X> mapper) {
        this.pageMgr = pageMgr;
        this.minRec = fromRec;
        this.maxRec = toRec;
        this.mapper = mapper;
        this.keySlot = new byte[pageMgr.getRecordFactory().keyLength()];
        if (toRec != null && fromRec != null && Record.keyLE(toRec, fromRec)) {
            this.currentPage = null;
            return;
        }
        pageMgr.startRead();
        this.currentPage = (RecordBufferPage)pageMgr.getRead(id);
        if (this.currentPage.getCount() == 0) {
            this.close();
            return;
        }
        if (fromRec != null) {
            this.currentIdx = this.currentPage.getRecordBuffer().find(fromRec);
            if (this.currentIdx < 0) {
                this.currentIdx = Alg.decodeIndex(this.currentIdx);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.slot != null) {
            return true;
        }
        if (this.currentPage == null) {
            return false;
        }
        while (this.currentIdx >= this.currentPage.getCount()) {
            RecordBufferPage nextPage;
            int link = this.currentPage.getLink();
            if (link < 0) {
                this.close();
                return false;
            }
            if (this.currentPage != null) {
                this.pageMgr.release(this.currentPage);
            }
            this.currentPage = nextPage = (RecordBufferPage)this.pageMgr.getRead(link);
            ++this.countBlocks;
            this.currentIdx = 0;
        }
        this.slot = this.currentPage.getRecordBuffer().access(this.currentIdx, this.keySlot, this.mapper);
        ++this.currentIdx;
        if (this.maxRec != null && Bytes.compare(this.keySlot, this.maxRec.getKey()) >= 0) {
            this.close();
            return false;
        }
        if (this.slot == null) {
            this.close();
            return false;
        }
        ++this.countRecords;
        return true;
    }

    @Override
    public void close() {
        if (this.currentPage == null) {
            return;
        }
        this.pageMgr.release(this.currentPage);
        this.pageMgr.finishRead();
        this.currentPage = null;
        this.currentIdx = -99;
        this.slot = null;
    }

    @Override
    public X next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        X x = this.slot;
        this.slot = null;
        return x;
    }

    public final long getCountRecords() {
        return this.countRecords;
    }

    public final long getCountBlocks() {
        return this.countBlocks;
    }
}

