/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownService {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownService.class);
    protected final AutoLock lock = new AutoLock();
    private final String host;
    private final int port;
    private final String key;
    private final boolean exitVm;
    protected final List<LifeCycle> components = new ArrayList<LifeCycle>();
    private ServerSocket serverSocket;

    public ShutdownService(@Name(value="host") String host, @Name(value="port") int port, @Name(value="key") String key, @Name(value="exitVm") boolean exitVm) {
        if (StringUtil.isBlank(host)) {
            throw new IllegalArgumentException("Host is unset");
        }
        this.host = host;
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid Port: " + port);
        }
        this.port = port;
        this.key = StringUtil.isNotBlank(key) ? key : this.generateKey();
        this.exitVm = exitVm;
    }

    private String generateKey() {
        return Long.toString((long)(9.223372036854776E18 * Math.random() + (double)this.hashCode() + (double)System.currentTimeMillis()), 36);
    }

    public void addComponent(LifeCycle component) {
        try (AutoLock l = this.lock.lock();){
            this.components.add(component);
        }
    }

    public boolean removeComponent(LifeCycle component) {
        boolean ret = false;
        try (AutoLock l = this.lock.lock();){
            ret = this.components.remove(component);
        }
        return ret;
    }

    public boolean hasComponent(LifeCycle component) {
        boolean ret;
        try (AutoLock l = this.lock.lock();){
            ret = this.components.contains(component);
        }
        return ret;
    }

    public void start() throws Exception {
        try (AutoLock l = this.lock.lock();){
            if (this.serverSocket != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Already started: {}", (Object)this);
                }
                return;
            }
            this.listen();
            if (this.serverSocket != null) {
                Thread thread = new Thread(new ShutdownRunnable(this.serverSocket));
                thread.setDaemon(true);
                thread.setName(TypeUtil.toShortName(this.getClass()));
                thread.start();
            }
        }
    }

    public void stop() {
        IO.close(this.serverSocket);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closed ServerSocket");
        }
        this.serverSocket = null;
    }

    public boolean isExitVm() {
        return this.exitVm;
    }

    public String getHost() {
        return this.host;
    }

    public String getKey() {
        return this.key;
    }

    public int getPort() {
        return this.port;
    }

    public int getLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return -1;
    }

    public boolean isListening() {
        try (AutoLock l = this.lock.lock();){
            if (this.serverSocket == null) {
                boolean bl = false;
                return bl;
            }
            System.out.printf("%s [isBound=%b, isClosed=%b]%n", this, this.serverSocket.isBound(), this.serverSocket.isClosed());
            boolean bl = this.serverSocket.isBound() && !this.serverSocket.isClosed();
            return bl;
        }
    }

    protected void configure(ServerSocket serverSocket) throws SocketException {
        serverSocket.setReuseAddress(true);
    }

    protected void bound(ServerSocket serverSocket) {
    }

    private void listen() {
        try {
            this.serverSocket = new ServerSocket();
            this.configure(this.serverSocket);
            this.serverSocket.bind(new InetSocketAddress(InetAddress.getByName(this.getHost()), this.getPort()));
            System.out.printf("STOP.PORT=%d%n", this.getLocalPort());
            System.out.printf("STOP.KEY=%s%n", this.getKey());
            System.out.printf("STOP.EXIT=%s%n", this.isExitVm());
        }
        catch (Throwable x) {
            IO.close(this.serverSocket);
            LOG.warn("Failed to start ServerSocket on {}:{}", this.getHost(), this.getPort(), x);
            this.serverSocket = null;
        }
    }

    public String toString() {
        return String.format("%s@%H{host=%s,port=%s,key=%s,exitVm=%b,serverSocket=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getHost(), this.getLocalPort(), this.getKey(), this.isExitVm(), this.serverSocket);
    }

    private class ShutdownRunnable
    implements Runnable {
        private final ServerSocket serverSocket;

        private ShutdownRunnable(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (ShutdownService.LOG.isDebugEnabled()) {
                ShutdownService.LOG.debug("Started: {}", (Object)ShutdownService.this);
            }
            try {
                processCommands = true;
                key = ShutdownService.this.getKey();
lbl6:
                // 16 sources

                block29: while (processCommands) {
                    try {
                        socket = this.serverSocket.accept();
                        try {
                            reader = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                            receivedKey = reader.readLine();
                            if (!key.equals(receivedKey)) {
                                if (!ShutdownService.LOG.isDebugEnabled()) continue;
                                ShutdownService.LOG.debug("Ignoring command with incorrect key: {}", (Object)receivedKey);
                                continue;
                            }
                            cmd = reader.readLine();
                            if (ShutdownService.LOG.isDebugEnabled()) {
                                ShutdownService.LOG.debug("command={}", (Object)cmd);
                            }
                            out = socket.getOutputStream();
                            exitVm = ShutdownService.this.isExitVm();
                            var10_14 = cmdLower = cmd.toLowerCase(Locale.ENGLISH);
                            var11_15 = -1;
                            switch (var10_14.hashCode()) {
                                case 3540994: {
                                    if (!var10_14.equals("stop")) break;
                                    var11_15 = 0;
                                    break;
                                }
                                case 1528964461: {
                                    if (!var10_14.equals("forcestop")) break;
                                    var11_15 = 1;
                                    break;
                                }
                                case 1715335200: {
                                    if (!var10_14.equals("stopexit")) break;
                                    var11_15 = 2;
                                    break;
                                }
                                case 3127582: {
                                    if (!var10_14.equals("exit")) break;
                                    var11_15 = 3;
                                    break;
                                }
                                case -892481550: {
                                    if (!var10_14.equals("status")) break;
                                    var11_15 = 4;
                                    break;
                                }
                                case 110987: {
                                    if (!var10_14.equals("pid")) break;
                                    var11_15 = 5;
                                }
                            }
                            switch (var11_15) {
                                case 0: {
                                    ShutdownService.LOG.info("Performing 'stop' command");
                                    this.stopComponents(exitVm);
                                    if (ShutdownService.LOG.isDebugEnabled()) {
                                        ShutdownService.LOG.debug("Informing client that we are stopped");
                                    }
                                    this.flush(out, "Stopped\r\n");
                                    processCommands = false;
                                    if (!exitVm) ** break;
                                    ShutdownService.LOG.info("Exiting JVM");
                                    System.exit(0);
                                    ** break;
                                }
                                case 1: {
                                    ShutdownService.LOG.info("Performing `forced stop` command");
                                    this.stopComponents(exitVm);
                                    ShutdownService.LOG.debug("Informing client that we are stopped");
                                    this.flush(out, "Stopped\r\n");
                                    processCommands = false;
                                    if (!exitVm) ** break;
                                    ShutdownService.LOG.info("Exiting JVM");
                                    System.exit(0);
                                    ** break;
                                }
                                case 2: {
                                    ShutdownService.LOG.info("Performing `stop` and `exit` commands");
                                    this.stopComponents(true);
                                    ShutdownService.LOG.debug("Informing client that we are stopped");
                                    this.flush(out, "Stopped\r\n");
                                    processCommands = false;
                                    ShutdownService.LOG.info("Killing JVM");
                                    System.exit(0);
                                    ** break;
                                }
                                case 3: {
                                    processCommands = false;
                                    ShutdownService.LOG.info("Killing JVM");
                                    System.exit(0);
                                    ** break;
                                }
                                case 4: {
                                    this.flush(out, "OK\r\n");
                                    ** break;
                                }
                                case 5: {
                                    this.flush(out, Long.toString(ProcessHandle.current().pid()));
                                    continue block29;
                                }
                                ** default:
lbl90:
                                // 1 sources

                                continue block29;
                            }
                        }
                        finally {
                            if (socket == null) continue;
                            socket.close();
                        }
                    }
                    catch (Throwable x) {
                        if (!ShutdownService.LOG.isDebugEnabled()) continue;
                        ShutdownService.LOG.debug("Failed to handle incoming shutdown client", x);
                    }
                }
            }
            catch (Throwable x) {
                ShutdownService.LOG.debug("Failed ServerSocket", x);
            }
            finally {
                ShutdownService.this.stop();
            }
        }

        private void flush(OutputStream out, String message) throws IOException {
            out.write(message.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }

        private void stopComponents(boolean destroy) {
            ArrayList<LifeCycle> components;
            try (AutoLock l = ShutdownService.this.lock.lock();){
                components = new ArrayList<LifeCycle>(ShutdownService.this.components);
            }
            for (LifeCycle component : components) {
                try {
                    if (component.isStarted()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Calling stop() on {}", (Object)component);
                        }
                        component.stop();
                    }
                    if (!(component instanceof Destroyable) || !destroy) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Calling destroy() on {}", (Object)component);
                    }
                    ((Destroyable)((Object)component)).destroy();
                }
                catch (Throwable x) {
                    LOG.debug("Unable to stop component: {}", (Object)component, (Object)x);
                }
            }
        }
    }
}

