/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.util.StringUtil;

abstract class HttpFieldsMap
extends AbstractMap<String, List<String>> {
    HttpFieldsMap() {
    }

    private class HttpFieldsEntry
    implements Map.Entry<String, List<String>> {
        private final String _name;

        public HttpFieldsEntry(String name) {
            this._name = name;
        }

        @Override
        public String getKey() {
            return this._name;
        }

        @Override
        public List<String> getValue() {
            return (List)HttpFieldsMap.this.get(this._name);
        }

        @Override
        public List<String> setValue(List<String> value) {
            return HttpFieldsMap.this.put(this._name, value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof HttpFieldsEntry) {
                HttpFieldsEntry other = (HttpFieldsEntry)o;
                return StringUtil.asciiEqualsIgnoreCase(this._name, other.getKey());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(StringUtil.asciiToLowerCase(this._name));
        }
    }

    public static class Immutable
    extends HttpFieldsMap {
        private final HttpFields httpFields;

        public Immutable(HttpFields httpFields) {
            this.httpFields = httpFields;
        }

        @Override
        public List<String> get(Object key) {
            if (key instanceof String) {
                String s = (String)key;
                return Collections.unmodifiableList(this.httpFields.getValuesList(s));
            }
            return null;
        }

        @Override
        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                String s = (String)key;
                return this.httpFields.contains(s);
            }
            return false;
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return new AbstractSet<Map.Entry<String, List<String>>>(){

                @Override
                public Iterator<Map.Entry<String, List<String>>> iterator() {
                    return new Iterator<Map.Entry<String, List<String>>>(){
                        private final Iterator<String> iterator;
                        {
                            this.iterator = httpFields.getFieldNamesCollection().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iterator.hasNext();
                        }

                        @Override
                        public Map.Entry<String, List<String>> next() {
                            return new HttpFieldsEntry(this.iterator.next());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return httpFields.getFieldNamesCollection().size();
                }
            };
        }
    }

    public static class Mutable
    extends HttpFieldsMap {
        private final HttpFields.Mutable httpFields;

        public Mutable(HttpFields.Mutable httpFields) {
            this.httpFields = httpFields;
        }

        @Override
        public List<String> get(Object key) {
            if (key instanceof String) {
                final String s = (String)key;
                return new AbstractList<String>(this){
                    private final List<String> values;
                    final /* synthetic */ Mutable this$0;
                    {
                        this.this$0 = this$0;
                        this.values = this.this$0.httpFields.getValuesList(s);
                    }

                    @Override
                    public String get(int index) {
                        return this.values.get(index);
                    }

                    @Override
                    public int size() {
                        return this.values.size();
                    }

                    @Override
                    public boolean add(String value) {
                        this.values.add(value);
                        this.this$0.httpFields.add(s, value);
                        return true;
                    }
                };
            }
            return null;
        }

        @Override
        public List<String> put(String key, List<String> value) {
            Object oldValue = this.get(key);
            this.httpFields.put(key, value);
            return oldValue;
        }

        @Override
        public List<String> remove(Object key) {
            if (key instanceof String) {
                String s = (String)key;
                Object oldValue = this.get(s);
                this.httpFields.remove(s);
                return Collections.unmodifiableList(oldValue);
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                String s = (String)key;
                return this.httpFields.contains(s);
            }
            return false;
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return new AbstractSet<Map.Entry<String, List<String>>>(){

                @Override
                public Iterator<Map.Entry<String, List<String>>> iterator() {
                    return new Iterator<Map.Entry<String, List<String>>>(){
                        private final Iterator<String> iterator;
                        private String name;
                        {
                            this.iterator = httpFields.getFieldNamesCollection().iterator();
                            this.name = null;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iterator.hasNext();
                        }

                        @Override
                        public Map.Entry<String, List<String>> next() {
                            this.name = this.iterator.next();
                            return new HttpFieldsEntry(this.name);
                        }

                        @Override
                        public void remove() {
                            if (this.name != null) {
                                this.remove(this.name);
                                this.name = null;
                            }
                        }
                    };
                }

                @Override
                public int size() {
                    return httpFields.getFieldNamesCollection().size();
                }
            };
        }
    }
}

