/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.EllipsoidalHeightSeparator;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.referencing.util.DefinitionVerifier;
import org.apache.sis.referencing.util.EllipsoidalHeightCombiner;
import org.apache.sis.referencing.util.PositionalAccuracyConstant;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class CRS
extends Static {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing");

    private CRS() {
    }

    public static CoordinateReferenceSystem forCode(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        try {
            return AuthorityFactories.ALL.createCoordinateReferenceSystem(code);
        }
        catch (UnavailableFactoryException e2) {
            return AuthorityFactories.fallback(e2).createCoordinateReferenceSystem(code);
        }
    }

    public static CoordinateReferenceSystem fromWKT(String text) throws FactoryException {
        ArgumentChecks.ensureNonNull("text", text);
        CoordinateReferenceSystem crs = GeodeticObjectFactory.provider().createFromWKT(text);
        DefinitionVerifier.withAuthority(crs, "org.apache.sis.io.wkt", CRS.class, "fromWKT");
        return crs;
    }

    public static CoordinateReferenceSystem fromXML(String xml) throws FactoryException {
        ArgumentChecks.ensureNonNull("text", xml);
        CoordinateReferenceSystem crs = GeodeticObjectFactory.provider().createFromXML(xml);
        DefinitionVerifier.withAuthority(crs, "org.apache.sis.xml", CRS.class, "fromXML");
        return crs;
    }

    public static CoordinateReferenceSystem fromAuthority(CoordinateReferenceSystem crs, CRSAuthorityFactory factory, Filter warningFilter) throws FactoryException {
        DefinitionVerifier verification;
        if (crs != null && (verification = DefinitionVerifier.withAuthority(crs, factory, true, null)) != null) {
            LogRecord record;
            crs = verification.recommendation;
            if (warningFilter != null && (record = verification.warning(false)) != null) {
                record.setLoggerName("org.apache.sis.referencing");
                record.setSourceClassName(CRS.class.getName());
                record.setSourceMethodName("fromAuthority");
                if (warningFilter.isLoggable(record)) {
                    LOGGER.log(record);
                }
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem suggestCommonTarget(GeographicBoundingBox regionOfInterest, CoordinateReferenceSystem ... sourceCRS) {
        CoordinateReferenceSystem bestCRS = null;
        boolean worldwide = false;
        DefaultGeographicBoundingBox domain = null;
        GeographicBoundingBox[] domains = new GeographicBoundingBox[sourceCRS.length];
        for (int i = 0; i < sourceCRS.length; ++i) {
            CoordinateReferenceSystem crs = sourceCRS[i];
            GeographicBoundingBox bbox = CRS.getGeographicBoundingBox(crs);
            if (bbox != null) {
                domains[i] = bbox;
                if (worldwide) continue;
                if (domain == null) {
                    domain = new DefaultGeographicBoundingBox(bbox);
                    continue;
                }
                domain.add(bbox);
                continue;
            }
            if (!(crs instanceof GeodeticCRS)) continue;
            bestCRS = crs;
            worldwide = true;
        }
        if (domain != null && !worldwide) {
            if (regionOfInterest != null) {
                domain.intersect(regionOfInterest);
            }
            regionOfInterest = domain;
            domain = null;
        }
        double roiArea = Extents.area(regionOfInterest);
        double maxInsideArea = 0.0;
        double minOutsideArea = Double.POSITIVE_INFINITY;
        boolean tryDerivedCRS = false;
        do {
            for (int i = 0; i < domains.length; ++i) {
                GeographicBoundingBox bbox = domains[i];
                if (bbox == null) continue;
                double insideArea = Extents.area(bbox);
                double outsideArea = 0.0;
                if (regionOfInterest != null) {
                    if (domain == null) {
                        domain = new DefaultGeographicBoundingBox(bbox);
                    } else {
                        domain.setBounds(bbox);
                    }
                    domain.intersect(regionOfInterest);
                    double area = insideArea;
                    insideArea = Extents.area(domain);
                    outsideArea = area - insideArea;
                }
                if (!(insideArea > maxInsideArea) && (insideArea != maxInsideArea || !(outsideArea < minOutsideArea))) continue;
                maxInsideArea = insideArea;
                minOutsideArea = outsideArea;
                bestCRS = sourceCRS[i];
            }
            if (!Double.isNaN(roiArea) && !(maxInsideArea < roiArea) || tryDerivedCRS) break;
            CoordinateReferenceSystem[] derivedCRS = new CoordinateReferenceSystem[sourceCRS.length];
            for (int i = 0; i < derivedCRS.length; ++i) {
                GeographicBoundingBox bbox = null;
                CoordinateReferenceSystem crs = sourceCRS[i];
                if (crs instanceof GeneralDerivedCRS) {
                    CoordinateReferenceSystem baseCRS = ((GeneralDerivedCRS)crs).getBaseCRS();
                    bbox = CRS.getGeographicBoundingBox(baseCRS);
                    if (bbox == null && bestCRS == null && baseCRS instanceof GeodeticCRS) {
                        bestCRS = baseCRS;
                    }
                    tryDerivedCRS = true;
                    derivedCRS[i] = baseCRS;
                }
                domains[i] = bbox;
            }
            sourceCRS = derivedCRS;
        } while (tryDerivedCRS);
        return bestCRS;
    }

    public static CoordinateOperation findOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, GeographicBoundingBox areaOfInterest) throws FactoryException {
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
        CoordinateOperationContext context2 = CoordinateOperationContext.fromBoundingBox(areaOfInterest);
        DefaultCoordinateOperationFactory factory = DefaultCoordinateOperationFactory.provider();
        try {
            return factory.createOperation(sourceCRS, targetCRS, context2);
        }
        catch (UnavailableFactoryException e2) {
            if (AuthorityFactories.failure(e2)) {
                throw e2;
            }
            try {
                return factory.createOperation(sourceCRS, targetCRS, context2);
            }
            catch (FactoryException ex) {
                ex.addSuppressed(e2);
                throw ex;
            }
        }
    }

    public static List<CoordinateOperation> findOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, GeographicBoundingBox areaOfInterest) throws FactoryException {
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
        CoordinateOperationContext context2 = CoordinateOperationContext.fromBoundingBox(areaOfInterest);
        DefaultCoordinateOperationFactory factory = DefaultCoordinateOperationFactory.provider();
        try {
            return factory.createOperations(sourceCRS, targetCRS, context2);
        }
        catch (UnavailableFactoryException e2) {
            if (AuthorityFactories.failure(e2)) {
                throw e2;
            }
            try {
                return List.of(factory.createOperation(sourceCRS, targetCRS, context2));
            }
            catch (FactoryException ex) {
                ex.addSuppressed(e2);
                throw ex;
            }
        }
    }

    public static double getLinearAccuracy(CoordinateOperation operation) {
        if (operation == null) {
            return Double.NaN;
        }
        if (operation instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)operation).getLinearAccuracy();
        }
        return PositionalAccuracyConstant.getLinearAccuracy(operation);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateOperation operation) {
        if (operation == null) {
            return null;
        }
        return CRS.getDomains(operation).orElseGet(() -> Extents.intersection(CRS.getGeographicBoundingBox(operation.getSourceCRS()), CRS.getGeographicBoundingBox(operation.getTargetCRS())));
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem crs) {
        return crs != null ? (GeographicBoundingBox)CRS.getDomains(crs).orElse(null) : null;
    }

    private static Optional<GeographicBoundingBox> getDomains(IdentifiedObject object) {
        return Extents.getGeographicBoundingBox(Legacy.getDomains(object).stream().map(DefaultObjectDomain::getDomainOfValidity));
    }

    public static Envelope getDomainOfValidity(CoordinateReferenceSystem crs) {
        SingleCRS targetCRS;
        GeographicCRS sourceCRS;
        Envelope envelope = null;
        GeneralEnvelope merged = null;
        GeographicBoundingBox bounds = CRS.getGeographicBoundingBox(crs);
        if (bounds != null && !Boolean.FALSE.equals(bounds.getInclusion()) && (sourceCRS = ReferencingUtilities.toNormalizedGeographicCRS(targetCRS = CRS.getHorizontalComponent(crs), false, false)) != null) {
            envelope = merged = new GeneralEnvelope(bounds);
            merged.translate(-CRS.getGreenwichLongitude(sourceCRS), 0.0);
            merged.setCoordinateReferenceSystem(sourceCRS);
            try {
                envelope = Envelopes.transform(envelope, targetCRS);
            }
            catch (TransformException exception) {
                CRS.unexpectedException("getEnvelope", exception);
                envelope = null;
            }
        }
        return envelope;
    }

    public static CoordinateReferenceSystem compound(CoordinateReferenceSystem ... components) throws FactoryException {
        CoordinateReferenceSystem crs;
        ArgumentChecks.ensureNonEmpty("components", components);
        if (components.length == 1 && (crs = components[0]) != null) {
            return crs;
        }
        return new EllipsoidalHeightCombiner().createCompoundCRS(components);
    }

    public static CoordinateReferenceSystem selectDimensions(CoordinateReferenceSystem crs, int ... dimensions) throws FactoryException {
        List<CoordinateReferenceSystem> components = CRS.selectComponents(crs, dimensions);
        if (components.isEmpty()) {
            return null;
        }
        return CRS.compound((CoordinateReferenceSystem[])components.toArray(CoordinateReferenceSystem[]::new));
    }

    public static List<CoordinateReferenceSystem> selectComponents(CoordinateReferenceSystem crs, int ... dimensions) throws FactoryException {
        ArgumentChecks.ensureNonNull("dimensions", dimensions);
        if (crs == null) {
            return List.of();
        }
        int dimension = ReferencingUtilities.getDimension(crs);
        long selected = 0L;
        for (int d : dimensions) {
            if (d < 0 || d >= dimension) {
                throw new IndexOutOfBoundsException(Errors.format((short)71, d));
            }
            if (d >= 64) {
                throw new ArithmeticException(Errors.format((short)37, d + 1));
            }
            selected |= 1L << d;
        }
        if (selected == 0L) {
            throw new IllegalArgumentException(Errors.format((short)29, "dimensions"));
        }
        ArrayList<CoordinateReferenceSystem> components = new ArrayList<CoordinateReferenceSystem>(Long.bitCount(selected));
        CRS.reduce(0, crs, dimension, selected, components);
        return components;
    }

    private static long reduce(int previous, CoordinateReferenceSystem crs, int dimension, long selected, List<CoordinateReferenceSystem> addTo) throws FactoryException {
        long current = Numerics.bitmask(dimension) - 1L << previous;
        long intersect = selected & current;
        if (intersect != 0L) {
            Datum datum;
            if (intersect == current) {
                addTo.add(crs);
                selected &= current ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (crs instanceof CompoundCRS) {
                CoordinateReferenceSystem component;
                Iterator<CoordinateReferenceSystem> iterator = ((CompoundCRS)crs).getComponents().iterator();
                while (iterator.hasNext() && ((selected = CRS.reduce(previous, component = iterator.next(), dimension = ReferencingUtilities.getDimension(component), selected, addTo)) & current) != 0L) {
                    previous += dimension;
                }
            } else if (dimension == 3 && crs instanceof SingleCRS && (datum = ((SingleCRS)crs).getDatum()) instanceof GeodeticDatum) {
                boolean isVertical = Long.bitCount(intersect) == 1;
                int verticalDimension = Long.numberOfTrailingZeros((isVertical ? intersect : intersect ^ 0xFFFFFFFFFFFFFFFFL) >>> previous);
                CoordinateSystemAxis verticalAxis = crs.getCoordinateSystem().getAxis(verticalDimension);
                if (AxisDirections.isVertical(verticalAxis.getDirection())) {
                    try {
                        addTo.add(new EllipsoidalHeightSeparator((GeodeticDatum)datum, isVertical).separate((SingleCRS)crs));
                        selected &= current ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    catch (ClassCastException | IllegalArgumentException e2) {
                        throw new FactoryException(Resources.format((short)84, crs.getName()));
                    }
                }
            }
        }
        if ((selected & current) != 0L) {
            throw new FactoryException(Resources.format((short)84, crs.getName()));
        }
        return selected;
    }

    public static boolean isHorizontalCRS(CoordinateReferenceSystem crs) {
        return CRS.horizontalCode(crs) == 2;
    }

    private static int horizontalCode(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        int dim;
        boolean isEngineering = false;
        boolean isGeodetic = crs instanceof GeodeticCRS;
        if ((isGeodetic || crs instanceof ProjectedCRS || (isEngineering = crs instanceof EngineeringCRS)) && ((dim = (cs = crs.getCoordinateSystem()).getDimension()) & 0xFFFFFFFE) == 2 && (!isGeodetic || cs instanceof EllipsoidalCS)) {
            if (isEngineering) {
                int n = 0;
                for (int i = 0; i < dim; ++i) {
                    if (!AxisDirections.isCompass(cs.getAxis(i).getDirection())) continue;
                    ++n;
                }
                if (n != 2) {
                    return 0;
                }
            }
            return dim;
        }
        return 0;
    }

    public static SingleCRS getHorizontalComponent(CoordinateReferenceSystem crs) {
        switch (CRS.horizontalCode(crs)) {
            case 2: {
                return (SingleCRS)crs;
            }
            case 3: {
                CoordinateSystem cs = CoordinateSystems.replaceAxes(crs.getCoordinateSystem(), new AxisFilter(){

                    @Override
                    public boolean accept(CoordinateSystemAxis axis) {
                        return !AxisDirections.isVertical(axis.getDirection());
                    }
                });
                if (cs.getDimension() != 2) break;
                Map<String, ?> properties = ReferencingUtilities.getPropertiesForModifiedCRS(crs);
                if (crs instanceof GeodeticCRS) {
                    return new DefaultGeographicCRS(properties, ((GeodeticCRS)crs).getDatum(), (EllipsoidalCS)cs);
                }
                if (crs instanceof ProjectedCRS) {
                    ProjectedCRS proj = (ProjectedCRS)crs;
                    GeographicCRS base = (GeographicCRS)CRS.getHorizontalComponent(proj.getBaseCRS());
                    Conversion fromBase = proj.getConversionFromBase();
                    fromBase = new DefaultConversion(IdentifiedObjects.getProperties(fromBase, new String[0]), fromBase.getMethod(), null, fromBase.getParameterValues());
                    return new DefaultProjectedCRS(properties, base, fromBase, (CartesianCS)cs);
                }
                return new DefaultEngineeringCRS(properties, ((EngineeringCRS)crs).getDatum(), cs);
            }
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getComponents()) {
                SingleCRS candidate = CRS.getHorizontalComponent(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalComponent(CoordinateReferenceSystem crs, boolean allowCreateEllipsoidal) {
        CoordinateSystem cs;
        int i;
        if (crs instanceof VerticalCRS) {
            return (VerticalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            boolean a = false;
            do {
                for (CoordinateReferenceSystem c : cp.getComponents()) {
                    VerticalCRS candidate = CRS.getVerticalComponent(c, a);
                    if (candidate == null) continue;
                    return candidate;
                }
            } while ((a = !a) == allowCreateEllipsoidal);
        }
        if (allowCreateEllipsoidal && CRS.horizontalCode(crs) == 3 && (i = AxisDirections.indexOfColinear(cs = crs.getCoordinateSystem(), AxisDirection.UP)) >= 0) {
            CoordinateReferenceSystem c;
            CoordinateSystemAxis axis = cs.getAxis(i);
            c = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!c.getCoordinateSystem().getAxis(0).equals(axis)) {
                Map<String, ?> properties = IdentifiedObjects.getProperties(c, new String[0]);
                c = new DefaultVerticalCRS(properties, c.getDatum(), new DefaultVerticalCS(properties, axis));
            }
            return c;
        }
        return null;
    }

    public static TemporalCRS getTemporalComponent(CoordinateReferenceSystem crs) {
        if (crs instanceof TemporalCRS) {
            return (TemporalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getComponents()) {
                TemporalCRS candidate = CRS.getTemporalComponent(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static List<SingleCRS> getSingleComponents(CoordinateReferenceSystem crs) {
        List<SingleCRS> singles;
        if (crs == null) {
            singles = List.of();
        } else if (crs instanceof CompoundCRS) {
            if (crs instanceof DefaultCompoundCRS) {
                singles = ((DefaultCompoundCRS)crs).getSingleComponents();
            } else {
                List<CoordinateReferenceSystem> elements = ((CompoundCRS)crs).getComponents();
                singles = new ArrayList<SingleCRS>(elements.size());
                ReferencingUtilities.getSingleComponents(elements, singles);
            }
        } else {
            singles = List.of((SingleCRS)crs);
        }
        return singles;
    }

    public static CoordinateReferenceSystem getComponentAt(CoordinateReferenceSystem crs, int lower, int upper) {
        if (crs == null) {
            return null;
        }
        int dimension = ReferencingUtilities.getDimension(crs);
        ArgumentChecks.ensureValidIndexRange(dimension, lower, upper);
        block0: while (lower != 0 || upper != dimension) {
            if (crs instanceof CompoundCRS) {
                List<CoordinateReferenceSystem> components = ((CompoundCRS)crs).getComponents();
                int size = components.size();
                for (int i = 0; i < size; ++i) {
                    crs = components.get(i);
                    dimension = crs.getCoordinateSystem().getDimension();
                    if (lower < dimension) continue block0;
                    lower -= dimension;
                    upper -= dimension;
                }
            }
            return null;
        }
        return crs;
    }

    public static double getGreenwichLongitude(GeodeticCRS crs) {
        ArgumentChecks.ensureNonNull("crs", crs);
        return ReferencingUtilities.getGreenwichLongitude(crs.getDatum().getPrimeMeridian(), Units.DEGREE);
    }

    public static CRSAuthorityFactory getAuthorityFactory(String authority) throws FactoryException {
        if (authority == null) {
            return AuthorityFactories.ALL;
        }
        return AuthorityFactories.ALL.getAuthorityFactory(CRSAuthorityFactory.class, authority, null);
    }

    private static void unexpectedException(String methodName, Exception exception) {
        Logging.unexpectedException(LOGGER, CRS.class, methodName, exception);
    }
}

