/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.G;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.QuadTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb1.transaction.DatasetGraphTransaction;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public abstract class GraphTDB
extends GraphView
implements Closeable,
Sync {
    private static Function<Tuple<NodeId>, Tuple<NodeId>> project4TupleTo3Tuple = item -> {
        if (item.len() != 4) {
            throw new TDB1Exception("Expected a Tuple of 4, got: " + String.valueOf(item));
        }
        return TupleFactory.tuple((NodeId)item.get(1), (NodeId)item.get(2), (NodeId)item.get(3));
    };

    public GraphTDB(DatasetGraph dataset, Node graphName) {
        super(dataset, graphName);
    }

    public abstract DatasetGraphTDB getDatasetGraphTDB();

    public abstract DatasetGraphTransaction getDatasetGraphTransaction();

    protected abstract DatasetGraphTDB getBaseDatasetGraphTDB();

    public NodeTupleTable getNodeTupleTable() {
        return this.getDatasetGraphTDB().chooseNodeTupleTable(this.getGraphName());
    }

    @Override
    public final void sync() {
        this.getDatasetGraphTDB().sync();
    }

    @Override
    public final void close() {
        this.sync();
        super.close();
    }

    @Override
    protected ExtendedIterator<Triple> graphUnionFind(Node s, Node p, Node o) {
        Iterator<Quad> iterQuads = this.getDatasetGraphTDB().find(Quad.unionGraph, s, p, o);
        Iterator<Triple> iter = G.quads2triples(iterQuads);
        iter = Iter.distinctAdjacent(iter);
        return WrappedIterator.createNoRemove(iter);
    }

    @Override
    protected final int graphBaseSize() {
        if (this.isDefaultGraph()) {
            return (int)this.getNodeTupleTable().size();
        }
        Node gn = this.getGraphName();
        boolean unionGraph = GraphTDB.isUnionGraph(gn);
        gn = unionGraph ? Node.ANY : gn;
        QuadTable quadTable = this.getDatasetGraphTDB().getQuadTable();
        Iterator<Tuple<NodeId>> iter = quadTable.getNodeTupleTable().findAsNodeIds(gn, null, null, null);
        if (unionGraph) {
            iter = Iter.map(iter, project4TupleTo3Tuple);
            iter = Iter.distinctAdjacent(iter);
        }
        return (int)Iter.count(iter);
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        if (this.getEventManager().listening()) {
            super.remove(s, p, o);
            return;
        }
        this.getDatasetGraphTDB().deleteAny(this.getGraphName(), s, p, o);
    }
}

