/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.solver;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.tdb1.solver.BindingNodeId;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTable;

class StageMatchTuple {
    private static Function<Tuple<NodeId>, Tuple<NodeId>> quadsToAnyTriples = item -> TupleFactory.create4(NodeId.NodeIdAny, (NodeId)item.get(1), (NodeId)item.get(2), (NodeId)item.get(3));

    StageMatchTuple() {
    }

    static Iterator<BindingNodeId> access(NodeTupleTable nodeTupleTable, Iterator<BindingNodeId> input, Tuple<Node> patternTuple, Predicate<Tuple<NodeId>> filter, boolean anyGraph, ExecutionContext execCxt) {
        return Iter.flatMap(input, bnid -> StageMatchTuple.access(nodeTupleTable, bnid, patternTuple, filter, anyGraph, execCxt));
    }

    private static Iterator<BindingNodeId> access(NodeTupleTable nodeTupleTable, BindingNodeId input, Tuple<Node> patternTuple, Predicate<Tuple<NodeId>> filter, boolean anyGraph, ExecutionContext execCxt) {
        NodeId[] ids = new NodeId[patternTuple.len()];
        Var[] vars = new Var[patternTuple.len()];
        boolean b = StageMatchTuple.prepare(nodeTupleTable.getNodeTable(), patternTuple, input, ids, vars);
        if (!b) {
            return Iter.nullIterator();
        }
        Iterator<Tuple<NodeId>> iterMatches = nodeTupleTable.find(TupleFactory.create(ids));
        AtomicBoolean cancelSignal = execCxt.getCancelSignal();
        if (cancelSignal != null) {
            iterMatches = Iter.map(iterMatches, x -> {
                if (cancelSignal.get()) {
                    throw new QueryCancelledException();
                }
                return x;
            });
        }
        if (filter != null) {
            iterMatches = Iter.filter(iterMatches, filter);
        }
        if (anyGraph) {
            iterMatches = Iter.map(iterMatches, quadsToAnyTriples);
            iterMatches = Iter.distinctAdjacent(iterMatches);
        }
        Function<Tuple, BindingNodeId> binder = tuple -> StageMatchTuple.tupleToBinding(input, tuple, vars);
        return Iter.iter(iterMatches).map(binder).removeNulls();
    }

    private static BindingNodeId tupleToBinding(BindingNodeId input, Tuple<NodeId> tuple, Var[] var) {
        BindingNodeId output = new BindingNodeId(input);
        for (int i = 0; i < var.length; ++i) {
            Var v = var[i];
            if (v == null) continue;
            NodeId id = tuple.get(i);
            if (!StageMatchTuple.compatible(output, v, id)) {
                return null;
            }
            output.put(v, id);
        }
        return output;
    }

    private static boolean prepare(NodeTable nodeTable, Tuple<Node> patternTuple, BindingNodeId input, NodeId[] ids, Var[] var) {
        for (int i = 0; i < patternTuple.len(); ++i) {
            Node n = patternTuple.get(i);
            NodeId nId = StageMatchTuple.idFor(nodeTable, input, n);
            if (NodeId.isDoesNotExist(nId)) {
                return false;
            }
            ids[i] = nId;
            if (nId != null) continue;
            var[i] = StageMatchTuple.asVar(n);
        }
        return true;
    }

    private static Iterator<Tuple<NodeId>> print(Iterator<Tuple<NodeId>> iter) {
        if (!iter.hasNext()) {
            System.err.println("<empty>");
        } else {
            List<Tuple<NodeId>> r = Iter.toList(iter);
            String str2 = StrUtils.strjoin(r, "\n");
            System.err.println(str2);
            iter = Iter.iter(r);
        }
        return iter;
    }

    private static boolean compatible(BindingNodeId output, Var var, NodeId value) {
        if (!output.containsKey(var)) {
            return true;
        }
        return ((NodeId)output.get(var)).equals(value);
    }

    private static Var asVar(Node node) {
        if (Var.isVar(node)) {
            return Var.alloc(node);
        }
        return null;
    }

    private static NodeId idFor(NodeTable nodeTable, BindingNodeId input, Node node) {
        if (Var.isVar(node)) {
            NodeId n = (NodeId)input.get(Var.alloc(node));
            return n;
        }
        return nodeTable.getNodeIdForNode(node);
    }
}

