/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.cmds;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.main.sys.FusekiServerArgsCustomiser;

class ArgCustomizers {
    private static List<FusekiServerArgsCustomiser> customisers = null;
    private static Supplier<List<FusekiServerArgsCustomiser>> supplierSystemCustomizers = () -> {
        List<FusekiModule> x = FusekiModules.getSystemModules().asList();
        return x.stream().map(z -> z).toList();
    };

    private ArgCustomizers() {
    }

    static void addCustomiser(FusekiServerArgsCustomiser customiser) {
        Objects.requireNonNull(customiser);
        if (customisers == null) {
            customisers = new ArrayList<FusekiServerArgsCustomiser>();
        }
        customisers.add(customiser);
    }

    static void resetCustomisers() {
        customisers = null;
    }

    static List<FusekiServerArgsCustomiser> get() {
        if (customisers == null) {
            return supplierSystemCustomizers.get();
        }
        return customisers;
    }
}

