/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.binary;

import java.io.InputStream;
import java.util.LinkedHashMap;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfpatch.PatchException;
import org.apache.jena.rdfpatch.PatchHeader;
import org.apache.jena.rdfpatch.PatchProcessor;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.RDFPatch;
import org.apache.jena.rdfpatch.changes.RDFChangesCollector;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.wire.PatchTxn;
import org.apache.jena.riot.thrift.wire.Patch_Data_Add;
import org.apache.jena.riot.thrift.wire.Patch_Data_Del;
import org.apache.jena.riot.thrift.wire.Patch_Header;
import org.apache.jena.riot.thrift.wire.Patch_Prefix_Add;
import org.apache.jena.riot.thrift.wire.Patch_Prefix_Del;
import org.apache.jena.riot.thrift.wire.RDF_Literal;
import org.apache.jena.riot.thrift.wire.RDF_Patch_Row;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.riot.thrift.wire.RDF_Triple;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransportException;

public class RDFPatchReaderBinary
implements PatchProcessor {
    private final InputStream input;

    private RDFPatchReaderBinary(InputStream input) {
        this.input = input;
    }

    @Override
    public void apply(RDFChanges processor) {
        RDFPatchReaderBinary.read(this.input, processor);
    }

    public static PatchProcessor create(InputStream input) {
        return new RDFPatchReaderBinary(input);
    }

    public static RDFPatch read(InputStream input) {
        RDFChangesCollector changes = new RDFChangesCollector();
        RDFPatchReaderBinary.read(input, (RDFChanges)changes);
        return changes.getRDFPatch();
    }

    public static PatchHeader readHeader(InputStream input) {
        TProtocol protocol = TRDF.protocol((InputStream)input);
        return RDFPatchReaderBinary.readHeader(protocol);
    }

    private static PatchHeader readHeader(TProtocol protocol) {
        RDF_Patch_Row row = new RDF_Patch_Row();
        LinkedHashMap<String, Node> header = new LinkedHashMap<String, Node>();
        while (true) {
            row.clear();
            try {
                row.read(protocol);
            }
            catch (TTransportException e) {
                if (e.getType() == 4) break;
                throw new PatchException("Thrift exception", e);
            }
            catch (TException e) {
                throw new PatchException("Thrift exception", e);
            }
            if (!row.isSetHeader()) break;
            Patch_Header h = row.getHeader();
            Node n = RDFPatchReaderBinary.fromThrift(h.getValue());
            header.put(h.getName(), n);
        }
        return new PatchHeader(header);
    }

    public static void read(InputStream input, RDFChanges changes) {
        RDFPatchReaderBinary.read(TRDF.protocol((InputStream)input), changes);
    }

    public static void read(TProtocol protocol, RDFChanges changes) {
        RDF_Patch_Row row = new RDF_Patch_Row();
        changes.start();
        while (true) {
            row.clear();
            try {
                row.read(protocol);
            }
            catch (TTransportException e) {
                if (e.getType() == 4) {
                    changes.finish();
                    return;
                }
                throw new PatchException("Thrift exception", e);
            }
            catch (TException e) {
                throw new PatchException("Thrift exception", e);
            }
            RDFPatchReaderBinary.dispatch(row, changes);
        }
    }

    private static void dispatch(RDF_Patch_Row row, RDFChanges changes) {
        if (row.isSetHeader()) {
            Patch_Header h = row.getHeader();
            Node n = RDFPatchReaderBinary.fromThrift(h.getValue());
            changes.header(h.getName(), n);
            return;
        }
        if (row.isSetDataAdd()) {
            Patch_Data_Add add = row.getDataAdd();
            Node s = RDFPatchReaderBinary.fromThrift(add.getS());
            Node p = RDFPatchReaderBinary.fromThrift(add.getP());
            Node o = RDFPatchReaderBinary.fromThrift(add.getO());
            Node g = null;
            if (add.isSetG()) {
                g = RDFPatchReaderBinary.fromThrift(add.getG());
            }
            changes.add(g, s, p, o);
            return;
        }
        if (row.isSetDataDel()) {
            Patch_Data_Del del = row.getDataDel();
            Node s = RDFPatchReaderBinary.fromThrift(del.getS());
            Node p = RDFPatchReaderBinary.fromThrift(del.getP());
            Node o = RDFPatchReaderBinary.fromThrift(del.getO());
            Node g = null;
            if (del.isSetG()) {
                g = RDFPatchReaderBinary.fromThrift(del.getG());
            }
            changes.delete(g, s, p, o);
            return;
        }
        if (row.isSetPrefixAdd()) {
            Patch_Prefix_Add add = row.getPrefixAdd();
            Node gn = null;
            if (add.isSetGraphNode()) {
                gn = RDFPatchReaderBinary.fromThrift(add.getGraphNode());
            }
            changes.addPrefix(gn, add.getPrefix(), add.getIriStr());
            return;
        }
        if (row.isSetPrefixDel()) {
            Patch_Prefix_Del del = row.getPrefixDel();
            Node gn = null;
            if (del.isSetGraphNode()) {
                gn = RDFPatchReaderBinary.fromThrift(del.getGraphNode());
            }
            changes.deletePrefix(gn, del.getPrefix());
            return;
        }
        if (row.isSetTxn()) {
            PatchTxn txn = row.getTxn();
            switch (txn) {
                case TX: {
                    changes.txnBegin();
                    break;
                }
                case TC: {
                    changes.txnCommit();
                    break;
                }
                case TA: {
                    changes.txnAbort();
                    break;
                }
                case Segment: {
                    changes.segment();
                }
            }
            return;
        }
        throw new PatchException("Unrecogized :" + String.valueOf(row));
    }

    public static Node fromThrift(RDF_Term term) {
        if (term.isSetIri()) {
            return NodeFactory.createURI((String)term.getIri().getIri());
        }
        if (term.isSetBnode()) {
            return NodeFactory.createBlankNode((String)term.getBnode().getLabel());
        }
        if (term.isSetLiteral()) {
            RDF_Literal lit = term.getLiteral();
            String lex = lit.getLex();
            String dtString = null;
            if (lit.isSetDatatype()) {
                dtString = lit.getDatatype();
            }
            RDFDatatype dt = NodeFactory.getType(dtString);
            String lang = lit.getLangtag();
            return NodeFactory.createLiteral((String)lex, (String)lang, (RDFDatatype)dt);
        }
        if (term.isSetTripleTerm()) {
            RDF_Triple rt = term.getTripleTerm();
            Node s = RDFPatchReaderBinary.fromThrift(rt.getS());
            Node p = RDFPatchReaderBinary.fromThrift(rt.getP());
            Node o = RDFPatchReaderBinary.fromThrift(rt.getO());
            Triple t = Triple.create((Node)s, (Node)p, (Node)o);
            return NodeFactory.createTripleTerm((Triple)t);
        }
        throw new PatchException("No conversion to a Node: " + term.toString());
    }
}

