/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.rdf.model.RDFNode;

public class OntPersonalityImpl
extends Personality<RDFNode>
implements OntPersonality {
    private final String name;
    private final OntConfig config;
    private final OntPersonality.Punnings punnings;
    private final OntPersonality.Builtins builtins;
    private final OntPersonality.Reserved reserved;
    private final Map<Class<? extends OntObject>, Set<String>> forbidden;

    public OntPersonalityImpl(String name, OntConfig config, OntPersonality.Punnings punnings, OntPersonality.Builtins builtins, OntPersonality.Reserved reserved) {
        this.name = name;
        this.config = Objects.requireNonNull(config, "Null config");
        this.builtins = Objects.requireNonNull(builtins, "Null builtins vocabulary");
        this.punnings = Objects.requireNonNull(punnings, "Null punnings vocabulary");
        this.reserved = Objects.requireNonNull(reserved, "Null reserved vocabulary");
        this.forbidden = OntPersonalityImpl.collectForbiddenResources(reserved, builtins);
    }

    private static Map<Class<? extends OntObject>, Set<String>> collectForbiddenResources(OntPersonality.Reserved reserved, OntPersonality.Builtins builtins) {
        HashMap<Class<? extends OntObject>, Set<String>> forbidden = new HashMap<Class<? extends OntObject>, Set<String>>();
        Set<Node> reservedResources = reserved.getAllResources();
        builtins.supportedTypes().forEach(type -> {
            Set<Node> allowedResources = builtins.get(type);
            Set forbiddenResources = reservedResources.stream().filter(it -> it.isURI() && !allowedResources.contains(it)).map(Node::getURI).collect(Collectors.toUnmodifiableSet());
            forbidden.put((Class<? extends OntObject>)type, forbiddenResources);
        });
        return forbidden;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OntPersonality.Builtins getBuiltins() {
        return this.builtins;
    }

    @Override
    public OntPersonality.Punnings getPunnings() {
        return this.punnings;
    }

    @Override
    public OntPersonality.Reserved getReserved() {
        return this.reserved;
    }

    @Override
    public OntConfig getConfig() {
        return this.config;
    }

    @Override
    public Set<String> forbidden(Class<? extends OntObject> type) {
        return this.forbidden.getOrDefault(type, Set.of());
    }

    public void register(Class<? extends OntObject> type, EnhNodeFactory factory) {
        this.register(type, EnhNodeFactory.asJenaImplementation(factory));
    }

    public void register(Class<? extends RDFNode> type, Implementation factory) {
        super.add(Objects.requireNonNull(type, "Null type."), factory);
    }

    public void unregister(Class<? extends OntObject> view) {
        this.getMap().remove(view);
    }

    @Override
    public Stream<Class<? extends RDFNode>> types() {
        return this.getMap().keySet().stream();
    }

    @Override
    public EnhNodeFactory getObjectFactory(Class<? extends RDFNode> type) {
        Implementation implementation = this.getImplementation(type);
        OntJenaException.checkSupported(implementation != null, "Profile " + this.name + " does not support language construct " + OntEnhNodeFactories.viewAsString(type));
        if (implementation instanceof EnhNodeFactory) {
            return (EnhNodeFactory)implementation;
        }
        return (EnhNodeFactory)OntJenaException.TODO("Not implemented yet");
    }

    @Override
    public boolean supports(Class<? extends RDFNode> type) {
        return this.getMap().containsKey(type);
    }

    public OntPersonalityImpl add(Personality<RDFNode> other) {
        super.add(other);
        return this;
    }

    @Override
    public OntPersonalityImpl copy() {
        OntPersonalityImpl res = new OntPersonalityImpl(this.getName(), this.getConfig(), this.getPunnings(), this.getBuiltins(), this.getReserved());
        res.add(this);
        return res;
    }
}

