/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.postgres;

import jakarta.inject.Inject;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryFactory;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.postgres.PostgresMailRepository;
import org.apache.james.mailrepository.postgres.PostgresMailRepositoryContentDAO;

public class PostgresMailRepositoryFactory
implements MailRepositoryFactory {
    private final PostgresExecutor executor;
    private final MimeMessageStore.Factory mimeMessageStoreFactory;
    private final BlobId.Factory blobIdFactory;

    @Inject
    public PostgresMailRepositoryFactory(PostgresExecutor executor, MimeMessageStore.Factory mimeMessageStoreFactory, BlobId.Factory blobIdFactory) {
        this.executor = executor;
        this.mimeMessageStoreFactory = mimeMessageStoreFactory;
        this.blobIdFactory = blobIdFactory;
    }

    public Class<? extends MailRepository> mailRepositoryClass() {
        return PostgresMailRepository.class;
    }

    public MailRepository create(MailRepositoryUrl url) {
        return new PostgresMailRepository(url, new PostgresMailRepositoryContentDAO(this.executor, this.mimeMessageStoreFactory, this.blobIdFactory));
    }
}

