/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.onami.lifecycle;

import com.google.inject.AbstractModule;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.james.onami.lifecycle.AbstractMethodTypeListener;

public abstract class LifeCycleModule
extends AbstractModule {
    protected final void bindLifeCycle(Class<? extends Annotation> annotation) {
        this.bindLifeCycle(annotation, Matchers.any());
    }

    protected final void bindLifeCycle(Class<? extends Annotation> annotation, Matcher<? super TypeLiteral<?>> typeMatcher) {
        this.bindLifeCycle(Arrays.asList(annotation), typeMatcher);
    }

    protected final void bindLifeCycle(List<? extends Class<? extends Annotation>> annotations, Matcher<? super TypeLiteral<?>> typeMatcher) {
        this.bindListener(typeMatcher, new AbstractMethodTypeListener(this, annotations){

            @Override
            protected <I> void hear(Method method, TypeLiteral<I> parentType, TypeEncounter<I> encounter, Class<? extends Annotation> annotationType) {
                encounter.register(injectee -> {
                    try {
                        method.invoke(injectee, new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ProvisionException(String.format("Method @%s %s requires arguments", annotationType.getName(), method), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ProvisionException(String.format("Impossible to access to @%s %s on %s", annotationType.getName(), method, injectee), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ProvisionException(String.format("An error occurred while invoking @%s %s on %s", annotationType.getName(), method, injectee), e.getCause());
                    }
                });
            }
        });
    }
}

