/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.jmap.api.identity.IdentityCreationRequest;
import org.apache.james.jmap.api.identity.IdentityUpdateRequest;
import org.apache.james.jmap.api.model.Identity;
import scala.Option;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class UserIdentity {
    private String name;
    private String email;
    private String id;
    private Boolean mayDelete;
    private String textSignature;
    private String htmlSignature;
    private Integer sortOrder;
    private List<EmailAddress> bcc;
    private List<EmailAddress> replyTo;

    public static UserIdentity from(Identity identity) {
        return new UserIdentity(identity.name(), identity.email().asString(), identity.id().id().toString(), identity.mayDelete(), identity.textSignature(), identity.htmlSignature(), identity.sortOrder(), UserIdentity.getBccFromIdentity(identity), UserIdentity.getReplyFromIdentity(identity));
    }

    private static List<EmailAddress> getBccFromIdentity(Identity identity) {
        return OptionConverters.toJava((Option)identity.bcc()).map(CollectionConverters::asJava).orElseGet(List::of).stream().map(EmailAddress::from).collect(Collectors.toList());
    }

    private static List<EmailAddress> getReplyFromIdentity(Identity identity) {
        return OptionConverters.toJava((Option)identity.replyTo()).map(CollectionConverters::asJava).orElseGet(List::of).stream().map(EmailAddress::from).collect(Collectors.toList());
    }

    public UserIdentity(String name, String email, String id, Boolean mayDelete, String textSignature, String htmlSignature, Integer sortOrder, List<EmailAddress> bcc, List<EmailAddress> replyTo) {
        this.name = name;
        this.email = email;
        this.id = id;
        this.mayDelete = mayDelete;
        this.textSignature = textSignature;
        this.htmlSignature = htmlSignature;
        this.sortOrder = sortOrder;
        this.bcc = bcc;
        this.replyTo = replyTo;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getMayDelete() {
        return this.mayDelete;
    }

    public String getTextSignature() {
        return this.textSignature;
    }

    public String getHtmlSignature() {
        return this.htmlSignature;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public List<EmailAddress> getBcc() {
        return this.bcc;
    }

    public List<EmailAddress> getReplyTo() {
        return this.replyTo;
    }

    public static class UserIdentityUpsert {
        private final String name;
        private final String email;
        private final String textSignature;
        private final String htmlSignature;
        private final Integer sortOrder;
        private final List<EmailAddress> bcc;
        private final List<EmailAddress> replyTo;

        @JsonCreator
        public UserIdentityUpsert(@JsonProperty(value="name") String name, @JsonProperty(value="email") String email, @JsonProperty(value="textSignature") String textSignature, @JsonProperty(value="htmlSignature") String htmlSignature, @JsonProperty(value="sortOrder") Integer sortOrder, @JsonProperty(value="bcc") List<EmailAddress> bcc, @JsonProperty(value="replyTo") List<EmailAddress> replyTo) {
            this.name = name;
            this.email = email;
            this.textSignature = textSignature;
            this.htmlSignature = htmlSignature;
            this.sortOrder = sortOrder;
            this.bcc = bcc;
            this.replyTo = replyTo;
        }

        public IdentityCreationRequest asCreationRequest() throws AddressException {
            Preconditions.checkArgument((this.email != null ? 1 : 0) != 0, (Object)"email must be not null");
            return IdentityCreationRequest.fromJava((MailAddress)new MailAddress(this.email), Optional.ofNullable(this.name), Optional.ofNullable(this.replyTo).map(rt -> rt.stream().map(Throwing.function(EmailAddress::asScalaEmailAddress)).collect(Collectors.toList())), Optional.ofNullable(this.bcc).map(rt -> rt.stream().map(Throwing.function(EmailAddress::asScalaEmailAddress)).collect(Collectors.toList())), Optional.ofNullable(this.sortOrder), Optional.ofNullable(this.textSignature), Optional.ofNullable(this.htmlSignature));
        }

        public IdentityUpdateRequest asUpdateRequest() {
            return IdentityUpdateRequest.fromJava(Optional.ofNullable(this.name), Optional.ofNullable(this.replyTo).map(rt -> rt.stream().map(Throwing.function(EmailAddress::asScalaEmailAddress)).collect(Collectors.toList())), Optional.ofNullable(this.bcc).map(rt -> rt.stream().map(Throwing.function(EmailAddress::asScalaEmailAddress)).collect(Collectors.toList())), Optional.ofNullable(this.sortOrder), Optional.ofNullable(this.textSignature), Optional.ofNullable(this.htmlSignature));
        }
    }

    public static class EmailAddress {
        @JsonProperty(value="name")
        private String emailerName;
        @JsonProperty(value="email")
        private String mailAddress;

        public static EmailAddress from(org.apache.james.jmap.api.model.EmailAddress scala) {
            return new EmailAddress(scala.nameAsString(), scala.email());
        }

        public EmailAddress(String emailerName, MailAddress mailAddress) {
            this.emailerName = emailerName;
            this.mailAddress = mailAddress.asString();
        }

        @JsonCreator
        public EmailAddress(@JsonProperty(value="name") String emailerName, @JsonProperty(value="email") String mailAddress) {
            this.emailerName = emailerName;
            this.mailAddress = mailAddress;
        }

        public String getEmailerName() {
            return this.emailerName;
        }

        public String getMailAddress() {
            return this.mailAddress;
        }

        public org.apache.james.jmap.api.model.EmailAddress asScalaEmailAddress() throws AddressException {
            return org.apache.james.jmap.api.model.EmailAddress.from(Optional.ofNullable(this.getEmailerName()), (MailAddress)new MailAddress(this.getMailAddress()));
        }
    }
}

