/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.onami.lifecycle;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.james.onami.lifecycle.AbstractMethodTypeListener;
import org.apache.james.onami.lifecycle.LifeCycleModule;
import org.apache.james.onami.lifecycle.NoOpStageableTypeMapper;
import org.apache.james.onami.lifecycle.StageableMethod;
import org.apache.james.onami.lifecycle.StageableTypeMapper;
import org.apache.james.onami.lifecycle.Stager;

public abstract class LifeCycleStageModule
extends LifeCycleModule {
    private List<BindingBuilder<?>> bindings;

    public static <A extends Annotation> Key<Stager<A>> key(Class<A> stage) {
        return Key.get(LifeCycleStageModule.type(stage));
    }

    private static <A extends Annotation> TypeLiteral<Stager<A>> type(Class<A> stage) {
        ParameterizedType parameterizedType = Types.newParameterizedTypeWithOwner(null, Stager.class, (Type[])new Type[]{stage});
        TypeLiteral stagerType = TypeLiteral.get((Type)parameterizedType);
        return stagerType;
    }

    protected final void configure() {
        if (this.bindings != null) {
            throw new IllegalStateException("Re-entry is not allowed");
        }
        this.bindings = new ArrayList();
        try {
            this.configureBindings();
            for (BindingBuilder<?> binding : this.bindings) {
                this.bind(binding);
            }
        }
        finally {
            this.bindings = null;
        }
    }

    private <A extends Annotation> void bind(BindingBuilder<A> binding) {
        final Stager stager = binding.stager;
        final StageableTypeMapper typeMapper = binding.typeMapper;
        this.bind(LifeCycleStageModule.type(stager.getStage())).toInstance(stager);
        this.bindListener(binding.typeMatcher, new AbstractMethodTypeListener(Arrays.asList(stager.getStage())){

            @Override
            protected <I> void hear(Method stageMethod, TypeLiteral<I> parentType, TypeEncounter<I> encounter, Class<? extends Annotation> annotationType) {
                encounter.register(injectee -> {
                    StageableMethod stageable = new StageableMethod(stageMethod, injectee);
                    stager.register(stageable);
                    typeMapper.registerType(stageable, parentType);
                });
            }
        });
    }

    protected abstract void configureBindings();

    protected final <A extends Annotation> MapperBinding bindStager(Stager<A> stager) {
        BindingBuilder<A> builder = new BindingBuilder<A>(LifeCycleStageModule.checkNotNull(stager, "Argument 'stager' must be not null"));
        this.bindings.add(builder);
        return builder;
    }

    private static <T> T checkNotNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    private static class BindingBuilder<A extends Annotation>
    implements MapperBinding {
        private Matcher<? super TypeLiteral<?>> typeMatcher = Matchers.any();
        private final Stager<A> stager;
        private StageableTypeMapper typeMapper = new NoOpStageableTypeMapper();

        public BindingBuilder(Stager<A> stager) {
            this.stager = stager;
        }

        @Override
        public MatcherBinding mappingWith(StageableTypeMapper typeMapper) {
            this.typeMapper = LifeCycleStageModule.checkNotNull(typeMapper, "Argument 'typeMapper' must be not null.");
            return this;
        }

        @Override
        public void matching(Matcher<? super TypeLiteral<?>> typeMatcher) {
            this.typeMatcher = LifeCycleStageModule.checkNotNull(typeMatcher, "Argument 'typeMatcher' must be not null");
        }
    }

    protected static interface MapperBinding
    extends MatcherBinding {
        public MatcherBinding mappingWith(StageableTypeMapper var1);
    }

    protected static interface MatcherBinding {
        public void matching(Matcher<? super TypeLiteral<?>> var1);
    }
}

