/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.memory;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.AbstractDomainList;

public class MemoryDomainList
extends AbstractDomainList {
    private final List<Domain> domains = new ArrayList<Domain>();

    @Inject
    public MemoryDomainList(DNSService dns) {
        super(dns);
    }

    protected List<Domain> getDomainListInternal() {
        return ImmutableList.copyOf(this.domains);
    }

    protected boolean containsDomainInternal(Domain domain) {
        return this.domains.contains(domain);
    }

    public void addDomain(Domain domain) throws DomainListException {
        if (this.containsDomain(domain)) {
            throw new DomainListException(domain.name() + " already exists.");
        }
        this.domains.add(domain);
    }

    public void doRemoveDomain(Domain domain) throws DomainListException {
        if (!this.domains.remove(domain)) {
            throw new DomainListException(domain.name() + " was not found");
        }
    }
}

