/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.ratis.metrics.Timekeeper;

public class TimerProxy
implements Timekeeper {
    private final Timer timer;

    TimerProxy(Timer timer) {
        this.timer = timer;
    }

    public Timekeeper.Context time() {
        return new TimerContext(this.timer);
    }

    private static class TimerContext
    implements Timekeeper.Context {
        private final Timer reporter;
        private final long startTime;

        TimerContext(Timer reporter) {
            this.reporter = reporter;
            this.startTime = System.nanoTime();
        }

        public long stop() {
            long elapsed = System.nanoTime() - this.startTime;
            this.reporter.update(elapsed, TimeUnit.NANOSECONDS);
            return elapsed;
        }
    }
}

